/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.vacuum.data;

import java.io.Serializable;
import org.lsst.ccs.subsystem.vacuum.constants.ConditionState;
import org.lsst.ccs.subsystem.vacuum.constants.DeviceState;
import org.lsst.ccs.subsystem.vacuum.constants.SwitchEnable;
import org.lsst.ccs.subsystem.vacuum.constants.SwitchState;

public class VacuumState
implements Serializable {
    public static final String KEY = "VacuumState";
    public static final int SW_CRYO_TURBO = 0;
    public static final int SW_CRYO_ION_PUMP1 = 1;
    public static final int SW_CRYO_ION_PUMP2 = 2;
    public static final int SW_CRYO_ION_PUMP3 = 3;
    public static final int SW_CRYO_ION_PUMP4 = 4;
    public static final int SW_CRYO_ION_PUMP5 = 5;
    public static final int SW_CRYO_ION_PUMP6 = 6;
    public static final int SW_CRYO_VALVE = 7;
    public static final int SW_HX_TURBO = 8;
    public static final int SW_HX_ION_PUMP1 = 9;
    public static final int SW_HX_ION_PUMP2 = 10;
    public static final int SW_HX_VALVE = 11;
    public static final int SW_OR_ION_PUMP = 12;
    public static final int SW_OR_FPP_VALVE = 13;
    public static final int SW_OR_FH_VALVE = 14;
    public static final int SW_OR_L3H_VALVE = 15;
    public static final int SW_OR_L3_VALVE = 16;
    public static final int NUM_SWITCHES = 17;
    public static final int COND_CR_VACUUM = 0;
    public static final int COND_CR_GATE_NFC = 1;
    public static final int COND_CR_GATE_AO = 2;
    public static final int COND_CR_PUMP = 3;
    public static final int COND_HX_VACUUM = 4;
    public static final int COND_HX_GATE_NFC = 5;
    public static final int COND_HX_GATE_AO = 6;
    public static final int COND_HX_PUMP = 7;
    public static final int NUM_CONDITIONS = 8;
    private int tickMillis;
    private int switchMask;
    private int conditionMask;
    private final SwitchState[] switchState = new SwitchState[17];
    private final SwitchEnable[] switchEnable = new SwitchEnable[17];
    private final DeviceState[] deviceState = new DeviceState[17];
    private final ConditionState[] conditionState = new ConditionState[8];
    private static final long serialVersionUID = -838278252519832878L;

    public void setTickMillis(int value) {
        this.tickMillis = value;
    }

    public int getTickMillis() {
        return this.tickMillis;
    }

    public void addSwitch(int sw) {
        this.switchMask |= 1 << sw;
    }

    public boolean hasSwitch(int sw) {
        return (this.switchMask & 1 << sw) != 0;
    }

    public void setSwitchState(int sw, SwitchState state) {
        this.switchState[sw] = state;
    }

    public SwitchState getSwitchState(int sw) {
        return this.switchState[sw];
    }

    public void setSwitchEnable(int sw, SwitchEnable enable) {
        this.switchEnable[sw] = enable;
    }

    public SwitchEnable getSwitchEnable(int sw) {
        return this.switchEnable[sw];
    }

    public void setDeviceState(int sw, DeviceState state) {
        this.deviceState[sw] = state;
    }

    public DeviceState getDeviceState(int sw) {
        return this.deviceState[sw];
    }

    public void addCondition(int cond) {
        this.conditionMask |= 1 << cond;
    }

    public boolean hasCondition(int cond) {
        return (this.conditionMask & 1 << cond) != 0;
    }

    public void setCondition(int cond, ConditionState state) {
        this.conditionState[cond] = state;
    }

    public ConditionState getCondition(int cond) {
        return this.conditionState[cond];
    }
}

