/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.Color;
import java.util.Objects;
import java.util.function.Consumer;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorCell;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;

public class FormattedValue {
    public static final FormattedValue NA = new FormattedValue("", MonitorField.COLOR_FG, MonitorField.COLOR_NA, 0, "Unknown", false);
    public static final FormattedValue EMPTY = new FormattedValue("", MonitorField.COLOR_FG, MonitorField.COLOR_BG, 0, null, false);
    public String text;
    public Color fgColor;
    public Color bgColor;
    public Integer horizontalAlignment;
    public String toolTip;
    public Boolean editable;
    public Consumer<MonitorCell> click1;
    public Object value;
    public String format;

    public FormattedValue() {
    }

    public FormattedValue(String text, Color fgColor, Color bgColor, Integer horizontalAlignment, String toolTip, Boolean isEditable) {
        this.text = text;
        this.fgColor = fgColor;
        this.bgColor = bgColor;
        this.horizontalAlignment = horizontalAlignment;
        this.toolTip = toolTip;
        this.editable = isEditable;
    }

    public FormattedValue(FormattedValue other) {
        this.text = other.text;
        this.fgColor = other.fgColor;
        this.bgColor = other.bgColor;
        this.horizontalAlignment = other.horizontalAlignment;
        this.toolTip = other.toolTip;
        this.editable = other.editable;
        this.value = other.value;
        this.format = other.format;
    }

    public FormattedValue(String text, Integer horizontalAlignment) {
        this(text, null, null, horizontalAlignment, null, null);
    }

    public boolean isValid() {
        return this.value == null;
    }

    public String getText() {
        return this.text == null ? "" : this.text;
    }

    public Color getFgColor() {
        return this.fgColor == null ? MonitorField.COLOR_FG : this.fgColor;
    }

    public Color getBgColor() {
        return this.bgColor == null ? MonitorField.COLOR_BG : this.bgColor;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment == null ? 0 : this.horizontalAlignment;
    }

    public String getToolTip() {
        return this.toolTip == null || this.toolTip.trim().isEmpty() ? null : this.toolTip;
    }

    public boolean isEditable() {
        return this.editable == null ? false : this.editable;
    }

    public Consumer<MonitorCell> getClick1() {
        return this.click1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FormattedValue)) {
            return false;
        }
        FormattedValue other = (FormattedValue)obj;
        return Objects.equals(this.text, other.text) && Objects.equals(this.fgColor, other.fgColor) && Objects.equals(this.bgColor, other.bgColor) && Objects.equals(this.horizontalAlignment, other.horizontalAlignment) && Objects.equals(this.toolTip, other.toolTip) && Objects.equals(this.editable, other.editable);
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = result * 31 + (this.text == null ? 0 : this.text.hashCode());
        result = result * 31 + (this.fgColor == null ? 0 : this.fgColor.hashCode());
        result = result * 31 + (this.bgColor == null ? 0 : this.bgColor.hashCode());
        result = result * 31 + (this.horizontalAlignment == null ? 0 : this.horizontalAlignment.hashCode());
        return result;
    }

    public String toString() {
        return this.text;
    }
}

