/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.base.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.annotations.services.persist.Par;
import org.lsst.ccs.gconsole.base.filter.AbstractChannelsFilter;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;

public class ConfigurationFilter
extends AbstractChannelsFilter {
    public static final String CREATOR_PATH = "Built-In/Basic/Configuration";
    public static final String CREATOR_PATH_WHOLECAMERA = "Built-In/Whole Camera/Configuration";
    private final String name;
    private final List<String> agents;
    private final String agent;
    private final String replaceTarget;

    @Create(category="AgentChannelsFilter", name="Configuration", path="Built-In/Basic/Configuration", description="Selects subsystem configuration channels, and maps them to display paths in \"[subsystem/]category//rest/of/path\" format. Subsystem name is included only if multiple subsystems are accepted.")
    public ConfigurationFilter(@Par(def="Config", desc="Filter name.") String name, @Par(def="_null_", desc="List of subsystem names accepted by this filter. If null, all subsystems are accepted.") List<String> subsystems) {
        this.name = name;
        if (subsystems == null) {
            this.agent = null;
            this.agents = null;
            this.replaceTarget = "configuration/";
        } else if (subsystems.size() == 1) {
            this.agent = subsystems.get(0);
            this.agents = null;
            this.replaceTarget = this.agent + "/configuration/";
        } else {
            this.agent = null;
            this.agents = Collections.unmodifiableList(new ArrayList<String>(subsystems));
            this.replaceTarget = "configuration/";
        }
    }

    @Create(category="AgentChannelsFilter", name="Configuration", path="Built-In/Whole Camera/Configuration", description="Selects configuration channels of the whole camera, and maps them to display paths in \"subsystem/category//rest/of/path\" format.")
    public ConfigurationFilter() {
        this("Configuration", null);
    }

    @Override
    public List<String> getAgents() {
        return this.agent == null ? this.agents : Collections.singletonList(this.agent);
    }

    @Override
    public List<String> getOriginChannels() {
        return Collections.singletonList("/configuration/");
    }

    @Override
    public String getDisplayPath(AgentChannel channel) {
        String category = (String)channel.get(AgentChannel.Key.CONFIG_CATEGORY);
        return category == null ? null : channel.getPath().replace(this.replaceTarget, category + "//");
    }

    @Override
    public String getOriginPath(String displayPath) {
        if (this.agent == null) {
            int iA = displayPath.indexOf("/");
            int iC = displayPath.indexOf("//");
            return displayPath.substring(0, iA) + "/configuration/" + displayPath.substring(iC + 2);
        }
        int iC = displayPath.indexOf("//");
        return this.agent + "/configuration/" + displayPath.substring(iC + 2);
    }

    @Override
    public String getName() {
        return this.name;
    }
}

