package org.lsst.ccs.subsystem.vacuum.ui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.TextFieldX;

import java.util.logging.Level;
import java.util.logging.Logger;

import org.lsst.ccs.subsystem.common.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.vacuum.constants.MonitorControl;
import org.lsst.ccs.subsystem.vacuum.constants.SwitchEnable;
import org.lsst.ccs.subsystem.vacuum.constants.Switches;
import org.lsst.ccs.subsystem.vacuum.constants.SwitchState;
import org.lsst.ccs.subsystem.vacuum.constants.DeviceState;

import org.lsst.ccs.subsystem.vacuum.data.VacSysState;

/**
 *  Implements the utility monitoring panel.
 *
 *  @author CCS Team
 */
public class TurboAndPumpCartControlPanel extends JPanel implements UiUtilities.ActionHandler, CommandSender.ReplyHandler {

    static final Font FONT = new java.awt.Font("Tahoma", 1, 12);

    private static final String CMND_GET_STATE = "getVacuumState";
    private static final int SWTP_PUMP = 0, SWTP_VALVE = 1;
    private static final String DSAB_TEXT = "DSAB";
    private final JLabel cryoTurboSwitchStatus = new JLabel("offline"); 
    private final JLabel hxTurboSwitchStatus = new JLabel("offline"); 
    private static final Map<SwitchState, Color> switchStateColors = new HashMap<>();
    static {
        switchStateColors.put(SwitchState.OFF, Color.BLACK);
        switchStateColors.put(SwitchState.ON, UiConstants.GREEN);
        switchStateColors.put(SwitchState.OFFLINE, UiConstants.BLUE);
    }
    //    private static final Map<Integer, String> switchMap = new LinkedHashMap<>();  // Ordered by panel order
    private static final Map<DeviceState, Color> deviceStateColors = new HashMap<>();
    static {
        deviceStateColors.put(DeviceState.AUTOTUN, Color.BLACK);
        deviceStateColors.put(DeviceState.BRAKING, UiConstants.YELLOW);
        deviceStateColors.put(DeviceState.FAILED, UiConstants.RED);
        deviceStateColors.put(DeviceState.NORMAL, UiConstants.GREEN);
        deviceStateColors.put(DeviceState.STARTNG, UiConstants.YELLOW);
        deviceStateColors.put(DeviceState.STOPPED, Color.BLACK);
        deviceStateColors.put(DeviceState.WAITING, UiConstants.YELLOW);
        deviceStateColors.put(DeviceState.OPEN, UiConstants.GREEN);
        deviceStateColors.put(DeviceState.SHUT, Color.BLACK);
        deviceStateColors.put(DeviceState.TRANSIT, UiConstants.YELLOW);
        deviceStateColors.put(DeviceState.ERROR, UiConstants.RED);
        deviceStateColors.put(DeviceState.OFFLINE, UiConstants.BLUE);
    }
    //    private static final int
    //        COND_STATUS_WIDTH = UiUtilities.maxEnumLabelWidth(ConditionState.class);

    private final CommandSender sender;
    private final UiUtilities uiUtils;

    private SystemStatusPanel sysStatPanel;

    private VacSysState last_vs;

    private final JPanel headPanel = new JPanel();

    private static final Logger LOG = Logger.getLogger(TurboAndPumpCartControlPanel.class.getName());

    //    private final JRadioButton[] switchOnRB = new JRadioButton[Switches.NUM_SWITCHES];
    private JRadioButton pumpOn = new JRadioButton();
    private JRadioButton pumpOff = new JRadioButton();

    private JRadioButton ventOn = new JRadioButton();
    private JRadioButton ventOff = new JRadioButton();

    private JRadioButton cryoTurboPumpOn = new JRadioButton();
    private JRadioButton cryoTurboPumpOff = new JRadioButton();

    private JRadioButton cryoTurboVentOn = new JRadioButton();
    private JRadioButton cryoTurboVentOff = new JRadioButton();
    private JButton cryoCloseTurboVent = new JButton();

    private JRadioButton hxTurboPumpOn = new JRadioButton();
    private JRadioButton hxTurboPumpOff = new JRadioButton();

    private JRadioButton hxTurboVentOn = new JRadioButton();
    private JRadioButton hxTurboVentOff = new JRadioButton();
    private JButton hxCloseTurboVent = new JButton();


    private int pulseVentTime = 1; // default is 1 sec of venting
    private JButton pulseVent = new JButton();

    private int pulseCryoTurboVentCnt = 1; // default is 1 pulse
    private JButton closeCryoTurboVent = new JButton();
    private JButton pulseCryoTurboVent = new JButton();

    private int pulseHXTurboVentCnt = 1; // default is 1 pules
    private JButton closeHXTurboVent = new JButton();
    private JButton pulseHXTurboVent = new JButton();

    private final JLabel pulseCryoTurboVentCntLabel = new JLabel("Cryo Pulses: ");
    private final JLabel pulseCryoTurboVentCntUnitsLabel = new JLabel("Cnt");
    private TextFieldX pulseCryoTurboVentCntTextField;

    private final JLabel pulseHXTurboVentCntLabel = new JLabel("HX Pulses: ");
    private final JLabel pulseHXTurboVentCntUnitsLabel = new JLabel("Cnt");
    private TextFieldX pulseHXTurboVentCntTextField;

    private TextFieldX pulseVentPeriodTextField;
    private final JLabel pulseVentPeriodLabel = new JLabel("Pulse Period: ");
    private final JLabel pulseVentPeriodUnitsLabel = new JLabel("            sec");

    private int pulsePumpTime = 1; // default is 1 sec of venting
    private JButton pulsePump = new JButton();

    private double minPumpPressure = 0.;
    private TextFieldX pulsePumpPeriodTextField;
    private final JLabel pulsePumpPeriodLabel = new JLabel("Pulse Period: ");
    private final JLabel pulsePumpPeriodUnitsLabel = new JLabel("            sec");

    private double maxVentPressure = 770;
    private TextFieldX maxVentPressureTextField;
    private final JLabel maxVentPressureLabel = new JLabel("Max Vent P: ");
    private final JLabel maxVentPressureUnitsLabel = new JLabel("               Torr");

    private TextFieldX minPumpPressureTextField;
    private final JLabel minPumpPressureLabel = new JLabel("Min Pump P: ");
    private final JLabel minPumpPressureUnitsLabel = new JLabel("               Torr");

    private JButton abortPump = new JButton();
    private JButton abortVent = new JButton();

    private TextFieldX cryoPrTextField;
    private TextFieldX cryoTurboPrTextField;
    private TextFieldX cryoFlinePrTextField;
    private TextFieldX hxPrTextField;
    private TextFieldX hxTurboPrTextField;
    private TextFieldX hxFlinePrTextField;
    private TextFieldX pcPrTextField;
    private TextFieldX pcPrTextField2;
    private TextFieldX refPrTextField;
    private TextFieldX ventingTextField;
    private TextFieldX cyclingTextField;
    private TextFieldX cryoValveTextField;
    private TextFieldX hxValveTextField;

    private TextFieldX prRefSrcTextField;

    private JPanel pcPanel;
    private JPanel tPanel;

    private ButtonGroup pgroup = new ButtonGroup();
    private ButtonGroup vgroup = new ButtonGroup();

    private ButtonGroup cryotpgroup = new ButtonGroup();
    private ButtonGroup cryotvgroup = new ButtonGroup();

    private ButtonGroup hxtpgroup = new ButtonGroup();
    private ButtonGroup hxtvgroup = new ButtonGroup();

    private volatile VacSysState vacState;
    private final Object vacStateLock = new Object();

    public TurboAndPumpCartControlPanel(CommandSender cons) {
        uiUtils = new UiUtilities(this);
        sender = cons;
        initComponents();
        (new DisablePanel()).run();
    }

    public void initPanel() {
        sender.sendCommand(true, null, CMND_GET_STATE);
    }

    @Override
    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        updatePanel((VacSysState)reply);
    }

    @Override
    public void onCommandReject(String path, String command, Object[] args) {
        if (!command.equals(CMND_GET_STATE)) {
            updatePanel(vacState);
        }
    }
    
    public void updatePanel(VacSysState vss) {
        synchronized(vacStateLock) {
            vacState = vss;
            SwingUtilities.invokeLater(new UpdateVacState(vss));
        }
    }
    
    public void disablePanel() {
        SwingUtilities.invokeLater(new DisablePanel());
    }

    private void initComponents() {

        // System status line
        sysStatPanel = new SystemStatusPanel(sender, MonitorControl.NODE_NAME, true);


        pumpOn = uiUtils.newRadioButton("On","PCPON",true);
        pumpOff = uiUtils.newRadioButton("Off","PCPOFF");
      
        pgroup.add(pumpOn);
        pgroup.add(pumpOff);

        ventOn = uiUtils.newRadioButton("Open","PCVON",true);
        ventOff = uiUtils.newRadioButton("Close","PCVOFF");
      
        vgroup.add(ventOn);
        vgroup.add(ventOff);

        cryoTurboPumpOn = uiUtils.newRadioButton("On","CRYOTPON",true);
        cryoTurboPumpOff = uiUtils.newRadioButton("Off","CRYOTPOFF");

        cryotpgroup.add(cryoTurboPumpOn);
        cryotpgroup.add(cryoTurboPumpOff);

        cryoTurboVentOn = uiUtils.newRadioButton("Open","CRYOTVON",true);
        cryoTurboVentOff = uiUtils.newRadioButton("Close","CRYOTVOFF");
      
        cryotvgroup.add(cryoTurboVentOn);
        cryotvgroup.add(cryoTurboVentOff);
 
        hxTurboPumpOn = uiUtils.newRadioButton("On","HXTPON",true);
        hxTurboPumpOff = uiUtils.newRadioButton("Off","HXTPOFF");

        hxtpgroup.add(hxTurboPumpOn);
        hxtpgroup.add(hxTurboPumpOff);

        hxTurboVentOn = uiUtils.newRadioButton("Open","HXTVON",true);
        hxTurboVentOff = uiUtils.newRadioButton("Close","HXTVOFF");
      
        hxtvgroup.add(hxTurboVentOn);
        hxtvgroup.add(hxTurboVentOff);

        String prValsSpace = "awaiting update";
        cryoPrTextField = uiUtils.newTextFieldX(prValsSpace, "CRPTF", TextFieldX.TYPE_TEXT,true);
        cryoTurboPrTextField = uiUtils.newTextFieldX(prValsSpace, "CRTPTF", TextFieldX.TYPE_TEXT,true);
        cryoFlinePrTextField = uiUtils.newTextFieldX(prValsSpace, "CRFPTF", TextFieldX.TYPE_TEXT,true);
        hxPrTextField = uiUtils.newTextFieldX(prValsSpace, "CPTF", TextFieldX.TYPE_TEXT,true);
        hxTurboPrTextField = uiUtils.newTextFieldX(prValsSpace, "HXTPTF", TextFieldX.TYPE_TEXT,true);
        hxFlinePrTextField = uiUtils.newTextFieldX(prValsSpace, "HXFPTF", TextFieldX.TYPE_TEXT,true);
        pcPrTextField = uiUtils.newTextFieldX(prValsSpace, "PCCFPF", TextFieldX.TYPE_TEXT,true);
        pcPrTextField2 = uiUtils.newTextFieldX(prValsSpace, "PCC2FPF", TextFieldX.TYPE_TEXT,true);

        refPrTextField = uiUtils.newTextFieldX(prValsSpace, "REFCFPF", TextFieldX.TYPE_TEXT,true);

        ventingTextField = uiUtils.newTextFieldX("------------", "VTF", TextFieldX.TYPE_TEXT,true);
        cyclingTextField = uiUtils.newTextFieldX("------------", "CTF", TextFieldX.TYPE_TEXT,true);

        cryoValveTextField = uiUtils.newTextFieldX("--------------", "CVTF", TextFieldX.TYPE_TEXT,true);
        hxValveTextField =   uiUtils.newTextFieldX("--------------", "HVTF", TextFieldX.TYPE_TEXT,true);

        prRefSrcTextField =   uiUtils.newTextFieldX("------------------------", "HVTF", TextFieldX.TYPE_TEXT,true);


        abortVent = uiUtils.newButton("Abort Venting", "abortVent", true);

        pulseVent = uiUtils.newButton("Pulse Venting", "pulseVent", true);

        pulseVentPeriodLabel.setFont(FONT);

        pulseVentPeriodTextField = uiUtils.newTextFieldX(String.format("%04d",pulseVentTime), "VP", TextFieldX.TYPE_TEXT,true);

        closeCryoTurboVent = uiUtils.newButton("Close Cryo Turbo Vent", "closeCryoTurboVent", true);
        pulseCryoTurboVent = uiUtils.newButton("Pulse Cryo Turbo Vent", "pulseCryoTurboVent", true);

        closeHXTurboVent = uiUtils.newButton("Close HX Turbo Vent", "closeHXTurboVent", true);
        pulseHXTurboVent = uiUtils.newButton("Pulse HX Turbo Vent", "pulseHXTurboVent", true);

        pulseCryoTurboVentCntLabel.setFont(FONT);

        pulseCryoTurboVentCntTextField = uiUtils.newTextFieldX(String.format("%3d",pulseCryoTurboVentCnt), "CRYOTVP", TextFieldX.TYPE_TEXT,true);

        pulseHXTurboVentCntTextField = uiUtils.newTextFieldX(String.format("%3d",pulseHXTurboVentCnt), "HXTVP", TextFieldX.TYPE_TEXT,true);

        abortPump = uiUtils.newButton("Abort Pumping", "abortPump", true);

        pulsePump = uiUtils.newButton("Pulse Pumping", "pulsePump", true);

        pulsePumpPeriodLabel.setFont(FONT);

        pulsePumpPeriodTextField = uiUtils.newTextFieldX(String.format("%04d",pulsePumpTime), "PP", TextFieldX.TYPE_TEXT,true);


        maxVentPressureLabel.setFont(FONT);

        maxVentPressureTextField = uiUtils.newTextFieldX(String.format("%06.2f",maxVentPressure), "MXV", TextFieldX.TYPE_TEXT,true);

        minPumpPressureLabel.setFont(FONT);

        minPumpPressureTextField = uiUtils.newTextFieldX(String.format("%06.2f",minPumpPressure), "MNP", TextFieldX.TYPE_TEXT,true);


        
        //        pulseTurboVentPeriodTextField = uiUtils.newTextFieldX(String.format("%04d",pulseTurboVentTime), "VP", TextFieldX.TYPE_TEXT,true);

        //        Dimension d = pulseVentPeriodTextField.getPreferredSize();
        //        d.width = 45;
        //        pulseVentPeriodTextField.setMinimumSize(d);
        //        pulseVentPeriodTextField.setPreferredSize(d);
        //        pulseVentPeriodTextField.setHorizontalAlignment(SwingConstants.CENTER);
        //        pulseVentPeriodTextField.setText(String.valueOf(pulseVentTime));

        pulsePumpPeriodUnitsLabel.setFont(FONT);

        // Vacuum status line (panel)
        headPanel.setLayout(new GridBagLayout());


        // Pump Cart panel
        pcPanel = UiUtilities.newBorderedPanel("Pump Cart");
        GridBagConstraints gbpc = new GridBagConstraints();
        gbpc.anchor = GridBagConstraints.WEST;
        gbpc.insets = new Insets(0, 0, 4, 4);
        gbpc.gridx = 0;
        gbpc.gridy = 0;
        gbpc.anchor = GridBagConstraints.WEST;
        gbpc.insets.left = 5;

        pcPanel.add(UiUtilities.newLabel("Cryo P: ", 0), gbpc);
        gbpc.gridx++;
        pcPanel.add(cryoPrTextField, gbpc);

        gbpc.gridx++;
        pcPanel.add(UiUtilities.newLabel("Hx P: ", 0), gbpc);
        gbpc.gridx++;
        pcPanel.add(hxPrTextField, gbpc);

        gbpc.gridy++;

        gbpc.gridx=0;
        pcPanel.add(UiUtilities.newLabel("Cryo Turbo P: ", 0), gbpc);
        gbpc.gridx++;
        pcPanel.add(cryoTurboPrTextField, gbpc);

        gbpc.gridx++;
        pcPanel.add(UiUtilities.newLabel("Hx Turbo P: ", 0), gbpc);
        gbpc.gridx++;
        pcPanel.add(hxTurboPrTextField, gbpc);

        gbpc.gridy++;

        gbpc.gridx=0;
        pcPanel.add(UiUtilities.newLabel("Cryo Foreline P: ", 0), gbpc);
        gbpc.gridx++;
        pcPanel.add(cryoFlinePrTextField, gbpc);

        gbpc.gridx++;
        pcPanel.add(UiUtilities.newLabel("Hx Foreline P: ", 0), gbpc);
        gbpc.gridx++;
        pcPanel.add(hxFlinePrTextField, gbpc);

        gbpc.gridy++;

        gbpc.gridx=0;
        pcPanel.add(UiUtilities.newLabel("Pump Cart Pressure: ", 0), gbpc);
        gbpc.gridx++;
        pcPanel.add(pcPrTextField, gbpc);

        gbpc.gridx++;
        pcPanel.add(UiUtilities.newLabel("Pump Cart Pressure: ", 0), gbpc);
        gbpc.gridx++;
        pcPanel.add(pcPrTextField2, gbpc);
        gbpc.gridx++;

        gbpc.gridy++;
        gbpc.gridx=0;
        pcPanel.add(UiUtilities.newLabel(" ", 0), gbpc);
        //        gbpc.gridy++;
        //        pcPanel.add(UiUtilities.newLabel("Foreline Valve States ", 0), gbpc);

        gbpc.gridx=0;
        pcPanel.add(UiUtilities.newLabel("Cryo Foreline Valve: ", 0), gbpc);
        gbpc.gridx++;
        pcPanel.add(cryoValveTextField, gbpc);
        gbpc.gridx++;
        pcPanel.add(UiUtilities.newLabel("HX Foreline Valve: ", 0), gbpc);
        gbpc.gridx++;
        pcPanel.add(hxValveTextField, gbpc);

        gbpc.gridy++;
        gbpc.gridx-=2;
        pcPanel.add(UiUtilities.newLabel(" ", 0), gbpc);
        gbpc.gridy++;
        pcPanel.add(UiUtilities.newLabel("Pump Cart Control", 0), gbpc);
        gbpc.gridy++;


        gbpc.gridx = 0;
        pcPanel.add(UiUtilities.newLabel("Pump State: ", 0), gbpc);
        gbpc.gridx++;
        pcPanel.add(cyclingTextField, gbpc);
        gbpc.gridx++;
        //        pcPanel.add(UiUtilities.newLabel("Pumping: ", 0), gbpc);
        //        gbpc.gridx++;
        pcPanel.add(pumpOff,gbpc);
        gbpc.gridx++;
        pcPanel.add(pumpOn, gbpc);

        gbpc.gridx = 0;
        gbpc.gridy++;

        pcPanel.add(UiUtilities.newLabel("Pulse pump: ", 0), gbpc);
        gbpc.gridx++;
        pcPanel.add(pulsePumpPeriodTextField, gbpc);
        //        gbpc.gridx++;
        pcPanel.add(pulsePumpPeriodUnitsLabel, gbpc);
        gbpc.gridx++;
        pcPanel.add(pulsePump,gbpc);
        gbpc.gridx++;
        pcPanel.add(abortPump,gbpc);

        //        gbpc.gridy++;

        gbpc.gridy++;
        pcPanel.add(UiUtilities.newLabel(" ", 0), gbpc);

        gbpc.gridy++;
        gbpc.gridx =0;
        pcPanel.add(UiUtilities.newLabel("Venting State: ", 0), gbpc);
        gbpc.gridx++;
        pcPanel.add(ventingTextField, gbpc);
        gbpc.gridx++;
        //        pcPanel.add(UiUtilities.newLabel("Venting: ", 0), gbpc);
        //        gbpc.gridx++;
        pcPanel.add(ventOff,gbpc);
        gbpc.gridx++;
        pcPanel.add(ventOn, gbpc);


        gbpc.gridx = 0;
        gbpc.gridy++;

        pcPanel.add(UiUtilities.newLabel("Pulse vent: ", 0), gbpc);

        gbpc.gridx++;
        pcPanel.add(pulseVentPeriodTextField, gbpc);
        //        gbpc.gridx++;
        pcPanel.add(pulseVentPeriodUnitsLabel, gbpc);
        gbpc.gridx++;
        pcPanel.add(pulseVent,gbpc);
        gbpc.gridx++;
        //        pcPanel.add(abortVent,gbpc);

        //**
        gbpc.gridx = 0;

        gbpc.gridy++;
        pcPanel.add(UiUtilities.newLabel(" ", 0), gbpc);
        gbpc.gridy++;
        pcPanel.add(UiUtilities.newLabel("Press Ref Src:", 0), gbpc);
        gbpc.gridx++;
        pcPanel.add(prRefSrcTextField, gbpc);
        gbpc.gridx++;
        pcPanel.add(UiUtilities.newLabel("Ref. Pressure: ", 0), gbpc);
        gbpc.gridx++;
        pcPanel.add(refPrTextField, gbpc);


        gbpc.gridy++;
        gbpc.gridx = 0;

        pcPanel.add(UiUtilities.newLabel("Max Vent Pressure: ", 0), gbpc);
        gbpc.gridx++;
        pcPanel.add(maxVentPressureTextField, gbpc);
        pcPanel.add(maxVentPressureUnitsLabel, gbpc);
        gbpc.gridx++;
        pcPanel.add(UiUtilities.newLabel("Min Pump Pressure: ", 0), gbpc);
        gbpc.gridx++;
        pcPanel.add(minPumpPressureTextField, gbpc);
        pcPanel.add(minPumpPressureUnitsLabel, gbpc);


        //** --------------------------------------------------------------------------------------


        // Turbo Pump Controls panel
        tPanel = UiUtilities.newBorderedPanel("Turbo Pump Controls");
        GridBagConstraints gbt = new GridBagConstraints();
        gbt.anchor = GridBagConstraints.WEST;
        gbt.insets = new Insets(0, 0, 4, 4);
        gbt.gridx = 0;
        gbt.gridy = 0;
        gbt.anchor = GridBagConstraints.WEST;
        gbt.insets.left = 5;
        /*
        tPanel.add(UiUtilities.newLabel(" ", 0), gbpc);
        gbpc.gridy++;
        tPanel.add(UiUtilities.newLabel("Pump Cart Control", 0), gbpc);
        gbpc.gridy++;
        */

        gbt.gridx = 0;
        tPanel.add(UiUtilities.newLabel("Cryo Turbo: ", 0), gbt);
        gbt.gridx++;

        int sw = Switches.SW_CRYO_TURBO_PUMP;
        //        SwitchState state = vacState.getSwitchState(sw);
        //        DeviceState devState = vacState.getDeviceState(sw);
        SwitchState state = SwitchState.OFFLINE;
        DeviceState devState = DeviceState.OFFLINE;
        String text;
        Color color;
      
        if (state == SwitchState.OFFLINE || devState == null) {
            text = state.name();
            color = switchStateColors.get(state);
        }
        else {
            text = devState.name();
            color = deviceStateColors.get(devState);
        }
       
        cryoTurboSwitchStatus.setText(text);
        cryoTurboSwitchStatus.setForeground(color);
        
        tPanel.add(cryoTurboSwitchStatus, gbt);
        gbt.gridx+=2;
        
        //        tPanel.add(UiUtilities.newLabel("Pumping: ", 0), gbt);
        //        gbt.gridx++;
        tPanel.add(cryoTurboPumpOff,gbt);
        gbt.gridx++;
        tPanel.add(cryoTurboPumpOn, gbt);

        gbt.gridx+=2;
        //        gbt.gridy++;

        tPanel.add(UiUtilities.newLabel("HX Turbo: ", 0), gbt);
        gbt.gridx++;

        sw = Switches.SW_HX_TURBO_PUMP;
        //        SwitchState state = vacState.getSwitchState(sw);
        //        DeviceState devState = vacState.getDeviceState(sw);
        state = SwitchState.OFFLINE;
        devState = DeviceState.OFFLINE;
        //        String text;
        //        Color color;
      
        if (state == SwitchState.OFFLINE || devState == null) {
            text = state.name();
            color = switchStateColors.get(state);
        }
        else {
            text = devState.name();
            color = deviceStateColors.get(devState);
        }
       
        hxTurboSwitchStatus.setText(text);
        hxTurboSwitchStatus.setForeground(color);
        
        tPanel.add(hxTurboSwitchStatus, gbt);
        gbt.gridx+=2;
        
        /*
        tPanel.add(cyclingTextField, gbt);
        gbt.gridx++;
        */
        //        tPanel.add(UiUtilities.newLabel("Pumping: ", 0), gbt);
        //        gbt.gridx++;
        tPanel.add(hxTurboPumpOff,gbt);
        gbt.gridx++;
        tPanel.add(hxTurboPumpOn, gbt);

        gbt.gridx = 0;
        gbt.gridy++;

        /*
        tPanel.add(UiUtilities.newLabel("Pulse Turbo Vent: ", 0), gbt);
        gbt.gridx++;
        tPanel.add(pulsePumpPeriodTextField, gbt);
        //        gbt.gridx++;
        tPanel.add(pulsePumpPeriodUnitsLabel, gbt);
        gbt.gridx++;
        tPanel.add(pulseTurboVent,gbt);
        */

        //hn        gbt.gridx++;
        //        tPanel.add(abortTurboVent,gbt);

        //        gbt.gridy++;

        gbt.gridy++;
        tPanel.add(UiUtilities.newLabel(" ", 0), gbt);



        /* ++++++++++++++++++++++ */

        gbt.gridy++;
        gbt.gridx =0;
        tPanel.add(UiUtilities.newLabel("Cryo Vent: ", 0), gbt);
        gbt.gridx++;
         tPanel.add(pulseCryoTurboVentCntTextField, gbt);
        gbt.gridx++;
        tPanel.add(pulseCryoTurboVentCntUnitsLabel, gbt);
        gbt.gridx++;
        //        tPanel.add(turboVentingTextField, gbt);
        //        gbt.gridx++;
        //        tPanel.add(UiUtilities.newLabel("Venting: ", 0), gbt);
        //        gbt.gridx++;
        tPanel.add(cryoTurboVentOff,gbt);
        gbt.gridx++;
        tPanel.add(cryoTurboVentOn, gbt);

        gbt.gridx+=2;

        tPanel.add(UiUtilities.newLabel("HX Vent: ", 0), gbt);
        gbt.gridx++;
        tPanel.add(pulseHXTurboVentCntTextField, gbt);
        gbt.gridx++;
        tPanel.add(pulseHXTurboVentCntUnitsLabel, gbt);
        gbt.gridx++;
        //        tPanel.add(turboVentingTextField, gbt);
        //        gbt.gridx++;
        //        tPanel.add(UiUtilities.newLabel("Venting: ", 0), gbt);
        //        gbt.gridx++;
        tPanel.add(hxTurboVentOff,gbt);
        gbt.gridx++;
        tPanel.add(hxTurboVentOn, gbt);
        /*        ++++++++++++++++ */
        // ----------------------------------------------------

        gbt.gridx = 0;
               gbt.gridy++;

        //        tPanel.add(UiUtilities.newLabel("Pulse Cryo Turbo vent: ", 0), gbt);
               //        tPanel.add(closeCryoTurboVent,gbt);
        //        tPanel.add(UiUtilities.newLabel("Pulse time: ", 0), gbt);
        //        gbt.gridy++;
        //        tPanel.add(pulseCryoTurboVent,gbt);
        //        gbt.gridy++;

        //       gbt.gridx+=2;
        //        gbt.gridx++;
        //        tPanel.add(UiUtilities.newLabel("Pulse HX Turbo vent: ", 0), gbt);

        //        tPanel.add(UiUtilities.newLabel("Pulse time: ", 0), gbt);
        //        gbt.gridy--;
        //        tPanel.add(closeHXTurboVent,gbt);
        //        gbt.gridy++;
        //        tPanel.add(pulseHXTurboVent,gbt);

        gbt.gridx++;
        //        gbt.gridx++;
        //        tPanel.add(abortVent,gbt);


        
        //*** -------------------------------------------------------------------------------------
        // Lay out the complete panel
        setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.insets = new Insets(6, 0, 6, 0);
        gbm.anchor = GridBagConstraints.NORTH;
        gbm.gridx = 0;
        gbm.gridy = 0;
        add(tPanel, gbm);
        gbm.gridy++;
        add(pcPanel, gbm);
    }


    @Override
    public void handleRadioButton(String name) {


        LOG.log(Level.INFO,"button name = "+name);
        LOG.log(Level.INFO,"last venting switch state" + last_vs.getPumpCartVentingSwitchState());

        //        System.out.println("button name = "+name);
        if (name.contains("PCP")) {
            if (name.contains("OFF")) {
                sender.sendCommand("PumpCart", "pumpOn",false);
            } else {
                if (pumpOn.isEnabled()) {
                    sender.sendCommand("PumpCart", "pulsePump",-1);
                    //                    sender.sendCommand("PumpCart", "pumpOn",true);
                } else {
                    pumpOn.setEnabled(true);
                    pgroup.clearSelection();
                    if (last_vs != null) {
                        pumpOn.setSelected(last_vs.getPumpCartPumpingSwitchState());
                        pumpOff.setSelected(!last_vs.getPumpCartPumpingSwitchState());
                        LOG.log(Level.INFO,"pump switch state change rejected. State remains at " + last_vs.getPumpCartPumpingSwitchState());
                    }
                }
            }
        } else if (name.contains("PCV")) {
            if (name.contains("OFF")) {
                sender.sendCommand("PumpCart", "openVentValve",false);
            } else {
                if (ventOn.isEnabled()) {
                    sender.sendCommand("PumpCart", "pulseVentValve",-1);
                    //                    sender.sendCommand("PumpCart", "openVentValve",true);
                } else {
                    ventOn.setEnabled(true);
                    vgroup.clearSelection();
                    if (last_vs != null) {
                        ventOn.setSelected(last_vs.getPumpCartVentingSwitchState());
                        ventOff.setSelected(!last_vs.getPumpCartVentingSwitchState());
                        LOG.log(Level.INFO,"vent switch state change rejected. State remains at " + last_vs.getPumpCartVentingSwitchState());
                    }
                }
            }
        } else if (name.contains("CRYOTV")) {
            if (name.contains("OFF")) {
                sender.sendCommand(null, "setSwitchOn", "CryoTurboVentValve", false);
            } else {
                if (cryoTurboVentOn.isEnabled()) {
                    sender.sendCommand(null, "setSwitchOn", "CryoTurboVentValve", true);
                } else {
                    cryoTurboVentOn.setEnabled(true);
                    cryotvgroup.clearSelection();
                    if (last_vs != null) {
                        cryoTurboVentOn.setSelected(last_vs.getCryoTurboVentingSwitchState());
                        cryoTurboVentOff.setSelected(!last_vs.getCryoTurboVentingSwitchState());
                        LOG.log(Level.INFO,"turbo vent switch state change rejected. State remains at " + last_vs.getCryoTurboVentingSwitchState());
                    }
                }
            }
        } else if (name.contains("CRYOTP")) {
            if (name.contains("OFF")) {
                sender.sendCommand(null, "setSwitchOn", "CryoTurboPump", false);
            } else {
                if (cryoTurboPumpOn.isEnabled()) {
                    sender.sendCommand(null, "setSwitchOn", "CryoTurboPump", true);
                } else {
                    cryoTurboPumpOn.setEnabled(true);
                    cryotpgroup.clearSelection();
                    if (last_vs != null) {
                        cryoTurboPumpOn.setSelected(last_vs.getCryoTurboPumpSwitchState());
                        cryoTurboPumpOff.setSelected(!last_vs.getCryoTurboPumpSwitchState());
                        LOG.log(Level.INFO,"turbo vent switch state change rejected. State remains at " + last_vs.getCryoTurboPumpSwitchState());
                    }
                }
            }
        } else if (name.contains("HXTV")) {
            if (name.contains("OFF")) {
                sender.sendCommand(null, "setSwitchOn", "HxTurboVentValve", false);
            } else {
                if (hxTurboVentOn.isEnabled()) {
                    sender.sendCommand(null, "setSwitchOn", "HxTurboVentValve", true);
                } else {
                    hxTurboVentOn.setEnabled(true);
                    hxtvgroup.clearSelection();
                    if (last_vs != null) {
                        hxTurboVentOn.setSelected(last_vs.getHXTurboVentingSwitchState());
                        hxTurboVentOff.setSelected(!last_vs.getHXTurboVentingSwitchState());
                        LOG.log(Level.INFO,"HX turbo vent switch state change rejected. State remains at " + last_vs.getHXTurboVentingSwitchState());
                    }
                }
            }
        } else if (name.contains("HXTP")) {
            if (name.contains("OFF")) {
                sender.sendCommand(null, "setSwitchOn", "HxTurboPump", false);
            } else {
                if (hxTurboPumpOn.isEnabled()) {
                    sender.sendCommand(null, "setSwitchOn", "HxTurboPump", true);
                } else {
                    hxTurboPumpOn.setEnabled(true);
                    hxtpgroup.clearSelection();
                    if (last_vs != null) {
                        hxTurboPumpOn.setSelected(last_vs.getHXTurboPumpSwitchState());
                        hxTurboPumpOff.setSelected(!last_vs.getHXTurboPumpSwitchState());
                        LOG.log(Level.INFO,"HX turbo vent switch state change rejected. State remains at " + last_vs.getHXTurboPumpSwitchState());
                    }
                }
            }
        }

        
    }


    @Override
    public void handleButton(String name) {
        LOG.severe("button name = "+name);

        if (name.contains("pulseVent")) {
            sender.sendCommand("PumpCart", "pulseVentValve",pulseVentTime);
        } else if (name.contains("pulsePump")) {
            sender.sendCommand("PumpCart", "pulsePump",pulsePumpTime);
        } else if (name.contains("abortVent")) {
            sender.sendCommand("PumpCart", "abortVent");
        } else if (name.contains("abortPump")) {
            sender.sendCommand("PumpCart", "abortPump");
        } else if (name.contains("pulseCryoTurboVent")) {
            sender.sendCommand("CryoTurboPump", "timedOpenVentValve");  // needs update to pulseVentValve style with local variable
        } else if (name.contains("pulseHXTurboVent")) {
            sender.sendCommand("HexTurboPump", "timedOpenVentValve");  // needs update to pulseVentValve style with local variable
        } else if (name.contains("closeCryoTurboVent")) {
            sender.sendCommand("CryoTurboPump", "closeVentValve");
        } else if (name.contains("closeHXTurboVent")) {
            sender.sendCommand("HexTurboPump", "closeVentValve");
        }
    }
    
    class UpdateVacState implements Runnable {

        private final VacSysState vs;
        
        UpdateVacState(VacSysState vs) {
            last_vs = this.vs = vs;
        }

        @Override
        public void run() {
            sysStatPanel.updatePanel(vs.getTickMillis());
            cryoPrTextField.update(String.format("%7.3g",vs.getCryoPress()),true); 
            cryoTurboPrTextField.update(String.format("%7.3g",vs.getCryoTurboPress()),true); 
            cryoFlinePrTextField.update(String.format("%7.3g",vs.getCryoFlinePress()),true); 
            hxPrTextField.update(String.format("%7.3g",vs.getHXPress()),true); 
            hxTurboPrTextField.update(String.format("%7.3g",vs.getHXTurboPress()),true); 
            hxFlinePrTextField.update(String.format("%7.3g",vs.getHXFlinePress()),true); 
            pcPrTextField.update(String.format("%7.3g",vs.getPCPress()),true); 
            pcPrTextField2.update(String.format("%7.3g",vs.getPCPress()),true); 

            refPrTextField.update(String.format("%7.3g",vs.getPCTargetPressure()),true); 

            Color color = Color.BLACK;
            if (Double.isNaN(vs.getPCPress())) {
                ventingTextField.update("Offline",true); 
                cyclingTextField.update("Offline",true); 
                //                color = deviceStateColors.get(DeviceState.OFFLINE);
                color = UiConstants.YELLOW;
            } else {
                ventingTextField.update(vs.getVentingStatus()==0 ? "Off" : "Active",true); 
                cyclingTextField.update(vs.getCyclingStatus()==0 ? "Off" : "Active",true); 
            }
            ventingTextField.setForeground(color);
            cyclingTextField.setForeground(color);

            cryoValveTextField.update(vs.getCryoForelineValveStatus(),true); 
            hxValveTextField.update(vs.getHXForelineValveStatus(),true); 

            prRefSrcTextField.update(vs.getPCTargetPressureSrc(),true); 

            maxVentPressureTextField.update(String.format("%6.2f",maxVentPressure),true); 
            minPumpPressureTextField.update(String.format("%6.2f",minPumpPressure),true); 

            pgroup.clearSelection();
            pumpOn.setSelected(vs.getPumpCartPumpingSwitchState());
            pumpOff.setSelected(!vs.getPumpCartPumpingSwitchState());
            LOG.log(Level.FINE,"pump switch state = " + vs.getPumpCartPumpingSwitchState());

            pumpOn.setForeground(color);
            pumpOff.setForeground(color);

            vgroup.clearSelection();
            ventOn.setSelected(vs.getPumpCartVentingSwitchState());
            ventOff.setSelected(!vs.getPumpCartVentingSwitchState());
            LOG.log(Level.FINE,"vent switch state = " + vs.getPumpCartVentingSwitchState());

            ventOn.setForeground(color);
            ventOff.setForeground(color);

            pulseVent.setForeground(color);
            pulsePump.setForeground(color);

            // -----------

            cryotpgroup.clearSelection();
            cryoTurboPumpOn.setSelected(vs.getCryoTurboPumpSwitchState());
            cryoTurboPumpOff.setSelected(!vs.getCryoTurboPumpSwitchState());
            LOG.log(Level.FINE,"cryo turbo pump switch state = " + vs.getCryoTurboPumpSwitchState());


            int crytsw = Switches.SW_CRYO_TURBO_PUMP;
            // SwitchState state = vacState.getSwitchState(crytsw);
            // DeviceState devState = vacState.getDeviceState(crytsw);
            SwitchState state = vs.getSwitchState(crytsw);
            DeviceState devState = vs.getDeviceState(crytsw);
            String text;
            //            Color color;
      
            if (state == SwitchState.OFFLINE || devState == null) {
                text = state.name();
                color = switchStateColors.get(state);
            }
            else {
                text = devState.name();
                color = deviceStateColors.get(devState);
            }
       
            cryoTurboSwitchStatus.setText(text);
            cryoTurboSwitchStatus.setForeground(color);



            cryoTurboPumpOn.setForeground(color);
            cryoTurboPumpOff.setForeground(color);

            cryotvgroup.clearSelection();
            cryoTurboVentOn.setSelected(vs.getCryoTurboVentingSwitchState());
            cryoTurboVentOff.setSelected(!vs.getCryoTurboVentingSwitchState());
            LOG.log(Level.FINE,"cryo turbo vent switch state = " + vs.getCryoTurboVentingSwitchState());

            cryoTurboVentOn.setForeground(color);
            cryoTurboVentOff.setForeground(color);

            // -----------

            hxtpgroup.clearSelection();
            hxTurboPumpOn.setSelected(vs.getHXTurboPumpSwitchState());
            hxTurboPumpOff.setSelected(!vs.getHXTurboPumpSwitchState());
            LOG.log(Level.FINE,"hx turbo pump switch state = " + vs.getHXTurboPumpSwitchState());

            int hxtsw = Switches.SW_HX_TURBO_PUMP;
            // state = vacState.getSwitchState(hxtsw);
            // devState = vacState.getDeviceState(hxtsw);
            state = vs.getSwitchState(hxtsw);
            devState = vs.getDeviceState(hxtsw);
            text = "";
            //            Color color;
      
            if (state == SwitchState.OFFLINE || devState == null) {
                text = state.name();
                color = switchStateColors.get(state);
            }
            else {
                text = devState.name();
                color = deviceStateColors.get(devState);
            }
       
            hxTurboSwitchStatus.setText(text);
            hxTurboSwitchStatus.setForeground(color);

            hxTurboPumpOn.setForeground(color);
            hxTurboPumpOff.setForeground(color);

            hxtvgroup.clearSelection();
            hxTurboVentOn.setSelected(vs.getHXTurboVentingSwitchState());
            hxTurboVentOff.setSelected(!vs.getHXTurboVentingSwitchState());
            LOG.log(Level.FINE,"hx turbo vent switch state = " + vs.getHXTurboVentingSwitchState());

            hxTurboVentOn.setForeground(color);
            hxTurboVentOff.setForeground(color);

            pulseVent.setForeground(color);


        }

    }
    



   @Override
   public void handleTextFieldX(String name, Object value) {

       if (name.equals("VP")) {
            //            pulseVentTime = (Integer)value;
           try {
               pulseVentTime = Integer.decode((String)value);
           } catch(NumberFormatException nfe) {
               pulseVentTime = 0;
           }

           pulseVentPeriodTextField.update(String.format("%d",pulseVentTime),true); 
       } else if (name.equals("CRYOTVP")) {
           try {
               pulseCryoTurboVentCnt = Integer.valueOf((String)value);
               sender.sendCommand("CryoTurboPump", "setVentPulseCnt",pulseCryoTurboVentCnt);
           } catch(NumberFormatException nfe) {
               pulseCryoTurboVentCnt = 0;
           }

           pulseCryoTurboVentCntTextField.update(String.format("%3d",pulseCryoTurboVentCnt),true);
       } else if (name.equals("HXTVP")) {
           try {
               pulseHXTurboVentCnt = Integer.valueOf((String)value);
               sender.sendCommand("HexTurboPump", "setVentPulseCnt",pulseHXTurboVentCnt);
           } catch(NumberFormatException nfe) {
               pulseHXTurboVentCnt = 0;
           }

           pulseHXTurboVentCntTextField.update(String.format("%3d",pulseHXTurboVentCnt),true); 
       } else  if (name.contains("PP")) {
            //            pulsePumpTime = (Integer)value;
           try {
               pulsePumpTime = Integer.decode((String)value);
           } catch(NumberFormatException nfe) {
               pulsePumpTime = 0;
           }

           pulsePumpPeriodTextField.update(String.format("%d",pulsePumpTime),true); 
       } else  if (name.contains("MXV")) {
           try {
               maxVentPressure = Double.parseDouble((String)value);
               sender.sendCommand("PumpCart", "setMaxVentPressure",maxVentPressure);
           } catch(NumberFormatException nfe) {
               // TBD
           }

           maxVentPressureTextField.update(String.format("%6.2f",maxVentPressure),true); 
       } else  if (name.contains("MNP")) {
           try {
               minPumpPressure = Double.parseDouble((String)value);
               sender.sendCommand("PumpCart", "setMinPumpPressure",minPumpPressure);
           } catch(NumberFormatException nfe) {
               // TBD
           }

           minPumpPressureTextField.update(String.format("%6.2f",minPumpPressure),true); 
       }
   }

    class DisablePanel implements Runnable {

        @Override
        public void run() {
            //            blah.setEnabled(false);
        }
    }
    private static final long serialVersionUID = 1L;
}
