/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.vacuum.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.common.ui.TextFieldX;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.vacuum.constants.DeviceState;
import org.lsst.ccs.subsystem.vacuum.constants.SwitchState;
import org.lsst.ccs.subsystem.vacuum.data.VacSysState;

public class TurboAndPumpCartControlPanel
extends JPanel
implements UiUtilities.ActionHandler,
CommandSender.ReplyHandler {
    static final Font FONT = new Font("Tahoma", 1, 12);
    private static final String CMND_GET_STATE = "getVacuumState";
    private static final int SWTP_PUMP = 0;
    private static final int SWTP_VALVE = 1;
    private static final String DSAB_TEXT = "DSAB";
    private final JLabel cryoTurboSwitchStatus = new JLabel("offline");
    private final JLabel hxTurboSwitchStatus = new JLabel("offline");
    private static final Map<SwitchState, Color> switchStateColors = new HashMap<SwitchState, Color>();
    private static final Map<DeviceState, Color> deviceStateColors;
    private final CommandSender sender;
    private final UiUtilities uiUtils;
    private SystemStatusPanel sysStatPanel;
    private VacSysState last_vs;
    private final JPanel headPanel = new JPanel();
    private static final Logger LOG;
    private JRadioButton pumpOn = new JRadioButton();
    private JRadioButton pumpOff = new JRadioButton();
    private JRadioButton ventOn = new JRadioButton();
    private JRadioButton ventOff = new JRadioButton();
    private JRadioButton cryoTurboPumpOn = new JRadioButton();
    private JRadioButton cryoTurboPumpOff = new JRadioButton();
    private JRadioButton cryoTurboVentOn = new JRadioButton();
    private JRadioButton cryoTurboVentOff = new JRadioButton();
    private JButton cryoCloseTurboVent = new JButton();
    private JRadioButton hxTurboPumpOn = new JRadioButton();
    private JRadioButton hxTurboPumpOff = new JRadioButton();
    private JRadioButton hxTurboVentOn = new JRadioButton();
    private JRadioButton hxTurboVentOff = new JRadioButton();
    private JButton hxCloseTurboVent = new JButton();
    private int pulseVentTime = 1;
    private JButton pulseVent = new JButton();
    private int pulseCryoTurboVentCnt = 1;
    private JButton closeCryoTurboVent = new JButton();
    private JButton pulseCryoTurboVent = new JButton();
    private int pulseHXTurboVentCnt = 1;
    private JButton closeHXTurboVent = new JButton();
    private JButton pulseHXTurboVent = new JButton();
    private final JLabel pulseCryoTurboVentCntLabel = new JLabel("Cryo Pulses: ");
    private final JLabel pulseCryoTurboVentCntUnitsLabel = new JLabel("Cnt");
    private TextFieldX pulseCryoTurboVentCntTextField;
    private final JLabel pulseHXTurboVentCntLabel = new JLabel("HX Pulses: ");
    private final JLabel pulseHXTurboVentCntUnitsLabel = new JLabel("Cnt");
    private TextFieldX pulseHXTurboVentCntTextField;
    private TextFieldX pulseVentPeriodTextField;
    private final JLabel pulseVentPeriodLabel = new JLabel("Pulse Period: ");
    private final JLabel pulseVentPeriodUnitsLabel = new JLabel("            sec");
    private int pulsePumpTime = 1;
    private JButton pulsePump = new JButton();
    private double minPumpPressure = 0.0;
    private TextFieldX pulsePumpPeriodTextField;
    private final JLabel pulsePumpPeriodLabel = new JLabel("Pulse Period: ");
    private final JLabel pulsePumpPeriodUnitsLabel = new JLabel("            sec");
    private double maxVentPressure = 770.0;
    private TextFieldX maxVentPressureTextField;
    private final JLabel maxVentPressureLabel = new JLabel("Max Vent P: ");
    private final JLabel maxVentPressureUnitsLabel = new JLabel("               Torr");
    private TextFieldX minPumpPressureTextField;
    private final JLabel minPumpPressureLabel = new JLabel("Min Pump P: ");
    private final JLabel minPumpPressureUnitsLabel = new JLabel("               Torr");
    private JButton abortPump = new JButton();
    private JButton abortVent = new JButton();
    private TextFieldX cryoPrTextField;
    private TextFieldX cryoTurboPrTextField;
    private TextFieldX cryoFlinePrTextField;
    private TextFieldX hxPrTextField;
    private TextFieldX hxTurboPrTextField;
    private TextFieldX hxFlinePrTextField;
    private TextFieldX pcPrTextField;
    private TextFieldX pcPrTextField2;
    private TextFieldX refPrTextField;
    private TextFieldX ventingTextField;
    private TextFieldX cyclingTextField;
    private TextFieldX cryoValveTextField;
    private TextFieldX hxValveTextField;
    private TextFieldX prRefSrcTextField;
    private JPanel pcPanel;
    private JPanel tPanel;
    private ButtonGroup pgroup = new ButtonGroup();
    private ButtonGroup vgroup = new ButtonGroup();
    private ButtonGroup cryotpgroup = new ButtonGroup();
    private ButtonGroup cryotvgroup = new ButtonGroup();
    private ButtonGroup hxtpgroup = new ButtonGroup();
    private ButtonGroup hxtvgroup = new ButtonGroup();
    private volatile VacSysState vacState;
    private final Object vacStateLock = new Object();
    private static final long serialVersionUID = 1L;

    public TurboAndPumpCartControlPanel(CommandSender cons) {
        this.uiUtils = new UiUtilities((UiUtilities.ActionHandler)this);
        this.sender = cons;
        this.initComponents();
        new DisablePanel().run();
    }

    public void initPanel() {
        this.sender.sendCommand(true, null, CMND_GET_STATE, new Object[0]);
    }

    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        this.updatePanel((VacSysState)reply);
    }

    public void onCommandReject(String path, String command, Object[] args) {
        if (!command.equals(CMND_GET_STATE)) {
            this.updatePanel(this.vacState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePanel(VacSysState vss) {
        Object object = this.vacStateLock;
        synchronized (object) {
            this.vacState = vss;
            SwingUtilities.invokeLater(new UpdateVacState(vss));
        }
    }

    public void disablePanel() {
        SwingUtilities.invokeLater(new DisablePanel());
    }

    private void initComponents() {
        Color color;
        String text;
        this.sysStatPanel = new SystemStatusPanel(this.sender, "MonitorControl", true);
        this.pumpOn = this.uiUtils.newRadioButton("On", "PCPON", true);
        this.pumpOff = this.uiUtils.newRadioButton("Off", "PCPOFF");
        this.pgroup.add(this.pumpOn);
        this.pgroup.add(this.pumpOff);
        this.ventOn = this.uiUtils.newRadioButton("Open", "PCVON", true);
        this.ventOff = this.uiUtils.newRadioButton("Close", "PCVOFF");
        this.vgroup.add(this.ventOn);
        this.vgroup.add(this.ventOff);
        this.cryoTurboPumpOn = this.uiUtils.newRadioButton("On", "CRYOTPON", true);
        this.cryoTurboPumpOff = this.uiUtils.newRadioButton("Off", "CRYOTPOFF");
        this.cryotpgroup.add(this.cryoTurboPumpOn);
        this.cryotpgroup.add(this.cryoTurboPumpOff);
        this.cryoTurboVentOn = this.uiUtils.newRadioButton("Open", "CRYOTVON", true);
        this.cryoTurboVentOff = this.uiUtils.newRadioButton("Close", "CRYOTVOFF");
        this.cryotvgroup.add(this.cryoTurboVentOn);
        this.cryotvgroup.add(this.cryoTurboVentOff);
        this.hxTurboPumpOn = this.uiUtils.newRadioButton("On", "HXTPON", true);
        this.hxTurboPumpOff = this.uiUtils.newRadioButton("Off", "HXTPOFF");
        this.hxtpgroup.add(this.hxTurboPumpOn);
        this.hxtpgroup.add(this.hxTurboPumpOff);
        this.hxTurboVentOn = this.uiUtils.newRadioButton("Open", "HXTVON", true);
        this.hxTurboVentOff = this.uiUtils.newRadioButton("Close", "HXTVOFF");
        this.hxtvgroup.add(this.hxTurboVentOn);
        this.hxtvgroup.add(this.hxTurboVentOff);
        String prValsSpace = "awaiting update";
        this.cryoPrTextField = this.uiUtils.newTextFieldX(prValsSpace, "CRPTF", 0, true);
        this.cryoTurboPrTextField = this.uiUtils.newTextFieldX(prValsSpace, "CRTPTF", 0, true);
        this.cryoFlinePrTextField = this.uiUtils.newTextFieldX(prValsSpace, "CRFPTF", 0, true);
        this.hxPrTextField = this.uiUtils.newTextFieldX(prValsSpace, "CPTF", 0, true);
        this.hxTurboPrTextField = this.uiUtils.newTextFieldX(prValsSpace, "HXTPTF", 0, true);
        this.hxFlinePrTextField = this.uiUtils.newTextFieldX(prValsSpace, "HXFPTF", 0, true);
        this.pcPrTextField = this.uiUtils.newTextFieldX(prValsSpace, "PCCFPF", 0, true);
        this.pcPrTextField2 = this.uiUtils.newTextFieldX(prValsSpace, "PCC2FPF", 0, true);
        this.refPrTextField = this.uiUtils.newTextFieldX(prValsSpace, "REFCFPF", 0, true);
        this.ventingTextField = this.uiUtils.newTextFieldX("------------", "VTF", 0, true);
        this.cyclingTextField = this.uiUtils.newTextFieldX("------------", "CTF", 0, true);
        this.cryoValveTextField = this.uiUtils.newTextFieldX("--------------", "CVTF", 0, true);
        this.hxValveTextField = this.uiUtils.newTextFieldX("--------------", "HVTF", 0, true);
        this.prRefSrcTextField = this.uiUtils.newTextFieldX("------------------------", "HVTF", 0, true);
        this.abortVent = this.uiUtils.newButton("Abort Venting", "abortVent", true);
        this.pulseVent = this.uiUtils.newButton("Pulse Venting", "pulseVent", true);
        this.pulseVentPeriodLabel.setFont(FONT);
        this.pulseVentPeriodTextField = this.uiUtils.newTextFieldX(String.format("%04d", this.pulseVentTime), "VP", 0, true);
        this.closeCryoTurboVent = this.uiUtils.newButton("Close Cryo Turbo Vent", "closeCryoTurboVent", true);
        this.pulseCryoTurboVent = this.uiUtils.newButton("Pulse Cryo Turbo Vent", "pulseCryoTurboVent", true);
        this.closeHXTurboVent = this.uiUtils.newButton("Close HX Turbo Vent", "closeHXTurboVent", true);
        this.pulseHXTurboVent = this.uiUtils.newButton("Pulse HX Turbo Vent", "pulseHXTurboVent", true);
        this.pulseCryoTurboVentCntLabel.setFont(FONT);
        this.pulseCryoTurboVentCntTextField = this.uiUtils.newTextFieldX(String.format("%3d", this.pulseCryoTurboVentCnt), "CRYOTVP", 0, true);
        this.pulseHXTurboVentCntTextField = this.uiUtils.newTextFieldX(String.format("%3d", this.pulseHXTurboVentCnt), "HXTVP", 0, true);
        this.abortPump = this.uiUtils.newButton("Abort Pumping", "abortPump", true);
        this.pulsePump = this.uiUtils.newButton("Pulse Pumping", "pulsePump", true);
        this.pulsePumpPeriodLabel.setFont(FONT);
        this.pulsePumpPeriodTextField = this.uiUtils.newTextFieldX(String.format("%04d", this.pulsePumpTime), "PP", 0, true);
        this.maxVentPressureLabel.setFont(FONT);
        this.maxVentPressureTextField = this.uiUtils.newTextFieldX(String.format("%06.2f", this.maxVentPressure), "MXV", 0, true);
        this.minPumpPressureLabel.setFont(FONT);
        this.minPumpPressureTextField = this.uiUtils.newTextFieldX(String.format("%06.2f", this.minPumpPressure), "MNP", 0, true);
        this.pulsePumpPeriodUnitsLabel.setFont(FONT);
        this.headPanel.setLayout(new GridBagLayout());
        this.pcPanel = UiUtilities.newBorderedPanel((String)"Pump Cart");
        GridBagConstraints gbpc = new GridBagConstraints();
        gbpc.anchor = 17;
        gbpc.insets = new Insets(0, 0, 4, 4);
        gbpc.gridx = 0;
        gbpc.gridy = 0;
        gbpc.anchor = 17;
        gbpc.insets.left = 5;
        this.pcPanel.add((Component)UiUtilities.newLabel((String)"Cryo P: ", (int)0), gbpc);
        ++gbpc.gridx;
        this.pcPanel.add((Component)this.cryoPrTextField, gbpc);
        ++gbpc.gridx;
        this.pcPanel.add((Component)UiUtilities.newLabel((String)"Hx P: ", (int)0), gbpc);
        ++gbpc.gridx;
        this.pcPanel.add((Component)this.hxPrTextField, gbpc);
        ++gbpc.gridy;
        gbpc.gridx = 0;
        this.pcPanel.add((Component)UiUtilities.newLabel((String)"Cryo Turbo P: ", (int)0), gbpc);
        ++gbpc.gridx;
        this.pcPanel.add((Component)this.cryoTurboPrTextField, gbpc);
        ++gbpc.gridx;
        this.pcPanel.add((Component)UiUtilities.newLabel((String)"Hx Turbo P: ", (int)0), gbpc);
        ++gbpc.gridx;
        this.pcPanel.add((Component)this.hxTurboPrTextField, gbpc);
        ++gbpc.gridy;
        gbpc.gridx = 0;
        this.pcPanel.add((Component)UiUtilities.newLabel((String)"Cryo Foreline P: ", (int)0), gbpc);
        ++gbpc.gridx;
        this.pcPanel.add((Component)this.cryoFlinePrTextField, gbpc);
        ++gbpc.gridx;
        this.pcPanel.add((Component)UiUtilities.newLabel((String)"Hx Foreline P: ", (int)0), gbpc);
        ++gbpc.gridx;
        this.pcPanel.add((Component)this.hxFlinePrTextField, gbpc);
        ++gbpc.gridy;
        gbpc.gridx = 0;
        this.pcPanel.add((Component)UiUtilities.newLabel((String)"Pump Cart Pressure: ", (int)0), gbpc);
        ++gbpc.gridx;
        this.pcPanel.add((Component)this.pcPrTextField, gbpc);
        ++gbpc.gridx;
        this.pcPanel.add((Component)UiUtilities.newLabel((String)"Pump Cart Pressure: ", (int)0), gbpc);
        ++gbpc.gridx;
        this.pcPanel.add((Component)this.pcPrTextField2, gbpc);
        ++gbpc.gridx;
        ++gbpc.gridy;
        gbpc.gridx = 0;
        this.pcPanel.add((Component)UiUtilities.newLabel((String)" ", (int)0), gbpc);
        gbpc.gridx = 0;
        this.pcPanel.add((Component)UiUtilities.newLabel((String)"Cryo Foreline Valve: ", (int)0), gbpc);
        ++gbpc.gridx;
        this.pcPanel.add((Component)this.cryoValveTextField, gbpc);
        ++gbpc.gridx;
        this.pcPanel.add((Component)UiUtilities.newLabel((String)"HX Foreline Valve: ", (int)0), gbpc);
        ++gbpc.gridx;
        this.pcPanel.add((Component)this.hxValveTextField, gbpc);
        ++gbpc.gridy;
        gbpc.gridx -= 2;
        this.pcPanel.add((Component)UiUtilities.newLabel((String)" ", (int)0), gbpc);
        ++gbpc.gridy;
        this.pcPanel.add((Component)UiUtilities.newLabel((String)"Pump Cart Control", (int)0), gbpc);
        ++gbpc.gridy;
        gbpc.gridx = 0;
        this.pcPanel.add((Component)UiUtilities.newLabel((String)"Pump State: ", (int)0), gbpc);
        ++gbpc.gridx;
        this.pcPanel.add((Component)this.cyclingTextField, gbpc);
        ++gbpc.gridx;
        this.pcPanel.add((Component)this.pumpOff, gbpc);
        ++gbpc.gridx;
        this.pcPanel.add((Component)this.pumpOn, gbpc);
        gbpc.gridx = 0;
        ++gbpc.gridy;
        this.pcPanel.add((Component)UiUtilities.newLabel((String)"Pulse pump: ", (int)0), gbpc);
        ++gbpc.gridx;
        this.pcPanel.add((Component)this.pulsePumpPeriodTextField, gbpc);
        this.pcPanel.add((Component)this.pulsePumpPeriodUnitsLabel, gbpc);
        ++gbpc.gridx;
        this.pcPanel.add((Component)this.pulsePump, gbpc);
        ++gbpc.gridx;
        this.pcPanel.add((Component)this.abortPump, gbpc);
        ++gbpc.gridy;
        this.pcPanel.add((Component)UiUtilities.newLabel((String)" ", (int)0), gbpc);
        ++gbpc.gridy;
        gbpc.gridx = 0;
        this.pcPanel.add((Component)UiUtilities.newLabel((String)"Venting State: ", (int)0), gbpc);
        ++gbpc.gridx;
        this.pcPanel.add((Component)this.ventingTextField, gbpc);
        ++gbpc.gridx;
        this.pcPanel.add((Component)this.ventOff, gbpc);
        ++gbpc.gridx;
        this.pcPanel.add((Component)this.ventOn, gbpc);
        gbpc.gridx = 0;
        ++gbpc.gridy;
        this.pcPanel.add((Component)UiUtilities.newLabel((String)"Pulse vent: ", (int)0), gbpc);
        ++gbpc.gridx;
        this.pcPanel.add((Component)this.pulseVentPeriodTextField, gbpc);
        this.pcPanel.add((Component)this.pulseVentPeriodUnitsLabel, gbpc);
        ++gbpc.gridx;
        this.pcPanel.add((Component)this.pulseVent, gbpc);
        ++gbpc.gridx;
        gbpc.gridx = 0;
        ++gbpc.gridy;
        this.pcPanel.add((Component)UiUtilities.newLabel((String)" ", (int)0), gbpc);
        ++gbpc.gridy;
        this.pcPanel.add((Component)UiUtilities.newLabel((String)"Press Ref Src:", (int)0), gbpc);
        ++gbpc.gridx;
        this.pcPanel.add((Component)this.prRefSrcTextField, gbpc);
        ++gbpc.gridx;
        this.pcPanel.add((Component)UiUtilities.newLabel((String)"Ref. Pressure: ", (int)0), gbpc);
        ++gbpc.gridx;
        this.pcPanel.add((Component)this.refPrTextField, gbpc);
        ++gbpc.gridy;
        gbpc.gridx = 0;
        this.pcPanel.add((Component)UiUtilities.newLabel((String)"Max Vent Pressure: ", (int)0), gbpc);
        ++gbpc.gridx;
        this.pcPanel.add((Component)this.maxVentPressureTextField, gbpc);
        this.pcPanel.add((Component)this.maxVentPressureUnitsLabel, gbpc);
        ++gbpc.gridx;
        this.pcPanel.add((Component)UiUtilities.newLabel((String)"Min Pump Pressure: ", (int)0), gbpc);
        ++gbpc.gridx;
        this.pcPanel.add((Component)this.minPumpPressureTextField, gbpc);
        this.pcPanel.add((Component)this.minPumpPressureUnitsLabel, gbpc);
        this.tPanel = UiUtilities.newBorderedPanel((String)"Turbo Pump Controls");
        GridBagConstraints gbt = new GridBagConstraints();
        gbt.anchor = 17;
        gbt.insets = new Insets(0, 0, 4, 4);
        gbt.gridx = 0;
        gbt.gridy = 0;
        gbt.anchor = 17;
        gbt.insets.left = 5;
        gbt.gridx = 0;
        this.tPanel.add((Component)UiUtilities.newLabel((String)"Cryo Turbo: ", (int)0), gbt);
        ++gbt.gridx;
        int sw = 0;
        SwitchState state = SwitchState.OFFLINE;
        DeviceState devState = DeviceState.OFFLINE;
        if (state == SwitchState.OFFLINE || devState == null) {
            text = state.name();
            color = switchStateColors.get(state);
        } else {
            text = devState.name();
            color = deviceStateColors.get(devState);
        }
        this.cryoTurboSwitchStatus.setText(text);
        this.cryoTurboSwitchStatus.setForeground(color);
        this.tPanel.add((Component)this.cryoTurboSwitchStatus, gbt);
        gbt.gridx += 2;
        this.tPanel.add((Component)this.cryoTurboPumpOff, gbt);
        ++gbt.gridx;
        this.tPanel.add((Component)this.cryoTurboPumpOn, gbt);
        gbt.gridx += 2;
        this.tPanel.add((Component)UiUtilities.newLabel((String)"HX Turbo: ", (int)0), gbt);
        ++gbt.gridx;
        sw = 9;
        state = SwitchState.OFFLINE;
        devState = DeviceState.OFFLINE;
        if (state == SwitchState.OFFLINE || devState == null) {
            text = state.name();
            color = switchStateColors.get(state);
        } else {
            text = devState.name();
            color = deviceStateColors.get(devState);
        }
        this.hxTurboSwitchStatus.setText(text);
        this.hxTurboSwitchStatus.setForeground(color);
        this.tPanel.add((Component)this.hxTurboSwitchStatus, gbt);
        gbt.gridx += 2;
        this.tPanel.add((Component)this.hxTurboPumpOff, gbt);
        ++gbt.gridx;
        this.tPanel.add((Component)this.hxTurboPumpOn, gbt);
        gbt.gridx = 0;
        ++gbt.gridy;
        ++gbt.gridy;
        this.tPanel.add((Component)UiUtilities.newLabel((String)" ", (int)0), gbt);
        ++gbt.gridy;
        gbt.gridx = 0;
        this.tPanel.add((Component)UiUtilities.newLabel((String)"Cryo Vent: ", (int)0), gbt);
        ++gbt.gridx;
        this.tPanel.add((Component)this.pulseCryoTurboVentCntTextField, gbt);
        ++gbt.gridx;
        this.tPanel.add((Component)this.pulseCryoTurboVentCntUnitsLabel, gbt);
        ++gbt.gridx;
        this.tPanel.add((Component)this.cryoTurboVentOff, gbt);
        ++gbt.gridx;
        this.tPanel.add((Component)this.cryoTurboVentOn, gbt);
        gbt.gridx += 2;
        this.tPanel.add((Component)UiUtilities.newLabel((String)"HX Vent: ", (int)0), gbt);
        ++gbt.gridx;
        this.tPanel.add((Component)this.pulseHXTurboVentCntTextField, gbt);
        ++gbt.gridx;
        this.tPanel.add((Component)this.pulseHXTurboVentCntUnitsLabel, gbt);
        ++gbt.gridx;
        this.tPanel.add((Component)this.hxTurboVentOff, gbt);
        ++gbt.gridx;
        this.tPanel.add((Component)this.hxTurboVentOn, gbt);
        gbt.gridx = 0;
        ++gbt.gridy;
        ++gbt.gridx;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.insets = new Insets(6, 0, 6, 0);
        gbm.anchor = 11;
        gbm.gridx = 0;
        gbm.gridy = 0;
        this.add((Component)this.tPanel, gbm);
        ++gbm.gridy;
        this.add((Component)this.pcPanel, gbm);
    }

    public void handleRadioButton(String name) {
        LOG.log(Level.INFO, "button name = " + name);
        LOG.log(Level.INFO, "last venting switch state" + this.last_vs.getPumpCartVentingSwitchState());
        if (name.contains("PCP")) {
            if (name.contains("OFF")) {
                this.sender.sendCommand("PumpCart", "pumpOn", new Object[]{false});
            } else if (this.pumpOn.isEnabled()) {
                this.sender.sendCommand("PumpCart", "pulsePump", new Object[]{-1});
            } else {
                this.pumpOn.setEnabled(true);
                this.pgroup.clearSelection();
                if (this.last_vs != null) {
                    this.pumpOn.setSelected(this.last_vs.getPumpCartPumpingSwitchState());
                    this.pumpOff.setSelected(!this.last_vs.getPumpCartPumpingSwitchState());
                    LOG.log(Level.INFO, "pump switch state change rejected. State remains at " + this.last_vs.getPumpCartPumpingSwitchState());
                }
            }
        } else if (name.contains("PCV")) {
            if (name.contains("OFF")) {
                this.sender.sendCommand("PumpCart", "openVentValve", new Object[]{false});
            } else if (this.ventOn.isEnabled()) {
                this.sender.sendCommand("PumpCart", "pulseVentValve", new Object[]{-1});
            } else {
                this.ventOn.setEnabled(true);
                this.vgroup.clearSelection();
                if (this.last_vs != null) {
                    this.ventOn.setSelected(this.last_vs.getPumpCartVentingSwitchState());
                    this.ventOff.setSelected(!this.last_vs.getPumpCartVentingSwitchState());
                    LOG.log(Level.INFO, "vent switch state change rejected. State remains at " + this.last_vs.getPumpCartVentingSwitchState());
                }
            }
        } else if (name.contains("CRYOTV")) {
            if (name.contains("OFF")) {
                this.sender.sendCommand(null, "setSwitchOn", new Object[]{"CryoTurboVentValve", false});
            } else if (this.cryoTurboVentOn.isEnabled()) {
                this.sender.sendCommand(null, "setSwitchOn", new Object[]{"CryoTurboVentValve", true});
            } else {
                this.cryoTurboVentOn.setEnabled(true);
                this.cryotvgroup.clearSelection();
                if (this.last_vs != null) {
                    this.cryoTurboVentOn.setSelected(this.last_vs.getCryoTurboVentingSwitchState());
                    this.cryoTurboVentOff.setSelected(!this.last_vs.getCryoTurboVentingSwitchState());
                    LOG.log(Level.INFO, "turbo vent switch state change rejected. State remains at " + this.last_vs.getCryoTurboVentingSwitchState());
                }
            }
        } else if (name.contains("CRYOTP")) {
            if (name.contains("OFF")) {
                this.sender.sendCommand(null, "setSwitchOn", new Object[]{"CryoTurboPump", false});
            } else if (this.cryoTurboPumpOn.isEnabled()) {
                this.sender.sendCommand(null, "setSwitchOn", new Object[]{"CryoTurboPump", true});
            } else {
                this.cryoTurboPumpOn.setEnabled(true);
                this.cryotpgroup.clearSelection();
                if (this.last_vs != null) {
                    this.cryoTurboPumpOn.setSelected(this.last_vs.getCryoTurboPumpSwitchState());
                    this.cryoTurboPumpOff.setSelected(this.last_vs.getCryoTurboPumpSwitchState() == false);
                    LOG.log(Level.INFO, "turbo vent switch state change rejected. State remains at " + this.last_vs.getCryoTurboPumpSwitchState());
                }
            }
        } else if (name.contains("HXTV")) {
            if (name.contains("OFF")) {
                this.sender.sendCommand(null, "setSwitchOn", new Object[]{"HxTurboVentValve", false});
            } else if (this.hxTurboVentOn.isEnabled()) {
                this.sender.sendCommand(null, "setSwitchOn", new Object[]{"HxTurboVentValve", true});
            } else {
                this.hxTurboVentOn.setEnabled(true);
                this.hxtvgroup.clearSelection();
                if (this.last_vs != null) {
                    this.hxTurboVentOn.setSelected(this.last_vs.getHXTurboVentingSwitchState());
                    this.hxTurboVentOff.setSelected(!this.last_vs.getHXTurboVentingSwitchState());
                    LOG.log(Level.INFO, "HX turbo vent switch state change rejected. State remains at " + this.last_vs.getHXTurboVentingSwitchState());
                }
            }
        } else if (name.contains("HXTP")) {
            if (name.contains("OFF")) {
                this.sender.sendCommand(null, "setSwitchOn", new Object[]{"HxTurboPump", false});
            } else if (this.hxTurboPumpOn.isEnabled()) {
                this.sender.sendCommand(null, "setSwitchOn", new Object[]{"HxTurboPump", true});
            } else {
                this.hxTurboPumpOn.setEnabled(true);
                this.hxtpgroup.clearSelection();
                if (this.last_vs != null) {
                    this.hxTurboPumpOn.setSelected(this.last_vs.getHXTurboPumpSwitchState());
                    this.hxTurboPumpOff.setSelected(this.last_vs.getHXTurboPumpSwitchState() == false);
                    LOG.log(Level.INFO, "HX turbo vent switch state change rejected. State remains at " + this.last_vs.getHXTurboPumpSwitchState());
                }
            }
        }
    }

    public void handleButton(String name) {
        LOG.severe("button name = " + name);
        if (name.contains("pulseVent")) {
            this.sender.sendCommand("PumpCart", "pulseVentValve", new Object[]{this.pulseVentTime});
        } else if (name.contains("pulsePump")) {
            this.sender.sendCommand("PumpCart", "pulsePump", new Object[]{this.pulsePumpTime});
        } else if (name.contains("abortVent")) {
            this.sender.sendCommand("PumpCart", "abortVent", new Object[0]);
        } else if (name.contains("abortPump")) {
            this.sender.sendCommand("PumpCart", "abortPump", new Object[0]);
        } else if (name.contains("pulseCryoTurboVent")) {
            this.sender.sendCommand("CryoTurboPump", "timedOpenVentValve", new Object[0]);
        } else if (name.contains("pulseHXTurboVent")) {
            this.sender.sendCommand("HexTurboPump", "timedOpenVentValve", new Object[0]);
        } else if (name.contains("closeCryoTurboVent")) {
            this.sender.sendCommand("CryoTurboPump", "closeVentValve", new Object[0]);
        } else if (name.contains("closeHXTurboVent")) {
            this.sender.sendCommand("HexTurboPump", "closeVentValve", new Object[0]);
        }
    }

    public void handleTextFieldX(String name, Object value) {
        if (name.equals("VP")) {
            try {
                this.pulseVentTime = Integer.decode((String)value);
            }
            catch (NumberFormatException nfe) {
                this.pulseVentTime = 0;
            }
            this.pulseVentPeriodTextField.update((Object)String.format("%d", this.pulseVentTime), true);
        } else if (name.equals("CRYOTVP")) {
            try {
                this.pulseCryoTurboVentCnt = Integer.valueOf((String)value);
                this.sender.sendCommand("CryoTurboPump", "setVentPulseCnt", new Object[]{this.pulseCryoTurboVentCnt});
            }
            catch (NumberFormatException nfe) {
                this.pulseCryoTurboVentCnt = 0;
            }
            this.pulseCryoTurboVentCntTextField.update((Object)String.format("%3d", this.pulseCryoTurboVentCnt), true);
        } else if (name.equals("HXTVP")) {
            try {
                this.pulseHXTurboVentCnt = Integer.valueOf((String)value);
                this.sender.sendCommand("HexTurboPump", "setVentPulseCnt", new Object[]{this.pulseHXTurboVentCnt});
            }
            catch (NumberFormatException nfe) {
                this.pulseHXTurboVentCnt = 0;
            }
            this.pulseHXTurboVentCntTextField.update((Object)String.format("%3d", this.pulseHXTurboVentCnt), true);
        } else if (name.contains("PP")) {
            try {
                this.pulsePumpTime = Integer.decode((String)value);
            }
            catch (NumberFormatException nfe) {
                this.pulsePumpTime = 0;
            }
            this.pulsePumpPeriodTextField.update((Object)String.format("%d", this.pulsePumpTime), true);
        } else if (name.contains("MXV")) {
            try {
                this.maxVentPressure = Double.parseDouble((String)value);
                this.sender.sendCommand("PumpCart", "setMaxVentPressure", new Object[]{this.maxVentPressure});
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.maxVentPressureTextField.update((Object)String.format("%6.2f", this.maxVentPressure), true);
        } else if (name.contains("MNP")) {
            try {
                this.minPumpPressure = Double.parseDouble((String)value);
                this.sender.sendCommand("PumpCart", "setMinPumpPressure", new Object[]{this.minPumpPressure});
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.minPumpPressureTextField.update((Object)String.format("%6.2f", this.minPumpPressure), true);
        }
    }

    static {
        switchStateColors.put(SwitchState.OFF, Color.BLACK);
        switchStateColors.put(SwitchState.ON, UiConstants.GREEN);
        switchStateColors.put(SwitchState.OFFLINE, UiConstants.BLUE);
        deviceStateColors = new HashMap<DeviceState, Color>();
        deviceStateColors.put(DeviceState.AUTOTUN, Color.BLACK);
        deviceStateColors.put(DeviceState.BRAKING, UiConstants.YELLOW);
        deviceStateColors.put(DeviceState.FAILED, UiConstants.RED);
        deviceStateColors.put(DeviceState.NORMAL, UiConstants.GREEN);
        deviceStateColors.put(DeviceState.STARTNG, UiConstants.YELLOW);
        deviceStateColors.put(DeviceState.STOPPED, Color.BLACK);
        deviceStateColors.put(DeviceState.WAITING, UiConstants.YELLOW);
        deviceStateColors.put(DeviceState.OPEN, UiConstants.GREEN);
        deviceStateColors.put(DeviceState.SHUT, Color.BLACK);
        deviceStateColors.put(DeviceState.TRANSIT, UiConstants.YELLOW);
        deviceStateColors.put(DeviceState.ERROR, UiConstants.RED);
        deviceStateColors.put(DeviceState.OFFLINE, UiConstants.BLUE);
        LOG = Logger.getLogger(TurboAndPumpCartControlPanel.class.getName());
    }

    class DisablePanel
    implements Runnable {
        DisablePanel() {
        }

        @Override
        public void run() {
        }
    }

    class UpdateVacState
    implements Runnable {
        private final VacSysState vs;

        UpdateVacState(VacSysState vs) {
            this.vs = vs;
            TurboAndPumpCartControlPanel.this.last_vs = this.vs;
        }

        @Override
        public void run() {
            String text;
            TurboAndPumpCartControlPanel.this.sysStatPanel.updatePanel(this.vs.getTickMillis());
            TurboAndPumpCartControlPanel.this.cryoPrTextField.update((Object)String.format("%7.3g", this.vs.getCryoPress()), true);
            TurboAndPumpCartControlPanel.this.cryoTurboPrTextField.update((Object)String.format("%7.3g", this.vs.getCryoTurboPress()), true);
            TurboAndPumpCartControlPanel.this.cryoFlinePrTextField.update((Object)String.format("%7.3g", this.vs.getCryoFlinePress()), true);
            TurboAndPumpCartControlPanel.this.hxPrTextField.update((Object)String.format("%7.3g", this.vs.getHXPress()), true);
            TurboAndPumpCartControlPanel.this.hxTurboPrTextField.update((Object)String.format("%7.3g", this.vs.getHXTurboPress()), true);
            TurboAndPumpCartControlPanel.this.hxFlinePrTextField.update((Object)String.format("%7.3g", this.vs.getHXFlinePress()), true);
            TurboAndPumpCartControlPanel.this.pcPrTextField.update((Object)String.format("%7.3g", this.vs.getPCPress()), true);
            TurboAndPumpCartControlPanel.this.pcPrTextField2.update((Object)String.format("%7.3g", this.vs.getPCPress()), true);
            TurboAndPumpCartControlPanel.this.refPrTextField.update((Object)String.format("%7.3g", this.vs.getPCTargetPressure()), true);
            Color color = Color.BLACK;
            if (Double.isNaN(this.vs.getPCPress())) {
                TurboAndPumpCartControlPanel.this.ventingTextField.update((Object)"Offline", true);
                TurboAndPumpCartControlPanel.this.cyclingTextField.update((Object)"Offline", true);
                color = UiConstants.YELLOW;
            } else {
                TurboAndPumpCartControlPanel.this.ventingTextField.update((Object)(this.vs.getVentingStatus() == 0.0 ? "Off" : "Active"), true);
                TurboAndPumpCartControlPanel.this.cyclingTextField.update((Object)(this.vs.getCyclingStatus() == 0.0 ? "Off" : "Active"), true);
            }
            TurboAndPumpCartControlPanel.this.ventingTextField.setForeground(color);
            TurboAndPumpCartControlPanel.this.cyclingTextField.setForeground(color);
            TurboAndPumpCartControlPanel.this.cryoValveTextField.update((Object)this.vs.getCryoForelineValveStatus(), true);
            TurboAndPumpCartControlPanel.this.hxValveTextField.update((Object)this.vs.getHXForelineValveStatus(), true);
            TurboAndPumpCartControlPanel.this.prRefSrcTextField.update((Object)this.vs.getPCTargetPressureSrc(), true);
            TurboAndPumpCartControlPanel.this.maxVentPressureTextField.update((Object)String.format("%6.2f", TurboAndPumpCartControlPanel.this.maxVentPressure), true);
            TurboAndPumpCartControlPanel.this.minPumpPressureTextField.update((Object)String.format("%6.2f", TurboAndPumpCartControlPanel.this.minPumpPressure), true);
            TurboAndPumpCartControlPanel.this.pgroup.clearSelection();
            TurboAndPumpCartControlPanel.this.pumpOn.setSelected(this.vs.getPumpCartPumpingSwitchState());
            TurboAndPumpCartControlPanel.this.pumpOff.setSelected(!this.vs.getPumpCartPumpingSwitchState());
            LOG.log(Level.FINE, "pump switch state = " + this.vs.getPumpCartPumpingSwitchState());
            TurboAndPumpCartControlPanel.this.pumpOn.setForeground(color);
            TurboAndPumpCartControlPanel.this.pumpOff.setForeground(color);
            TurboAndPumpCartControlPanel.this.vgroup.clearSelection();
            TurboAndPumpCartControlPanel.this.ventOn.setSelected(this.vs.getPumpCartVentingSwitchState());
            TurboAndPumpCartControlPanel.this.ventOff.setSelected(!this.vs.getPumpCartVentingSwitchState());
            LOG.log(Level.FINE, "vent switch state = " + this.vs.getPumpCartVentingSwitchState());
            TurboAndPumpCartControlPanel.this.ventOn.setForeground(color);
            TurboAndPumpCartControlPanel.this.ventOff.setForeground(color);
            TurboAndPumpCartControlPanel.this.pulseVent.setForeground(color);
            TurboAndPumpCartControlPanel.this.pulsePump.setForeground(color);
            TurboAndPumpCartControlPanel.this.cryotpgroup.clearSelection();
            TurboAndPumpCartControlPanel.this.cryoTurboPumpOn.setSelected(this.vs.getCryoTurboPumpSwitchState());
            TurboAndPumpCartControlPanel.this.cryoTurboPumpOff.setSelected(this.vs.getCryoTurboPumpSwitchState() == false);
            LOG.log(Level.FINE, "cryo turbo pump switch state = " + this.vs.getCryoTurboPumpSwitchState());
            int crytsw = 0;
            SwitchState state = this.vs.getSwitchState(crytsw);
            DeviceState devState = this.vs.getDeviceState(crytsw);
            if (state == SwitchState.OFFLINE || devState == null) {
                text = state.name();
                color = (Color)switchStateColors.get(state);
            } else {
                text = devState.name();
                color = (Color)deviceStateColors.get(devState);
            }
            TurboAndPumpCartControlPanel.this.cryoTurboSwitchStatus.setText(text);
            TurboAndPumpCartControlPanel.this.cryoTurboSwitchStatus.setForeground(color);
            TurboAndPumpCartControlPanel.this.cryoTurboPumpOn.setForeground(color);
            TurboAndPumpCartControlPanel.this.cryoTurboPumpOff.setForeground(color);
            TurboAndPumpCartControlPanel.this.cryotvgroup.clearSelection();
            TurboAndPumpCartControlPanel.this.cryoTurboVentOn.setSelected(this.vs.getCryoTurboVentingSwitchState());
            TurboAndPumpCartControlPanel.this.cryoTurboVentOff.setSelected(!this.vs.getCryoTurboVentingSwitchState());
            LOG.log(Level.FINE, "cryo turbo vent switch state = " + this.vs.getCryoTurboVentingSwitchState());
            TurboAndPumpCartControlPanel.this.cryoTurboVentOn.setForeground(color);
            TurboAndPumpCartControlPanel.this.cryoTurboVentOff.setForeground(color);
            TurboAndPumpCartControlPanel.this.hxtpgroup.clearSelection();
            TurboAndPumpCartControlPanel.this.hxTurboPumpOn.setSelected(this.vs.getHXTurboPumpSwitchState());
            TurboAndPumpCartControlPanel.this.hxTurboPumpOff.setSelected(this.vs.getHXTurboPumpSwitchState() == false);
            LOG.log(Level.FINE, "hx turbo pump switch state = " + this.vs.getHXTurboPumpSwitchState());
            int hxtsw = 9;
            state = this.vs.getSwitchState(hxtsw);
            devState = this.vs.getDeviceState(hxtsw);
            text = "";
            if (state == SwitchState.OFFLINE || devState == null) {
                text = state.name();
                color = (Color)switchStateColors.get(state);
            } else {
                text = devState.name();
                color = (Color)deviceStateColors.get(devState);
            }
            TurboAndPumpCartControlPanel.this.hxTurboSwitchStatus.setText(text);
            TurboAndPumpCartControlPanel.this.hxTurboSwitchStatus.setForeground(color);
            TurboAndPumpCartControlPanel.this.hxTurboPumpOn.setForeground(color);
            TurboAndPumpCartControlPanel.this.hxTurboPumpOff.setForeground(color);
            TurboAndPumpCartControlPanel.this.hxtvgroup.clearSelection();
            TurboAndPumpCartControlPanel.this.hxTurboVentOn.setSelected(this.vs.getHXTurboVentingSwitchState());
            TurboAndPumpCartControlPanel.this.hxTurboVentOff.setSelected(!this.vs.getHXTurboVentingSwitchState());
            LOG.log(Level.FINE, "hx turbo vent switch state = " + this.vs.getHXTurboVentingSwitchState());
            TurboAndPumpCartControlPanel.this.hxTurboVentOn.setForeground(color);
            TurboAndPumpCartControlPanel.this.hxTurboVentOff.setForeground(color);
            TurboAndPumpCartControlPanel.this.pulseVent.setForeground(color);
        }
    }
}

