/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.utilities.logging.Logger;

public class AgentMBeanService
implements ServiceLifecycle,
AgentService {
    private final Logger log = Logger.getLogger((String)"org.lsst.ccs.mbean");
    private MBeanServer mbs;
    private int jmxPort = -1;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;

    @Override
    public boolean startForAgent(AgentInfo agentInfo) {
        try {
            String jmxPortStr = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("com.sun.management.jmxremote.port", "");
            if (!jmxPortStr.isEmpty()) {
                this.jmxPort = Integer.valueOf(jmxPortStr);
            }
        }
        catch (NumberFormatException nfe) {
            this.log.warning((Object)("Problem getting the jmx port for " + agentInfo.getName()), (Throwable)nfe);
        }
        return agentInfo.getType().compareTo((Enum)AgentInfo.AgentType.WORKER) >= 0 && this.jmxPort > 0;
    }

    @Override
    public String getAgentServiceName() {
        return "mbeanService";
    }

    @Override
    public void preInit() {
        try {
            this.agent.getAgentService(AgentPropertiesService.class).setAgentProperty("org.lsst.ccs.agent.jmxport", String.valueOf(this.jmxPort));
            this.mbs = ManagementFactory.getPlatformMBeanServer();
            this.log.info((Object)"MBean Server started successfully");
        }
        catch (Exception e) {
            this.log.severe((Object)"Failed to start JMX server.", (Throwable)e);
        }
    }

    public void registerMBean(Object obj, ObjectName objName) {
        try {
            this.mbs.registerMBean(obj, objName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

