/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.tree;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.freehep.application.studio.Studio;
import org.freehep.jas.plugin.tree.DefaultFTreeNode;
import org.freehep.jas.plugin.tree.DefaultFTreeNodeAdapter;
import org.freehep.jas.plugin.tree.DefaultFTreeNodeAdapterLookup;
import org.freehep.jas.plugin.tree.DefaultFTreeNodeAdapterProvider;
import org.freehep.jas.plugin.tree.DefaultFTreeNodeAdapterWrapper;
import org.freehep.jas.plugin.tree.FTree;
import org.freehep.jas.plugin.tree.FTreeNode;
import org.freehep.jas.plugin.tree.FTreeNodeAdapter;
import org.freehep.jas.plugin.tree.FTreeNodeAdapterProvider;
import org.freehep.jas.plugin.tree.FTreeNodeObjectProvider;
import org.freehep.jas.plugin.tree.FTreeNodeStructureProvider;
import org.freehep.jas.plugin.tree.FTreeNodeTextChangeEvent;
import org.freehep.jas.plugin.tree.FTreeNodeTransferable;
import org.freehep.jas.plugin.tree.FTreeSelectionEvent;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.util.commanddispatcher.CommandSource;
import org.freehep.util.commanddispatcher.CommandSourceAdapter;

class DefaultFTreeNodeAdapterManager {
    private DefaultFTreeNodeAdapterLookup lookup;
    private final Object NOOBJECT = null;
    private final String EMPTY_STRING = new String();
    private Hashtable adapters = new Hashtable();
    private FTree tree;
    private DragSourceAdapter dragAdapter = new DragSourceAdapter(){

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultLinkDrop);
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
            dse.getDragSourceContext().setCursor(DragSource.DefaultLinkNoDrop);
        }
    };

    DefaultFTreeNodeAdapterManager(FTree tree) {
        this.tree = tree;
        this.lookup = new DefaultFTreeNodeAdapterLookup(tree);
    }

    DefaultFTreeNodeAdapterLookup lookup() {
        return this.lookup;
    }

    void registerNodeAdapterProvider(FTreeNodeAdapterProvider provider) {
        this.lookup.registerFTreeNodeAdapterProvider(provider);
    }

    void registerNodeAdapter(FTreeNodeAdapter adapter, Class clazz) {
        this.registerNodeAdapterProvider(new DefaultFTreeNodeAdapterProvider(clazz, adapter));
    }

    void registerObjectProvider(FTreeNodeObjectProvider provider, Class clazz, int priority) {
        this.registerNodeAdapter(new DefaultFTreeNodeAdapter(priority, provider), clazz);
    }

    FTreeNodeAdapter[] adaptersForClass(Class clazz) {
        List adapters = this.lookup.getFTreeNodeAdaptersForClass(clazz);
        FTreeNodeAdapter[] result = new FTreeNodeAdapter[adapters.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (FTreeNodeAdapter)adapters.get(i);
        }
        return result;
    }

    FTreeNodeAdapter adapterForClass(Class clazz) {
        FTreeNodeAdapter adapter = (FTreeNodeAdapter)this.adapters.get(clazz);
        if (adapter == null) {
            adapter = new DefaultFTreeNodeAdapterWrapper(clazz, this);
            this.adapters.put(clazz, adapter);
        }
        return adapter;
    }

    JPopupMenu modifyPopupMenu(DefaultFTreeNode[] nodes, JPopupMenu menu) {
        FTreeNodeAdapter[] adapters = this.adaptersForClass(nodes[0].type());
        for (int i = adapters.length - 1; i > -1; --i) {
            menu = adapters[i].modifyPopupMenu(nodes, menu);
        }
        if (menu == null) {
            menu = new JPopupMenu();
        }
        if (menu.getComponentCount() > 0 && !(menu.getComponent(menu.getComponentCount() - 1) instanceof JSeparator)) {
            menu.addSeparator();
        }
        JMenuItem renameMenuItem = new JMenuItem("Rename");
        menu.add(renameMenuItem);
        Studio.getApplication().getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)renameMenuItem));
        for (int i = 0; i < nodes.length; ++i) {
            if (!nodes[i].getAllowsChildren()) continue;
            JMenuItem sortingMenuItem = new JMenuItem("Sorting ...");
            menu.add(sortingMenuItem);
            Studio.getApplication().getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)sortingMenuItem));
            break;
        }
        return menu;
    }

    Object userObjectForNode(DefaultFTreeNode node, Class clazz) {
        if (node.isRoot()) {
            return this.NOOBJECT;
        }
        FTreeNodeObjectProvider provider = this.adapterForClass(node.type()).treeNodeObjectProvider(node);
        return provider.objectForNode(node, clazz);
    }

    void checkForChildren(DefaultFTreeNode node) {
        Object obj = node.value("managerChildrenChecked");
        if (obj == null) {
            node.addKey("managerChildrenChecked", new Boolean(true));
            this.adapterForClass(node.type()).checkForChildren(node);
        }
    }

    boolean allowsChildren(DefaultFTreeNode node) {
        return this.adapterForClass(node.type()).allowsChildren(node, false);
    }

    void initiateDrag(DefaultFTreeNode[] nodes, DragGestureEvent dge) {
        FTreeNodeTransferable transferable = new FTreeNodeTransferable(nodes);
        Cursor cursor = DragSource.DefaultLinkNoDrop;
        transferable = this.adapterForClass(nodes[0].type()).modifyTransferable(nodes, transferable);
        dge.getDragSource().startDrag(dge, cursor, transferable, this.dragAdapter);
    }

    boolean doubleClick(DefaultFTreeNode node) {
        if (!node.isLeaf()) {
            return false;
        }
        return this.adapterForClass(node.type()).doubleClick(node);
    }

    boolean mouseClicked(DefaultFTreeNode node, MouseEvent mouseEvent, Dimension dimension) {
        return this.adapterForClass(node.type()).mouseClicked(node, mouseEvent, dimension);
    }

    String statusMessage(DefaultFTreeNode node) {
        String message = this.adapterForClass(node.type()).statusMessage(node, this.EMPTY_STRING);
        if (message.equals(this.EMPTY_STRING)) {
            return null;
        }
        return message;
    }

    String toolTipMessage(DefaultFTreeNode node) {
        String message = this.adapterForClass(node.type()).toolTipMessage(node, this.EMPTY_STRING);
        if (message.equals(this.EMPTY_STRING)) {
            return null;
        }
        return message;
    }

    String text(DefaultFTreeNode node) {
        if (node.isRoot()) {
            return null;
        }
        return this.adapterForClass(node.type()).text(node, null);
    }

    Icon icon(DefaultFTreeNode node, Icon defaultIcon, boolean selected, boolean expanded) {
        return this.adapterForClass(node.type()).icon(node, defaultIcon, selected, expanded);
    }

    FTreeNodeStructureProvider nodeStructureProvider(FTreeNode node) {
        FTreeNodeStructureProvider structureProvider = (FTreeNodeStructureProvider)node.value("structureProvider");
        if (structureProvider == null) {
            structureProvider = this.adapterForClass(node.type()).nodeStructureProvider(node);
            node.addKey("structureProvider", structureProvider);
        }
        return structureProvider;
    }

    void commandProcessors(FTreeNode[] nodes, Set set) {
        FTreeNodeAdapter[] adapters = this.adaptersForClass(nodes[0].type());
        for (int i = 0; i < adapters.length; ++i) {
            CommandProcessor cp = adapters[i].commandProcessor(nodes);
            if (cp == null) continue;
            set.add(cp);
        }
    }

    void selectionChanged(DefaultFTreeNode node, TreeSelectionEvent e, TreeSelectionModel model) {
        int n;
        FTreeSelectionEvent selEvent = new FTreeSelectionEvent(e, node.tree());
        if (!this.adapterForClass(node.type()).selectionChanged(selEvent) && e.isAddedPath() && (n = model.getSelectionCount()) > 0) {
            TreePath[] paths = model.getSelectionPaths();
            for (int i = 0; i < paths.length; ++i) {
                if (paths[i].equals(e.getNewLeadSelectionPath())) continue;
                model.removeSelectionPath(paths[i]);
            }
        }
    }

    void closeNode(DefaultFTreeNode node) {
        List children = node.structureProvider().nodes();
        for (int i = 0; i < children.size(); ++i) {
            DefaultFTreeNode child = (DefaultFTreeNode)children.get(i);
            this.closeNode(child);
        }
        this.adapterForClass(node.type()).nodeBeingDeleted(node);
    }

    boolean isNodeEditable(FTreeNodeTextChangeEvent evt) {
        return this.adapterForClass(evt.node().type()).canTextBeChanged(evt, false);
    }

    boolean acceptNewText(FTreeNodeTextChangeEvent evt) {
        return this.adapterForClass(evt.node().type()).acceptNewText(evt, true);
    }

    boolean nodeTextChanged(FTreeNodeTextChangeEvent evt) {
        this.adapterForClass(evt.node().type()).nodeTextChanged(evt);
        return evt.isConsumed();
    }

    Component treeCellRendererComponent(Component component, FTreeNode node, boolean sel, boolean expanded, boolean leaf, boolean hasFocus) {
        return this.adapterForClass(node.type()).treeCellRendererComponent(component, node, sel, expanded, leaf, hasFocus);
    }
}

