/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.scpi;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.ascii.TestAscii;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.scpi.Scpi;

public class TestScpi
extends TestAscii {
    protected final Scpi scpi;

    public TestScpi() {
        super(new Scpi());
        this.scpi = (Scpi)this.dev;
    }

    public TestScpi(Scpi scpi) {
        super(scpi);
        this.scpi = scpi;
    }

    @Command(name="writecommand", description="Write command")
    public void writeCommand(@Argument(description="Command word") String command, String ... args) throws DriverException {
        this.scpi.writeCommand(TestScpi.makeCommandString(command, args));
    }

    @Command(name="readstring", description="Write command and read string response")
    public String readString(@Argument(description="Command word") String command, String ... args) throws DriverException {
        return this.scpi.readString(TestScpi.makeCommandString(command, args));
    }

    @Command(name="readinteger", description="Write command and read integer response")
    public int readInteger(@Argument(description="Command word") String command, String ... args) throws DriverException {
        return this.scpi.readInteger(TestScpi.makeCommandString(command, args));
    }

    @Command(name="readdouble", description="Write command and read double response")
    public double readDouble(@Argument(description="Command wprd") String command, String ... args) throws DriverException {
        return this.scpi.readDouble(TestScpi.makeCommandString(command, args));
    }

    @Command(name="readfloat", description="Write command and read float response")
    public float readFloat(@Argument(description="Command word") String command, String ... args) throws DriverException {
        return this.scpi.readFloat(TestScpi.makeCommandString(command, args));
    }

    @Command(name="clear", description="Clear saved status")
    public void clear() throws DriverException {
        this.scpi.clearStatus();
    }

    @Command(name="reset", description="Reset to power-on state")
    public void reset() throws DriverException {
        this.scpi.reset();
    }

    @Command(name="enableopc", description="Enable operation complete reporting")
    public void enableOpc() throws DriverException {
        this.scpi.enableOperationComplete();
    }

    @Command(name="setese", description="Set event status enable register")
    public void setEse(@Argument(description="Value to set") int value) throws DriverException {
        this.scpi.setEventStatusEnable(value);
    }

    @Command(name="setsre", description="Set service request enable register")
    public void setSre(@Argument(description="Value to set") int value) throws DriverException {
        this.scpi.setServiceRequestEnable(value);
    }

    @Command(name="wait", description="Wait for previous command completion")
    public void waitComp() throws DriverException {
        this.scpi.waitCompletion();
    }

    @Command(name="showesr", description="Display the event status register")
    public String showEsr() throws DriverException {
        return String.format("0x%02x", this.scpi.getEventStatus());
    }

    @Command(name="showese", description="Display the event status enable register")
    public String showEse() throws DriverException {
        return String.format("0x%02x", this.scpi.getEventStatusEnable());
    }

    @Command(name="showopc", description="Display the operation complete state")
    public int showOpc() throws DriverException {
        return this.scpi.getOperationComplete();
    }

    @Command(name="showsre", description="Display the service request enable register")
    public String showSre() throws DriverException {
        return String.format("0x%02x", this.scpi.getServiceRequestEnable());
    }

    @Command(name="showstatus", description="Display the status byte")
    public String showStatus() throws DriverException {
        return String.format("0x%02x", this.scpi.getStatusByte());
    }

    @Command(name="selftest", description="Run the self test")
    public int selfTest() throws DriverException {
        return this.scpi.runSelfTest();
    }

    @Command(name="showerror", description="Display the first error item")
    public String showError() throws DriverException {
        return this.scpi.getError();
    }

    @Command(name="showident", description="Show SCPI device identification")
    public String showIdentification() throws DriverException {
        String[] id = this.scpi.getIdentification();
        return "Manufacturer:   " + id[0] + "\nModel name:     " + id[1] + "\nSerial number:  " + id[2] + "\nF/W version:    " + id[3];
    }
}

