/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.vacuum.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.vacuum.constants.ConditionState;
import org.lsst.ccs.subsystem.vacuum.constants.CryoVacuumState;
import org.lsst.ccs.subsystem.vacuum.constants.DeviceState;
import org.lsst.ccs.subsystem.vacuum.constants.HxVacuumState;
import org.lsst.ccs.subsystem.vacuum.constants.LatchState;
import org.lsst.ccs.subsystem.vacuum.constants.PLCState;
import org.lsst.ccs.subsystem.vacuum.constants.SwitchEnable;
import org.lsst.ccs.subsystem.vacuum.constants.SwitchState;
import org.lsst.ccs.subsystem.vacuum.constants.Switches;
import org.lsst.ccs.subsystem.vacuum.data.VacSysState;
import org.lsst.ccs.subsystem.vacuum.ui.PumpCartControlPanel;

public class VacControlPanel
extends JPanel
implements UiUtilities.ActionHandler,
CommandSender.ReplyHandler {
    private static final String CMND_GET_STATE = "getVacuumState";
    private static final int SWTP_PUMP = 0;
    private static final int SWTP_VALVE = 1;
    private static final String DSAB_TEXT = "DSAB";
    private static final Map<Integer, String> switchMap = new LinkedHashMap<Integer, String>();
    private static final boolean DO_FLASH_TEST = false;
    private static final long MIN_FLASH_TIME = 2000L;
    private JDialog dialog = null;
    private static final int[] switchTypes;
    private static final Map<Integer, String> latchMap;
    private static final Map<Integer, String> conditionMap;
    private static final Map<SwitchState, Color> switchStateColors;
    private static final Map<DeviceState, Color> deviceStateColors;
    private static final int PLC_STATE_WIDTH;
    private static final int CRYO_STATE_WIDTH;
    private static final int HX_STATE_WIDTH;
    private static final int SWITCH_STATE_WIDTH;
    private static final int LATCH_STATE_WIDTH;
    private static final int COND_STATUS_WIDTH;
    private final CommandSender sender;
    private final UiUtilities uiUtils;
    private SystemStatusPanel sysStatPanel;
    private final JPanel headPanel = new JPanel();
    private JLabel plcStateValue;
    private JLabel cryoStateValue;
    private JLabel hxStateValue;
    private Color switchPanelNominalColor;
    private long lastFlashUpdateT = 0L;
    private JPanel switchPanel;
    private final JLabel[] switchLabel = new JLabel[26];
    private final JLabel[] switchStatus = new JLabel[26];
    private final JLabel[] switchEnable = new JLabel[26];
    private final ButtonGroup[] switchBG = new ButtonGroup[26];
    private final JRadioButton[] switchOffRB = new JRadioButton[26];
    private final JRadioButton[] switchOnRB = new JRadioButton[26];
    private final PumpCartControlPanel pumpcart;
    private JButton pumpcartButton;
    private JPanel pumpCartPanel;
    private JPanel latchPanel;
    private final JLabel[] latchLabel = new JLabel[8];
    private final JLabel[] latchStatus = new JLabel[8];
    private final JButton[] latchResetBtn = new JButton[8];
    private JPanel conditionPanel;
    private final JLabel[] conditionLabel = new JLabel[10];
    private final JLabel[] conditionStatus = new JLabel[10];
    private volatile VacSysState vacState;
    private final Object vacStateLock = new Object();
    private static final long serialVersionUID = 1L;

    public VacControlPanel(String subsys) {
        this.uiUtils = new UiUtilities((UiUtilities.ActionHandler)this);
        this.sender = new CommandSender(subsys, (CommandSender.ReplyHandler)this);
        this.initComponents();
        this.pumpcart = new PumpCartControlPanel(this.sender);
        new DisablePanel().run();
    }

    public void initPanel() {
        this.sender.sendCommand(true, null, CMND_GET_STATE, new Object[0]);
    }

    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        this.updatePanel((VacSysState)reply);
        this.pumpcart.updatePanel((VacSysState)reply);
    }

    public void onCommandReject(String path, String command, Object[] args) {
        if (!command.equals(CMND_GET_STATE)) {
            this.updatePanel(this.vacState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePanel(VacSysState vss) {
        Object object = this.vacStateLock;
        synchronized (object) {
            this.vacState = vss;
            SwingUtilities.invokeLater(new UpdateVacState(vss));
            this.pumpcart.updatePanel(vss);
        }
    }

    public void disablePanel() {
        SwingUtilities.invokeLater(new DisablePanel());
        this.pumpcart.disablePanel();
    }

    private void initComponents() {
        Object bg;
        this.sysStatPanel = new SystemStatusPanel(this.sender, "MonitorControl", true);
        this.plcStateValue = UiUtilities.newLabel((String)"X", (int)PLC_STATE_WIDTH);
        this.cryoStateValue = UiUtilities.newLabel((String)"X", (int)CRYO_STATE_WIDTH);
        this.hxStateValue = UiUtilities.newLabel((String)"X", (int)HX_STATE_WIDTH);
        this.pumpcartButton = this.uiUtils.newButton("Pump Cart Control Panel", "pumpcart", true);
        for (int sw : switchMap.keySet()) {
            if (sw < 0) continue;
            this.switchLabel[sw] = UiUtilities.newLabel((String)(switchMap.get(sw) + ":"), (int)0);
            this.switchStatus[sw] = UiUtilities.newLabel((String)"X", (int)SWITCH_STATE_WIDTH);
            this.switchEnable[sw] = UiUtilities.newLabel((String)DSAB_TEXT, (int)0);
            this.switchEnable[sw].setForeground(UiConstants.RED);
            int swType = switchTypes[sw];
            boolean confirmDialog = sw == 7 || sw == 12;
            this.switchOffRB[sw] = this.uiUtils.newRadioButton(swType == 0 ? "Off" : "Shut", "S" + sw);
            this.switchOnRB[sw] = this.uiUtils.newRadioButton(swType == 0 ? "On" : "Open", "O" + sw, confirmDialog);
            this.switchBG[sw] = new ButtonGroup();
            bg = this.switchBG[sw];
            ((ButtonGroup)bg).add(this.switchOffRB[sw]);
            ((ButtonGroup)bg).add(this.switchOnRB[sw]);
        }
        for (int cond : latchMap.keySet()) {
            this.latchLabel[cond] = UiUtilities.newLabel((String)(latchMap.get(cond) + ":"), (int)0);
            this.latchStatus[cond] = UiUtilities.newLabel((String)"X", (int)LATCH_STATE_WIDTH);
            this.latchResetBtn[cond] = this.uiUtils.newButton("Reset", "R" + cond, true);
        }
        for (int cond : conditionMap.keySet()) {
            this.conditionLabel[cond] = UiUtilities.newLabel((String)(conditionMap.get(cond) + ":"), (int)0);
            this.conditionStatus[cond] = UiUtilities.newLabel((String)"X", (int)COND_STATUS_WIDTH);
        }
        this.headPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbh = new GridBagConstraints();
        gbh.insets = new Insets(5, 0, 5, 0);
        gbh.gridx = 0;
        gbh.gridy = 0;
        gbh.anchor = 17;
        gbh.insets.left = 5;
        this.headPanel.add((Component)UiUtilities.newLabel((String)"PLC State: ", (int)0), gbh);
        ++gbh.gridx;
        this.headPanel.add((Component)this.plcStateValue, gbh);
        ++gbh.gridx;
        gbh.insets.left = 25;
        this.headPanel.add((Component)UiUtilities.newLabel((String)"Cryo Vac State: ", (int)0), gbh);
        ++gbh.gridx;
        gbh.insets.left = 5;
        this.headPanel.add((Component)this.cryoStateValue, gbh);
        ++gbh.gridx;
        gbh.insets.left = 25;
        this.headPanel.add((Component)UiUtilities.newLabel((String)"HX Vac State: ", (int)0), gbh);
        ++gbh.gridx;
        gbh.insets.left = 5;
        this.headPanel.add((Component)this.hxStateValue, gbh);
        this.switchPanel = UiUtilities.newBorderedPanel((String)"Switches");
        this.switchPanelNominalColor = this.switchPanel.getBackground();
        GridBagConstraints gbs = new GridBagConstraints();
        gbs.anchor = 17;
        gbs.insets = new Insets(0, 0, 4, 4);
        gbs.gridy = 0;
        int colm = 0;
        int nRows = (switchMap.size() + 1) / 2;
        bg = switchMap.keySet().iterator();
        while (bg.hasNext()) {
            int sw = (Integer)bg.next();
            if (sw >= 0) {
                gbs.insets.top = gbs.gridy == 0 ? 4 : 0;
                gbs.insets.left = colm == 0 ? 4 : 40;
                gbs.gridx = 5 * colm;
                this.switchPanel.add((Component)this.switchLabel[sw], gbs);
                gbs.insets.left = 4;
                ++gbs.gridx;
                this.switchPanel.add((Component)this.switchEnable[sw], gbs);
                ++gbs.gridx;
                this.switchPanel.add((Component)this.switchStatus[sw], gbs);
                ++gbs.gridx;
                this.switchPanel.add((Component)this.switchOffRB[sw], gbs);
                ++gbs.gridx;
                this.switchPanel.add((Component)this.switchOnRB[sw], gbs);
            }
            if (++gbs.gridy != nRows) continue;
            gbs.gridy = 0;
            colm = 1;
        }
        this.latchPanel = UiUtilities.newBorderedPanel((String)"PLC Error Conditions");
        GridBagConstraints gbl = new GridBagConstraints();
        gbl.anchor = 17;
        gbl.insets = new Insets(0, 0, 4, 4);
        gbl.gridy = 0;
        colm = 0;
        nRows = (latchMap.size() + 1) / 2;
        for (int cond : latchMap.keySet()) {
            gbl.insets.top = gbl.gridy == 0 ? 4 : 0;
            gbl.insets.left = colm == 0 ? 4 : 40;
            gbl.gridx = 3 * colm;
            this.latchPanel.add((Component)this.latchLabel[cond], gbl);
            gbl.insets.left = 4;
            ++gbl.gridx;
            this.latchPanel.add((Component)this.latchStatus[cond], gbl);
            ++gbl.gridx;
            this.latchPanel.add((Component)this.latchResetBtn[cond], gbl);
            if (++gbl.gridy != nRows) continue;
            gbl.gridy = 0;
            colm = 1;
        }
        this.conditionPanel = UiUtilities.newBorderedPanel((String)"PLC Running Conditions");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 4, 4);
        gbc.gridy = 0;
        colm = 0;
        nRows = (conditionMap.size() + 1) / 2;
        for (int cond : conditionMap.keySet()) {
            gbc.insets.top = gbc.gridy == 0 ? 4 : 0;
            gbc.insets.left = colm == 0 ? 4 : 40;
            gbc.gridx = 2 * colm;
            this.conditionPanel.add((Component)this.conditionLabel[cond], gbc);
            ++gbc.gridx;
            gbc.insets.left = 4;
            this.conditionPanel.add((Component)this.conditionStatus[cond], gbc);
            if (++gbc.gridy != nRows) continue;
            gbc.gridy = 0;
            colm = 1;
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.insets = new Insets(6, 0, 6, 0);
        gbm.anchor = 11;
        gbm.gridx = 0;
        gbm.gridy = 0;
        this.add((Component)this.sysStatPanel, gbm);
        ++gbm.gridy;
        this.add((Component)this.headPanel, gbm);
        ++gbm.gridy;
        this.add((Component)this.switchPanel, gbm);
        ++gbm.gridy;
        this.add((Component)this.latchPanel, gbm);
        ++gbm.gridy;
        this.add((Component)this.conditionPanel, gbm);
        ++gbm.gridy;
        this.add((Component)this.pumpcartButton, gbm);
    }

    public void handleRadioButton(String name) {
        char type = name.charAt(0);
        int sw = Integer.valueOf(name.substring(1));
        if (type == 'O' && !this.switchOnRB[sw].isEnabled()) {
            this.updatePanel(this.vacState);
        } else {
            this.switchOffRB[sw].setEnabled(false);
            this.switchOnRB[sw].setEnabled(false);
            this.sender.sendCommand(null, "setSwitchOn", new Object[]{Switches.getName((int)sw), type == 'O'});
        }
    }

    public void handleButton(String name) {
        if (!name.toLowerCase().contains("pump") || !name.toLowerCase().contains("cart")) {
            int cond = Integer.valueOf(name.substring(1));
            this.latchResetBtn[cond].setEnabled(false);
            this.sender.sendCommand(null, "clearLatch", new Object[]{cond});
        } else {
            if (this.dialog != null) {
                this.dialog.setVisible(false);
                this.dialog.dispose();
                this.dialog = null;
                return;
            }
            Window window = SwingUtilities.getWindowAncestor(this);
            this.dialog = new JDialog(window, "Pump Cart Control", Dialog.ModalityType.MODELESS);
            this.dialog.add((Component)this.pumpcart, "Center");
            this.dialog.pack();
            this.dialog.setLocationRelativeTo(window);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    VacControlPanel.this.dialog.setVisible(false);
                    VacControlPanel.this.dialog.dispose();
                    VacControlPanel.this.dialog = null;
                }
            });
            this.dialog.setVisible(true);
        }
    }

    public void periodicPanelUpdate() {
        Color currentColor = this.switchPanel.getBackground();
        if (this.vacState.getDeviceState(7) == DeviceState.ERROR) {
            long deltaFlashT = System.currentTimeMillis() - this.lastFlashUpdateT;
            if (deltaFlashT > 2000L) {
                deltaFlashT = 0L;
                this.lastFlashUpdateT = System.currentTimeMillis();
                if (currentColor == this.switchPanelNominalColor) {
                    this.switchPanel.setBackground(new Color(175, 100, 100));
                } else {
                    this.switchPanel.setBackground(this.switchPanelNominalColor);
                }
            }
        } else if (currentColor != this.switchPanelNominalColor) {
            this.switchPanel.setBackground(this.switchPanelNominalColor);
        }
    }

    static {
        switchMap.put(0, "Cryo Turbo Pump");
        switchMap.put(7, "Cryo Gate Valve");
        switchMap.put(24, "Cryo Pump Cart FL Valve");
        switchMap.put(1, "Cryo Ion Pump 1");
        switchMap.put(2, "Cryo Ion Pump 2");
        switchMap.put(3, "Cryo Ion Pump 3");
        switchMap.put(4, "Cryo Ion Pump 4");
        switchMap.put(5, "Cryo Ion Pump 5");
        switchMap.put(6, "Cryo Ion Pump 6");
        switchMap.put(23, "Inst Foreline Valve");
        switchMap.put(9, "HX Turbo Pump");
        switchMap.put(12, "HX Gate Valve");
        switchMap.put(25, "HX Pump Cart FL Valve");
        switchMap.put(10, "HX Ion Pump 1");
        switchMap.put(11, "HX Ion Pump 2");
        switchMap.put(14, "FTPP O-ring Valve");
        switchMap.put(16, "L3H O-ring Valve");
        switchMap.put(15, "FTH O-ring Valve");
        switchMap.put(17, "L3LF O-ring Valve");
        switchMap.put(18, "Inst Scroll Pump");
        switchTypes = new int[26];
        VacControlPanel.switchTypes[0] = 0;
        VacControlPanel.switchTypes[1] = 0;
        VacControlPanel.switchTypes[2] = 0;
        VacControlPanel.switchTypes[3] = 0;
        VacControlPanel.switchTypes[4] = 0;
        VacControlPanel.switchTypes[5] = 0;
        VacControlPanel.switchTypes[6] = 0;
        VacControlPanel.switchTypes[7] = 1;
        VacControlPanel.switchTypes[24] = 1;
        VacControlPanel.switchTypes[9] = 0;
        VacControlPanel.switchTypes[10] = 0;
        VacControlPanel.switchTypes[11] = 0;
        VacControlPanel.switchTypes[12] = 1;
        VacControlPanel.switchTypes[25] = 1;
        VacControlPanel.switchTypes[14] = 1;
        VacControlPanel.switchTypes[15] = 1;
        VacControlPanel.switchTypes[16] = 1;
        VacControlPanel.switchTypes[17] = 1;
        VacControlPanel.switchTypes[18] = 0;
        VacControlPanel.switchTypes[23] = 1;
        latchMap = new LinkedHashMap<Integer, String>();
        latchMap.put(0, "Cryo Vacuum Bad");
        latchMap.put(2, "Cryo Gate Can't Open");
        latchMap.put(1, "Cryo Gate Forced Shut");
        latchMap.put(3, "Cryo Turbo Pump Bad");
        latchMap.put(4, "HX Vacuum Bad");
        latchMap.put(6, "HX Gate Can't Open");
        latchMap.put(5, "HX Gate Forced Shut");
        latchMap.put(7, "HX Turbo Pump Bad");
        conditionMap = new LinkedHashMap<Integer, String>();
        conditionMap.put(0, "Cryo Foreline OK");
        conditionMap.put(2, "Cryo Turbo Vac < 10");
        conditionMap.put(3, "Cryo Gate Delta OK");
        conditionMap.put(1, "Cryo Turbo Stopped");
        conditionMap.put(4, "Cryo Vacuum < 0.01");
        conditionMap.put(5, "HX Foreline OK");
        conditionMap.put(7, "HX Turbo Vac < 10");
        conditionMap.put(8, "HX Gate Delta OK");
        conditionMap.put(6, "HX Turbo Stopped");
        conditionMap.put(9, "HX Vacuum < 0.01");
        switchStateColors = new HashMap<SwitchState, Color>();
        switchStateColors.put(SwitchState.OFF, Color.BLACK);
        switchStateColors.put(SwitchState.ON, UiConstants.GREEN);
        switchStateColors.put(SwitchState.OFFLINE, UiConstants.BLUE);
        deviceStateColors = new HashMap<DeviceState, Color>();
        deviceStateColors.put(DeviceState.AUTOTUN, Color.BLACK);
        deviceStateColors.put(DeviceState.BRAKING, UiConstants.YELLOW);
        deviceStateColors.put(DeviceState.FAILED, UiConstants.RED);
        deviceStateColors.put(DeviceState.NORMAL, UiConstants.GREEN);
        deviceStateColors.put(DeviceState.STARTNG, UiConstants.YELLOW);
        deviceStateColors.put(DeviceState.STOPPED, Color.BLACK);
        deviceStateColors.put(DeviceState.WAITING, UiConstants.YELLOW);
        deviceStateColors.put(DeviceState.OPEN, UiConstants.GREEN);
        deviceStateColors.put(DeviceState.SHUT, Color.BLACK);
        deviceStateColors.put(DeviceState.TRANSIT, UiConstants.YELLOW);
        deviceStateColors.put(DeviceState.ERROR, UiConstants.RED);
        deviceStateColors.put(DeviceState.OFFLINE, UiConstants.BLUE);
        deviceStateColors.put(DeviceState.NOPWR, UiConstants.BLUE);
        PLC_STATE_WIDTH = UiUtilities.maxEnumLabelWidth(PLCState.class);
        CRYO_STATE_WIDTH = UiUtilities.maxEnumLabelWidth(CryoVacuumState.class);
        HX_STATE_WIDTH = UiUtilities.maxEnumLabelWidth(HxVacuumState.class);
        SWITCH_STATE_WIDTH = Math.max(UiUtilities.maxEnumLabelWidth(SwitchState.class), UiUtilities.maxEnumLabelWidth(DeviceState.class));
        LATCH_STATE_WIDTH = UiUtilities.maxEnumLabelWidth(LatchState.class);
        COND_STATUS_WIDTH = UiUtilities.maxEnumLabelWidth(ConditionState.class);
    }

    class DisablePanel
    implements Runnable {
        DisablePanel() {
        }

        @Override
        public void run() {
            int cond;
            VacControlPanel.this.sysStatPanel.disablePanel();
            VacControlPanel.this.plcStateValue.setEnabled(false);
            VacControlPanel.this.cryoStateValue.setEnabled(false);
            VacControlPanel.this.hxStateValue.setEnabled(false);
            Iterator iterator = switchMap.keySet().iterator();
            while (iterator.hasNext()) {
                int sw = (Integer)iterator.next();
                if (sw < 0) continue;
                VacControlPanel.this.switchStatus[sw].setEnabled(false);
                VacControlPanel.this.switchEnable[sw].setEnabled(false);
                VacControlPanel.this.switchOffRB[sw].setEnabled(false);
                VacControlPanel.this.switchOnRB[sw].setEnabled(false);
            }
            iterator = latchMap.keySet().iterator();
            while (iterator.hasNext()) {
                cond = (Integer)iterator.next();
                VacControlPanel.this.latchStatus[cond].setEnabled(false);
                VacControlPanel.this.latchResetBtn[cond].setEnabled(false);
            }
            iterator = conditionMap.keySet().iterator();
            while (iterator.hasNext()) {
                cond = (Integer)iterator.next();
                VacControlPanel.this.conditionStatus[cond].setEnabled(false);
            }
        }
    }

    class UpdateVacState
    implements Runnable {
        private final VacSysState vs;

        UpdateVacState(VacSysState vs) {
            this.vs = vs;
        }

        VacSysState getVacSysState() {
            return this.vs;
        }

        @Override
        public void run() {
            int cond;
            SwitchState state;
            VacControlPanel.this.sysStatPanel.updatePanel(this.vs.getTickMillis());
            PLCState plcState = this.vs.getPlcState();
            VacControlPanel.this.plcStateValue.setText(plcState.name());
            VacControlPanel.this.plcStateValue.setForeground(plcState == PLCState.ALIVE ? UiConstants.GREEN : (plcState == PLCState.OFFLINE ? UiConstants.BLUE : UiConstants.RED));
            VacControlPanel.this.plcStateValue.setEnabled(true);
            CryoVacuumState cvState = this.vs.getCryoVacuumState();
            VacControlPanel.this.cryoStateValue.setText(cvState.name());
            VacControlPanel.this.cryoStateValue.setForeground(cvState == CryoVacuumState.VACUUM ? UiConstants.GREEN : (cvState == CryoVacuumState.UNKNOWN ? UiConstants.BLUE : (cvState == CryoVacuumState.OFF ? UiConstants.RED : Color.BLACK)));
            VacControlPanel.this.cryoStateValue.setEnabled(true);
            HxVacuumState hvState = this.vs.getHxVacuumState();
            VacControlPanel.this.hxStateValue.setText(hvState.name());
            VacControlPanel.this.hxStateValue.setForeground(hvState == HxVacuumState.VACUUM ? UiConstants.GREEN : (hvState == HxVacuumState.UNKNOWN ? UiConstants.BLUE : (hvState == HxVacuumState.OFF ? UiConstants.RED : Color.BLACK)));
            VacControlPanel.this.hxStateValue.setEnabled(true);
            Iterator iterator = switchMap.keySet().iterator();
            while (iterator.hasNext()) {
                Color color;
                String text;
                int sw = (Integer)iterator.next();
                if (sw < 0) continue;
                state = this.vs.getSwitchState(sw);
                DeviceState devState = this.vs.getDeviceState(sw);
                if (state == SwitchState.OFFLINE || devState == null) {
                    text = state.name();
                    if (switchTypes[sw] == 1) {
                        text = state == SwitchState.OFF ? "SHUT" : (state == SwitchState.ON ? "OPEN" : text);
                    }
                    color = (Color)switchStateColors.get(state);
                } else {
                    text = devState.name();
                    color = (Color)deviceStateColors.get(devState);
                }
                VacControlPanel.this.switchStatus[sw].setText(text);
                VacControlPanel.this.switchStatus[sw].setForeground(color);
                VacControlPanel.this.switchEnable[sw].setText(this.vs.getSwitchEnable(sw) == SwitchEnable.OFF ? VacControlPanel.DSAB_TEXT : "");
                JRadioButton selButton = state == SwitchState.ON ? VacControlPanel.this.switchOnRB[sw] : VacControlPanel.this.switchOffRB[sw];
                selButton.setSelected(true);
                VacControlPanel.this.switchStatus[sw].setEnabled(true);
                VacControlPanel.this.switchEnable[sw].setEnabled(true);
                VacControlPanel.this.switchOffRB[sw].setEnabled(true);
                VacControlPanel.this.switchOnRB[sw].setEnabled(true);
            }
            iterator = latchMap.keySet().iterator();
            while (iterator.hasNext()) {
                cond = (Integer)iterator.next();
                state = this.vs.getLatch(cond);
                VacControlPanel.this.latchStatus[cond].setText(state.name());
                VacControlPanel.this.latchStatus[cond].setForeground(state == LatchState.OFFLINE ? UiConstants.BLUE : (state == LatchState.CLEAR ? UiConstants.GREEN : (state == LatchState.ACTIVE ? UiConstants.RED : UiConstants.PURPLE)));
                VacControlPanel.this.latchStatus[cond].setEnabled(true);
                VacControlPanel.this.latchResetBtn[cond].setEnabled(true);
            }
            iterator = conditionMap.keySet().iterator();
            while (iterator.hasNext()) {
                cond = (Integer)iterator.next();
                state = this.vs.getCondition(cond);
                VacControlPanel.this.conditionStatus[cond].setText(state.name());
                VacControlPanel.this.conditionStatus[cond].setForeground(state == ConditionState.OFF ? UiConstants.BLUE : (state == ConditionState.NO ? Color.BLACK : UiConstants.GREEN));
                VacControlPanel.this.conditionStatus[cond].setEnabled(true);
            }
            VacControlPanel.this.pumpcartButton.setEnabled(true);
        }
    }
}

