/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.lsst.ccs.bus.data.ConfigurationParameterType;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.utilities.constraints.Constraints;
import org.lsst.ccs.utilities.conv.InputConversionEngine;
import org.lsst.ccs.utilities.conv.TypeConversionException;
import org.lsst.ccs.utilities.conv.TypeUtils;
import org.lsst.ccs.utilities.structs.ParameterPath;
import org.lsst.ccs.utilities.structs.ViewValue;

public class ConfigurationParameterHandler
implements Comparable<ConfigurationParameterHandler> {
    private final ParameterPath parameterPath;
    private final ConfigurationParameter annotation;
    private final Method parameterChangerMethod;
    private final Field parameterField;
    private final Object target;
    private final ConfigurationParameterType configType;

    ConfigurationParameterHandler(String componentName, Method m, Field f, Object target) {
        this.parameterChangerMethod = m;
        this.parameterField = f;
        this.target = target;
        this.parameterField.setAccessible(true);
        this.annotation = f.getAnnotation(ConfigurationParameter.class);
        this.checkAgainstConstraints(this.getObjectValue());
        this.parameterPath = new ParameterPath(componentName, this.annotation.name().isEmpty() ? f.getName() : this.annotation.name());
        this.configType = this.annotation.isFinal() ? ConfigurationParameterType.FINAL : (this.annotation.isBuild() ? ConfigurationParameterType.BUILD : (this.annotation.isReadOnly() ? ConfigurationParameterType.READ_ONLY : ConfigurationParameterType.RUNTIME));
    }

    void invokeSetParameter(Object arg) {
        Method m = this.parameterChangerMethod;
        try {
            if (m != null) {
                m.setAccessible(true);
                m.invoke(this.target, arg);
            } else {
                Field f = this.parameterField;
                f.setAccessible(true);
                f.set(this.target, arg);
            }
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            String msg = cause == null ? ex.toString() : ex.getCause().getMessage();
            throw new RuntimeException("at parameter " + this.parameterPath + " : " + msg, ex);
        }
    }

    public ParameterPath getParameterPath() {
        return this.parameterPath;
    }

    String getCategory() {
        return this.annotation.category();
    }

    public boolean isFinal() {
        return this.configType == ConfigurationParameterType.FINAL;
    }

    public boolean isReadOnly() {
        return this.configType == ConfigurationParameterType.READ_ONLY;
    }

    public boolean isBuild() {
        return this.configType == ConfigurationParameterType.BUILD;
    }

    public ConfigurationParameterType getParameterType() {
        return this.configType;
    }

    String getUnits() {
        return this.annotation.units();
    }

    String getDescription() {
        return this.annotation.description();
    }

    String getRange() {
        return this.annotation.range();
    }

    final void checkAgainstConstraints(Object val) {
        String range = this.annotation.range();
        if (range != null) {
            Constraints.check((Object)val, (String)range);
        }
    }

    String getParameterName() {
        return this.parameterPath.getParameterName();
    }

    String getComponentName() {
        return this.parameterPath.getComponentName();
    }

    Type getType() {
        return this.parameterField.getGenericType();
    }

    final String getValue() {
        return TypeUtils.stringify((Object)this.getObjectValue());
    }

    private Object getObjectValue() {
        Object res;
        try {
            this.parameterField.setAccessible(true);
            res = this.parameterField.get(this.target);
            this.parameterField.setAccessible(false);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("could not access " + this.parameterField.getName(), ex);
        }
        return res;
    }

    ViewValue convert(String strValue) {
        try {
            Object val = InputConversionEngine.convertArgToType((String)strValue, (Type)this.parameterField.getGenericType());
            return new ViewValue(strValue, val);
        }
        catch (TypeConversionException ex) {
            throw new IllegalArgumentException("failure converting : " + this.parameterPath.toString() + " with value " + strValue + " to type " + this.parameterField.getGenericType().getTypeName(), ex);
        }
    }

    @Override
    public int compareTo(ConfigurationParameterHandler o) {
        return this.getParameterPath().compareTo((Object)o.getParameterPath());
    }
}

