/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.vacuum.ui.jas;

import javax.swing.JComponent;
import javax.swing.JPanel;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.common.ui.jas.ControlPanel;
import org.lsst.ccs.subsystem.common.ui.jas.MonOptionalPage;
import org.lsst.ccs.subsystem.vacuum.data.VacSysState;
import org.lsst.ccs.subsystem.vacuum.ui.VacControlPanel;
import org.lsst.ccs.subsystem.vacuum.ui.VacuumPage;

@Plugin(name="Vacuum Control Plugin", description="Vacuum Control Plugin")
public class VacControlPlugin
extends ConsolePlugin {
    public void initialize() {
        OptionalPage.getService().add((OptionalPage)new MonOptionalPage("vacuumType", VacControl.class, "Control", false, new String[0]));
        OptionalPage.getService().add((OptionalPage)new VacImageOptionalPage());
    }

    static class VacImageOptionalPage
    implements OptionalPage {
        private VacuumPage vacuumPage;

        VacImageOptionalPage() {
        }

        public boolean isAutoOpen() {
            return false;
        }

        public String getPage(AgentInfo agent) {
            return agent != null && agent.hasAgentProperty("vacuumType") ? "CCS Subsystems/" + agent.getName() + "/Schematic" : null;
        }

        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            this.vacuumPage = new VacuumPage(agent);
            JComponent panel = this.vacuumPage.getView().getPanel();
            panel.setName(agent.getName() + " Schematic");
            return panel;
        }

        public void opened(String page) {
            this.vacuumPage.getView().install();
        }

        public void closed(String page) {
            this.vacuumPage.getView().uninstall();
            this.vacuumPage = null;
        }
    }

    public static class VacControl
    extends ControlPanel
    implements StatusMessageListener {
        private CommandSender cmdSender;
        private VacControlPanel ctrlPanel;

        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals("VacuumState")) {
                    this.updateControlPanel(sd.getSubsystemData().getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException embeddedObjectDeserializationException) {
                // empty catch block
            }
        }

        public JPanel getControlPanel(CommandSender sndr) {
            this.cmdSender = sndr;
            this.ctrlPanel = new VacControlPanel(sndr);
            return this.ctrlPanel;
        }

        public void initControlPanel() {
            this.updateControlPanel(this.cmdSender.sendCommand(null, "getVacuumState", new Object[0]));
        }

        public void updateControlPanel(Object obj) {
            this.ctrlPanel.updateControlPanel((VacSysState)obj);
        }

        public void disableSystem() {
            this.ctrlPanel.disableSystem();
        }

        public StatusMessageListener getListener() {
            return this;
        }
    }
}

