/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.vacuum.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.vacuum.constants.ConditionState;
import org.lsst.ccs.subsystem.vacuum.constants.DeviceState;
import org.lsst.ccs.subsystem.vacuum.constants.LatchState;
import org.lsst.ccs.subsystem.vacuum.constants.PLCState;
import org.lsst.ccs.subsystem.vacuum.constants.SwitchEnable;
import org.lsst.ccs.subsystem.vacuum.constants.SwitchState;
import org.lsst.ccs.subsystem.vacuum.data.VacSysState;

public class VacControlPanel
extends JPanel {
    private static final int SWTP_PUMP = 0;
    private static final int SWTP_VALVE = 1;
    private static final String[] switchNames = new String[17];
    private static final int[] switchTypes;
    private static final String[] latchNames;
    private static final String[] conditionNames;
    private static final int switchStatusWidth;
    private static final int latchStatusWidth;
    private static final int condStatusWidth;
    private final CommandSender sender;
    private String subsys;
    private double mainPeriod = 5.0;
    private int switchMask;
    private int latchMask;
    private int conditionMask;
    private final JPanel mainPanel = new JPanel();
    private final JPanel headPanel = new JPanel();
    private final JLabel sysStateLabel = new JLabel("System State:  ");
    private final JLabel sysStateValue = new JLabel("STOPPED");
    private final JLabel plcStateLabel = new JLabel("PLC State:  ");
    private final JLabel plcStateValue = new JLabel("OFFLINE");
    private final JPanel periodPanel = new JPanel();
    private final JLabel periodLabel = new JLabel("Update Period: ");
    private final JTextField periodTextField = new JTextField();
    private final JLabel periodUnitsLabel = new JLabel("sec");
    private final JPanel switchPanel = new JPanel();
    private final JLabel[] switchLabel = new JLabel[17];
    private final JLabel[] switchStatus = new JLabel[17];
    private final ButtonGroup[] switchBG = new ButtonGroup[17];
    private final JRadioButton[] switchOffRB = new JRadioButton[17];
    private final JRadioButton[] switchOnRB = new JRadioButton[17];
    private final JPanel latchPanel = new JPanel();
    private final JLabel[] latchLabel = new JLabel[8];
    private final JLabel[] latchStatus = new JLabel[8];
    private final JButton[] latchResetBtn = new JButton[8];
    private final JPanel conditionPanel = new JPanel();
    private final JLabel[] conditionLabel = new JLabel[14];
    private final JLabel[] conditionStatus = new JLabel[14];
    private static final long serialVersionUID = 1L;

    public VacControlPanel(CommandSender cons) {
        this.sender = cons;
        this.initComponents();
        new UpdateVacStatus(new VacSysState()).run();
        new DisableSystem().run();
    }

    public void setSubsystem(String name) {
        this.subsys = name;
    }

    private void initComponents() {
        int cond;
        JLabel label;
        this.sysStateLabel.setFont(UiConstants.FONT);
        this.sysStateValue.setFont(UiConstants.FONT);
        Dimension d = this.sysStateValue.getPreferredSize();
        d.width = 100;
        this.sysStateValue.setPreferredSize(d);
        this.plcStateLabel.setFont(UiConstants.FONT);
        this.plcStateValue.setFont(UiConstants.FONT);
        d = this.plcStateValue.getPreferredSize();
        d.width = 100;
        this.plcStateValue.setPreferredSize(d);
        this.periodLabel.setFont(UiConstants.FONT);
        d = this.periodTextField.getPreferredSize();
        d.width = 45;
        this.periodTextField.setPreferredSize(d);
        this.periodTextField.setHorizontalAlignment(0);
        this.periodTextField.setText("...");
        this.periodTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VacControlPanel.this.setUpdatePeriod();
            }
        });
        this.periodUnitsLabel.setFont(UiConstants.FONT);
        for (int sw = 0; sw < 17; ++sw) {
            label = this.switchLabel[sw] = new JLabel(switchNames[sw] + ":");
            label.setFont(UiConstants.FONT);
            label = this.switchStatus[sw] = new JLabel("XXX");
            label.setFont(UiConstants.FONT);
            d = label.getPreferredSize();
            d.width = switchStatusWidth;
            label.setPreferredSize(d);
            int swType = switchTypes[sw];
            JRadioButton buttonOff = this.switchOffRB[sw] = new JRadioButton(swType == 0 ? "Off" : "Shut");
            buttonOff.setFont(UiConstants.FONT);
            buttonOff.setFocusable(false);
            buttonOff.setName(Integer.toString(sw));
            buttonOff.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String name = ((JRadioButton)evt.getSource()).getName();
                    VacControlPanel.this.setSwitchOn(Integer.valueOf(name), false);
                }
            });
            JRadioButton buttonOn = this.switchOnRB[sw] = new JRadioButton(swType == 0 ? "On" : "Open");
            buttonOn.setFont(UiConstants.FONT);
            buttonOn.setFocusable(false);
            buttonOn.setName(Integer.toString(sw));
            buttonOn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String name = ((JRadioButton)evt.getSource()).getName();
                    VacControlPanel.this.setSwitchOn(Integer.valueOf(name), true);
                }
            });
            ButtonGroup bg = this.switchBG[sw] = new ButtonGroup();
            bg.add(buttonOff);
            bg.add(buttonOn);
        }
        for (cond = 0; cond < 8; ++cond) {
            label = this.latchLabel[cond] = new JLabel(latchNames[cond] + ":");
            label.setFont(UiConstants.FONT);
            label = this.latchStatus[cond] = new JLabel("XXX");
            label.setFont(UiConstants.FONT);
            d = label.getPreferredSize();
            d.width = latchStatusWidth;
            label.setPreferredSize(d);
            JButton button = this.latchResetBtn[cond] = new JButton("Reset");
            Insets i = button.getMargin();
            i.left -= 3;
            i.right -= 3;
            button.setMargin(i);
            d = button.getPreferredSize();
            d.height -= 9;
            button.setPreferredSize(d);
            button.setFont(UiConstants.FONT);
            button.setFocusable(false);
            button.setName(Integer.toString(cond));
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String name = ((JButton)evt.getSource()).getName();
                    VacControlPanel.this.clearLatch(Integer.valueOf(name));
                }
            });
        }
        for (cond = 0; cond < 14; ++cond) {
            label = this.conditionLabel[cond] = new JLabel(conditionNames[cond] + ":");
            label.setFont(UiConstants.FONT);
            label = this.conditionStatus[cond] = new JLabel("XXX");
            label.setFont(UiConstants.FONT);
            d = label.getPreferredSize();
            d.width = condStatusWidth;
            label.setPreferredSize(d);
        }
        this.periodPanel.add(this.periodTextField);
        this.periodPanel.add(this.periodUnitsLabel);
        this.headPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbh = new GridBagConstraints();
        gbh.insets = new Insets(5, 0, 0, 0);
        gbh.gridx = 0;
        gbh.gridy = 0;
        gbh.anchor = 17;
        this.headPanel.add((Component)this.sysStateLabel, gbh);
        ++gbh.gridx;
        this.headPanel.add((Component)this.sysStateValue, gbh);
        ++gbh.gridx;
        this.headPanel.add((Component)this.plcStateLabel, gbh);
        ++gbh.gridx;
        this.headPanel.add((Component)this.plcStateValue, gbh);
        ++gbh.gridx;
        this.headPanel.add((Component)this.periodLabel, gbh);
        ++gbh.gridx;
        this.headPanel.add((Component)this.periodPanel, gbh);
        TitledBorder border = BorderFactory.createTitledBorder(new LineBorder(Color.BLACK), "Switches");
        border.setTitleJustification(2);
        border.setTitleFont(UiConstants.FONT);
        border.setTitleColor(UiConstants.BLUE);
        this.switchPanel.setBorder(border);
        this.switchPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbs = new GridBagConstraints();
        gbs.gridx = 0;
        gbs.gridy = 0;
        gbs.insets.bottom = -8;
        this.switchPanel.add((Component)new JLabel(" "), gbs);
        border = BorderFactory.createTitledBorder(new LineBorder(Color.BLACK), "PLC Error Conditions");
        border.setTitleJustification(2);
        border.setTitleFont(UiConstants.FONT);
        border.setTitleColor(UiConstants.BLUE);
        this.latchPanel.setBorder(border);
        this.latchPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbl = new GridBagConstraints();
        gbl.gridx = 0;
        gbl.gridy = 0;
        gbl.insets.bottom = -8;
        this.latchPanel.add((Component)new JLabel(" "), gbl);
        border = BorderFactory.createTitledBorder(new LineBorder(Color.BLACK), "PLC Running Conditions");
        border.setTitleJustification(2);
        border.setTitleFont(UiConstants.FONT);
        border.setTitleColor(UiConstants.BLUE);
        this.conditionPanel.setBorder(border);
        this.conditionPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets.bottom = -8;
        this.conditionPanel.add((Component)new JLabel(" "), gbc);
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.insets = new Insets(0, 0, 0, 0);
        gbm.anchor = 11;
        gbm.gridx = 0;
        gbm.gridy = 0;
        this.mainPanel.add((Component)this.headPanel, gbm);
        ++gbm.gridy;
        this.mainPanel.add((Component)this.switchPanel, gbm);
        ++gbm.gridy;
        gbm.insets.top = 6;
        this.mainPanel.add((Component)this.latchPanel, gbm);
        ++gbm.gridy;
        this.mainPanel.add((Component)this.conditionPanel, gbm);
        this.add(this.mainPanel);
    }

    private void updateSwitchLayout(int switches) {
        for (int sw = 0; sw < 17; ++sw) {
            if ((this.switchMask & 1 << sw) == 0) continue;
            this.switchPanel.remove(this.switchLabel[sw]);
            this.switchPanel.remove(this.switchStatus[sw]);
            this.switchPanel.remove(this.switchOffRB[sw]);
            this.switchPanel.remove(this.switchOnRB[sw]);
        }
        GridBagConstraints gbs = new GridBagConstraints();
        gbs.anchor = 18;
        gbs.gridy = 0;
        int colm = 0;
        for (int sw = 0; sw < 17; ++sw) {
            if ((switches & 1 << sw) == 0) continue;
            if (colm == 0) {
                gbs.gridx = 0;
                ++gbs.gridy;
            }
            gbs.insets.top = 0;
            gbs.insets.left = colm == 0 ? 4 : 40;
            this.switchPanel.add((Component)this.switchLabel[sw], gbs);
            gbs.insets.left = 6;
            ++gbs.gridx;
            this.switchPanel.add((Component)this.switchStatus[sw], gbs);
            ++gbs.gridx;
            gbs.insets.top = -4;
            this.switchPanel.add((Component)this.switchOffRB[sw], gbs);
            ++gbs.gridx;
            gbs.insets.right = 3;
            this.switchPanel.add((Component)this.switchOnRB[sw], gbs);
            gbs.insets.right = 0;
            ++gbs.gridx;
            colm = (colm + 1) % 2;
        }
        this.switchMask = switches;
    }

    private void updateLatchLayout(int conditions) {
        for (int cond = 0; cond < 8; ++cond) {
            if ((this.latchMask & 1 << cond) == 0) continue;
            this.latchPanel.remove(this.latchLabel[cond]);
            this.latchPanel.remove(this.latchStatus[cond]);
            this.latchPanel.remove(this.latchResetBtn[cond]);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridy = 0;
        int colm = 0;
        for (int cond = 0; cond < 8; ++cond) {
            if ((conditions & 1 << cond) == 0) continue;
            if (colm == 0) {
                gbc.gridx = 0;
                ++gbc.gridy;
            }
            gbc.insets.top = 0;
            gbc.insets.bottom = 4;
            gbc.insets.left = colm == 0 ? 4 : 40;
            this.latchPanel.add((Component)this.latchLabel[cond], gbc);
            gbc.insets.left = 6;
            ++gbc.gridx;
            this.latchPanel.add((Component)this.latchStatus[cond], gbc);
            ++gbc.gridx;
            gbc.insets.top = -1;
            gbc.insets.right = 4;
            this.latchPanel.add((Component)this.latchResetBtn[cond], gbc);
            gbc.insets.right = 0;
            ++gbc.gridx;
            colm = (colm + 1) % 2;
        }
        this.latchMask = conditions;
    }

    private void updateConditionLayout(int conditions) {
        for (int cond = 0; cond < 8; ++cond) {
            if ((this.conditionMask & 1 << cond) == 0) continue;
            this.conditionPanel.remove(this.conditionLabel[cond]);
            this.conditionPanel.remove(this.conditionStatus[cond]);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridy = 0;
        int colm = 0;
        for (int cond = 0; cond < 14; ++cond) {
            if ((conditions & 1 << cond) == 0) continue;
            if (colm == 0) {
                gbc.gridx = 0;
                ++gbc.gridy;
            }
            gbc.insets.top = 0;
            gbc.insets.bottom = 4;
            gbc.insets.left = colm == 0 ? 4 : 40;
            this.conditionPanel.add((Component)this.conditionLabel[cond], gbc);
            ++gbc.gridx;
            gbc.insets.left = 6;
            gbc.insets.right = 4;
            this.conditionPanel.add((Component)this.conditionStatus[cond], gbc);
            gbc.insets.right = 0;
            ++gbc.gridx;
            colm = (colm + 1) % 2;
        }
        this.conditionMask = conditions;
    }

    private void setUpdatePeriod() {
        try {
            double value = Double.valueOf(this.periodTextField.getText());
            this.sender.sendCommand(this.subsys, "setUpdatePeriod", new Object[]{(int)(1000.0 * value)});
            this.periodTextField.setEnabled(false);
        }
        catch (NumberFormatException nfe) {
            this.periodTextField.setText(String.valueOf(this.mainPeriod));
        }
    }

    private void setSwitchOn(int sw, boolean value) {
        this.switchOffRB[sw].setEnabled(false);
        this.switchOnRB[sw].setEnabled(false);
        this.sender.sendCommand(this.subsys, "setSwitchOn", new Object[]{sw, value});
    }

    private void clearLatch(int cond) {
        this.latchResetBtn[cond].setEnabled(false);
        this.sender.sendCommand(this.subsys, "clearLatch", new Object[]{cond});
    }

    public void updateControlPanel(VacSysState rs) {
        SwingUtilities.invokeLater(new UpdateVacStatus(rs));
    }

    public void disableSystem() {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    static {
        VacControlPanel.switchNames[0] = "Cryo Turbo Pump";
        VacControlPanel.switchNames[1] = "Cryo Ion Pump 1";
        VacControlPanel.switchNames[2] = "Cryo Ion Pump 2";
        VacControlPanel.switchNames[3] = "Cryo Ion Pump 3";
        VacControlPanel.switchNames[4] = "Cryo Ion Pump 4";
        VacControlPanel.switchNames[5] = "Cryo Ion Pump 5";
        VacControlPanel.switchNames[6] = "Cryo Ion Pump 6";
        VacControlPanel.switchNames[7] = "Cryo Gate Valve";
        VacControlPanel.switchNames[8] = "Hx Turbo Pump";
        VacControlPanel.switchNames[9] = "Hx Ion Pump 1";
        VacControlPanel.switchNames[10] = "Hx Ion Pump 2";
        VacControlPanel.switchNames[11] = "Hx Gate Valve";
        VacControlPanel.switchNames[12] = "O-ring Ion Pump";
        VacControlPanel.switchNames[13] = "O-ring Fpp Valve";
        VacControlPanel.switchNames[14] = "O-ring Fh Valve";
        VacControlPanel.switchNames[15] = "O-ring L3h Valve";
        VacControlPanel.switchNames[16] = "O-ring L3 Valve";
        switchTypes = new int[17];
        VacControlPanel.switchTypes[0] = 0;
        VacControlPanel.switchTypes[1] = 0;
        VacControlPanel.switchTypes[2] = 0;
        VacControlPanel.switchTypes[3] = 0;
        VacControlPanel.switchTypes[4] = 0;
        VacControlPanel.switchTypes[5] = 0;
        VacControlPanel.switchTypes[6] = 0;
        VacControlPanel.switchTypes[7] = 1;
        VacControlPanel.switchTypes[8] = 0;
        VacControlPanel.switchTypes[9] = 0;
        VacControlPanel.switchTypes[10] = 0;
        VacControlPanel.switchTypes[11] = 1;
        VacControlPanel.switchTypes[12] = 0;
        VacControlPanel.switchTypes[13] = 1;
        VacControlPanel.switchTypes[14] = 1;
        VacControlPanel.switchTypes[15] = 1;
        VacControlPanel.switchTypes[16] = 1;
        latchNames = new String[8];
        VacControlPanel.latchNames[2] = "Cryo Gate Can't Open";
        VacControlPanel.latchNames[1] = "Cryo Gate Forced Shut";
        VacControlPanel.latchNames[0] = "Cryo Vacuum Bad";
        VacControlPanel.latchNames[3] = "Cryo Turbo Pump Bad";
        VacControlPanel.latchNames[6] = "Hx Gate Can't Open";
        VacControlPanel.latchNames[5] = "Hx Gate Forced Shut";
        VacControlPanel.latchNames[4] = "Hx Vacuum Bad";
        VacControlPanel.latchNames[7] = "Hx Turbo Pump Bad";
        conditionNames = new String[14];
        VacControlPanel.conditionNames[0] = "Cryo Foreline OK";
        VacControlPanel.conditionNames[2] = "Cryo Turbo Pr < 10";
        VacControlPanel.conditionNames[1] = "Cryo Turbo Pump Off";
        VacControlPanel.conditionNames[4] = "Cryo Vacuum < 0.001";
        VacControlPanel.conditionNames[3] = "Cryo Vacuum < 0.1";
        VacControlPanel.conditionNames[5] = "HX Foreline OK";
        VacControlPanel.conditionNames[7] = "HX Turbo Pr < 10";
        VacControlPanel.conditionNames[6] = "HX Turbo Pump Off";
        VacControlPanel.conditionNames[9] = "HX Vacuum < 0.001";
        VacControlPanel.conditionNames[8] = "HX Vacuum < 0.1";
        VacControlPanel.conditionNames[11] = "FH Gate Okay";
        VacControlPanel.conditionNames[10] = "FPP Gate Okay";
        VacControlPanel.conditionNames[12] = "L3H Gate Okay";
        VacControlPanel.conditionNames[13] = "L3 Gate Okay";
        JLabel label = new JLabel();
        label.setFont(UiConstants.FONT);
        int width = 0;
        for (SwitchState switchState : SwitchState.values()) {
            label.setText(switchState.name());
            width = Math.max(width, label.getPreferredSize().width);
        }
        for (SwitchState switchState : DeviceState.values()) {
            label.setText(switchState.name());
            width = Math.max(width, label.getPreferredSize().width);
        }
        switchStatusWidth = width;
        width = 0;
        for (SwitchState switchState : LatchState.values()) {
            label.setText(switchState.name());
            width = Math.max(width, label.getPreferredSize().width);
        }
        latchStatusWidth = width;
        width = 0;
        for (SwitchState switchState : ConditionState.values()) {
            label.setText(switchState.name());
            width = Math.max(width, label.getPreferredSize().width);
        }
        condStatusWidth = width;
    }

    class DisableSystem
    implements Runnable {
        DisableSystem() {
        }

        @Override
        public void run() {
            int cond;
            VacControlPanel.this.sysStateValue.setText("STOPPED");
            VacControlPanel.this.sysStateValue.setForeground(UiConstants.RED);
            VacControlPanel.this.plcStateValue.setEnabled(false);
            VacControlPanel.this.periodTextField.setEnabled(false);
            for (int sw = 0; sw < 17; ++sw) {
                VacControlPanel.this.switchStatus[sw].setEnabled(false);
                VacControlPanel.this.switchOffRB[sw].setEnabled(false);
                VacControlPanel.this.switchOnRB[sw].setEnabled(false);
            }
            for (cond = 0; cond < 8; ++cond) {
                VacControlPanel.this.latchStatus[cond].setEnabled(false);
                VacControlPanel.this.latchResetBtn[cond].setEnabled(false);
            }
            for (cond = 0; cond < 14; ++cond) {
                VacControlPanel.this.conditionStatus[cond].setEnabled(false);
            }
        }
    }

    class UpdateVacStatus
    implements Runnable {
        private final VacSysState vs;

        UpdateVacStatus(VacSysState vs) {
            this.vs = vs;
        }

        @Override
        public void run() {
            LatchState state;
            int cond;
            VacControlPanel.this.sysStateValue.setText("RUNNING");
            VacControlPanel.this.sysStateValue.setForeground(UiConstants.GREEN);
            PLCState plcState = this.vs.getPlcState();
            VacControlPanel.this.plcStateValue.setText(plcState.name());
            VacControlPanel.this.plcStateValue.setForeground(plcState == PLCState.ALIVE ? UiConstants.GREEN : (plcState == PLCState.OFFLINE ? UiConstants.BLUE : UiConstants.RED));
            VacControlPanel.this.plcStateValue.setEnabled(true);
            VacControlPanel.this.periodTextField.setEnabled(true);
            VacControlPanel.this.mainPeriod = (double)this.vs.getTickMillis() / 1000.0;
            VacControlPanel.this.periodTextField.setText(String.valueOf(VacControlPanel.this.mainPeriod));
            int switches = 0;
            for (int sw = 0; sw < 17; ++sw) {
                Color color;
                String text;
                if (!this.vs.hasSwitch(sw)) continue;
                switches |= 1 << sw;
                SwitchState state2 = this.vs.getSwitchState(sw);
                SwitchEnable enable = this.vs.getSwitchEnable(sw);
                if (enable == SwitchEnable.OFF) {
                    text = "DISABLD";
                    color = UiConstants.RED;
                } else {
                    text = state2.name();
                    if (switchTypes[sw] == 1) {
                        String string = state2 == SwitchState.OFF ? "SHUT" : (text = state2 == SwitchState.ON ? "OPEN" : text);
                    }
                    color = state2 == SwitchState.OFF ? Color.black : (state2 == SwitchState.ON ? UiConstants.GREEN : UiConstants.BLUE);
                    DeviceState devState = this.vs.getDeviceState(sw);
                    if (devState != null && state2 != SwitchState.OFFLINE) {
                        text = devState.name();
                        if (devState == DeviceState.FAILED) {
                            color = UiConstants.RED;
                        }
                    }
                }
                VacControlPanel.this.switchStatus[sw].setText(text);
                VacControlPanel.this.switchStatus[sw].setForeground(color);
                JRadioButton selButton = state2 == SwitchState.ON ? VacControlPanel.this.switchOnRB[sw] : VacControlPanel.this.switchOffRB[sw];
                selButton.setSelected(true);
                VacControlPanel.this.switchStatus[sw].setEnabled(true);
                VacControlPanel.this.switchOffRB[sw].setEnabled(true);
                VacControlPanel.this.switchOnRB[sw].setEnabled(true);
            }
            if (switches != VacControlPanel.this.switchMask) {
                VacControlPanel.this.updateSwitchLayout(switches);
            }
            int conditions = 0;
            for (cond = 0; cond < 8; ++cond) {
                if (!this.vs.hasLatch(cond)) continue;
                conditions |= 1 << cond;
                state = this.vs.getLatch(cond);
                VacControlPanel.this.latchStatus[cond].setText(state.name());
                VacControlPanel.this.latchStatus[cond].setForeground(state == LatchState.OFFLINE ? UiConstants.BLUE : (state == LatchState.CLEAR ? UiConstants.GREEN : (state == LatchState.ACTIVE ? UiConstants.RED : UiConstants.PURPLE)));
                VacControlPanel.this.latchStatus[cond].setEnabled(true);
                VacControlPanel.this.latchResetBtn[cond].setEnabled(true);
            }
            if (conditions != VacControlPanel.this.latchMask) {
                VacControlPanel.this.updateLatchLayout(conditions);
            }
            conditions = 0;
            for (cond = 0; cond < 14; ++cond) {
                if (!this.vs.hasCondition(cond)) continue;
                conditions |= 1 << cond;
                state = this.vs.getCondition(cond);
                VacControlPanel.this.conditionStatus[cond].setText(state.name());
                VacControlPanel.this.conditionStatus[cond].setForeground(state == ConditionState.OFF ? UiConstants.BLUE : (state == ConditionState.NO ? Color.BLACK : UiConstants.GREEN));
                VacControlPanel.this.conditionStatus[cond].setEnabled(true);
            }
            if (conditions != VacControlPanel.this.conditionMask) {
                VacControlPanel.this.updateConditionLayout(conditions);
            }
        }
    }
}

