package org.lsst.ccs.subsystem.vacuum.ui.jas;

import javax.swing.JComponent;
import javax.swing.JPanel;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.common.ui.jas.ControlPanel;
import org.lsst.ccs.subsystem.common.ui.jas.MonOptionalPage;
import org.lsst.ccs.subsystem.vacuum.constants.VacuumAgentProperties;
import org.lsst.ccs.subsystem.vacuum.data.VacSysState;
import org.lsst.ccs.subsystem.vacuum.ui.VacControlPanel;
import org.lsst.ccs.subsystem.vacuum.ui.VacuumPage;

/**
 *
 * @author tonyj
 */
@Plugin(name = "Vacuum Control Plugin", description = "Vacuum Control Plugin")
public class VacControlPlugin extends ConsolePlugin {

    @Override
    public void initialize() {
        OptionalPage.getService().add(new MonOptionalPage(VacuumAgentProperties.VACUUM_TYPE, VacControl.class, "Control", false));
        OptionalPage.getService().add(new VacImageOptionalPage());
    }
    
    public static class VacControl extends ControlPanel implements StatusMessageListener {

        private CommandSender cmdSender;
        private VacControlPanel ctrlPanel;
        
        @Override
        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals(VacSysState.KEY)) {
                    updateControlPanel(((KeyValueData)sd.getSubsystemData()).getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException x) {
            }
        }

        @Override
        public JPanel getControlPanel(CommandSender sndr) {
            cmdSender = sndr;
            return ctrlPanel = new VacControlPanel(sndr);
        }

        @Override
        public void initControlPanel() {
            updateControlPanel(cmdSender.sendCommand(null, "getVacuumState"));
        }

        @Override
        public void updateControlPanel(Object obj) {
            ctrlPanel.updateControlPanel((VacSysState)obj);
        }

        @Override
        public void disableSystem() {
            ctrlPanel.disableSystem();
        }

        @Override
        public StatusMessageListener getListener() {
            return this;
        }
    }
    
    static class VacImageOptionalPage implements OptionalPage {
        
        private VacuumPage vacuumPage;

        @Override
        public boolean isAutoOpen() {
            return false;
        }

        @Override
        public String getPage(AgentInfo agent) {
            return agent != null && agent.hasAgentProperty(VacuumAgentProperties.VACUUM_TYPE)
                     ? "CCS Subsystems/" + agent.getName() + "/Schematic" : null;
        }
        
        @Override
        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            vacuumPage = new VacuumPage(agent);
            JComponent panel = vacuumPage.getView().getPanel();
            panel.setName(agent.getName() + " Schematic");
            return panel;
        }

        @Override
        public void opened(String page) {
            vacuumPage.getView().install();
        }

        @Override
        public void closed(String page) {
            vacuumPage.getView().uninstall();
            vacuumPage = null;
        }
    }

}
