/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.lsst.ccs.localdb.dao.LocaldbFacade;
import org.lsst.ccs.localdb.statusdb.BatchPersister;
import org.lsst.ccs.localdb.statusdb.StatusDataPersister;
import org.lsst.ccs.localdb.statusdb.model.DataDesc;
import org.lsst.ccs.localdb.statusdb.model.RawData;
import org.lsst.ccs.localdb.statusdb.model.StatData;
import org.lsst.ccs.localdb.statusdb.model.StatDesc;
import org.lsst.ccs.localdb.statusdb.model.StatTimeInterval;
import org.lsst.ccs.utilities.logging.Logger;

public class StatDataPersister
extends BatchPersister<RawData> {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.localdb.statusdb");
    private final Map<DataDesc, Map<StatDesc, StatData>> statCache = new HashMap<DataDesc, Map<StatDesc, StatData>>();

    public StatDataPersister() {
        super(3000, false);
    }

    @Override
    public void persist(RawData data, Session sess) {
        DataDesc dd = data.getDataDesc();
        Map<StatDesc, StatData> dataCache = this.statCache.get(dd);
        if (dataCache == null) {
            dataCache = new HashMap<StatDesc, StatData>();
            this.statCache.put(dd, dataCache);
        }
        List<StatDesc> stats = StatusDataPersister.getStatDescs(dd, sess);
        long dataTime = data.getTime();
        for (StatDesc stat : stats) {
            if (data.getDoubleData() == null) continue;
            long binWidth = stat.getTimeBinWidth();
            StatTimeInterval sti = LocaldbFacade.getStatTimeInterval((long)binWidth, (long)dataTime, (Session)sess);
            StatData cachedStat = dataCache.get(stat);
            if (cachedStat == null) {
                StatData persistedSD = LocaldbFacade.getStatDataOrNull((StatDesc)stat, (StatTimeInterval)sti, (Session)sess);
                if (persistedSD != null) {
                    log.fine((Object)("found existing stat data for " + persistedSD.getStatDesc().getDataDesc().getDataPath().getFullKey()));
                    dataCache.put(stat, persistedSD);
                    continue;
                }
                dataCache.put(stat, new StatData(stat, data, sti));
                continue;
            }
            if (cachedStat.getStatTimeInterval().equals((Object)sti)) {
                cachedStat.accumulate(data);
                continue;
            }
            if (cachedStat.getStatTimeInterval().getStartTime() < sti.getStartTime()) {
                if (cachedStat.getId() > 0L) {
                    log.finest((Object)("merging stat data " + cachedStat.getStatDesc().getDataDesc().getDataPath().getFullKey() + " and timebinwidth " + cachedStat.getStatDesc().getTimeBinWidth() + " starting at " + cachedStat.getStatTimeInterval().getStartTime()));
                    sess.merge((Object)cachedStat);
                } else {
                    log.finest((Object)("persisting stat data " + cachedStat.getStatDesc().getDataDesc().getDataPath().getFullKey() + " and timebinwidth " + cachedStat.getStatDesc().getTimeBinWidth() + " starting at " + cachedStat.getStatTimeInterval().getStartTime()));
                    sess.persist((Object)cachedStat);
                }
                StatData newStatData = LocaldbFacade.getStatDataOrNull((StatDesc)stat, (StatTimeInterval)sti, (Session)sess);
                if (newStatData != null) {
                    newStatData.accumulate(data);
                } else {
                    newStatData = new StatData(stat, data, sti);
                }
                dataCache.put(stat, newStatData);
                continue;
            }
            log.info((Object)("data received in a non ascending timestamp order for key : " + dd.getDataPath().getFullKey()));
            if (cachedStat.getId() > 0L) {
                log.finest((Object)("merging : " + cachedStat.getStatDesc().getDataDesc().getDataPath().getFullKey() + " and timebinwidth " + cachedStat.getStatDesc().getTimeBinWidth() + " starting at " + cachedStat.getStatTimeInterval().getStartTime()));
                sess.merge((Object)cachedStat);
            } else {
                log.finest((Object)("persisting stat data " + cachedStat.getStatDesc().getDataDesc().getDataPath().getFullKey() + " and timebinwidth " + cachedStat.getStatDesc().getTimeBinWidth() + " starting at " + cachedStat.getStatTimeInterval().getStartTime()));
                sess.persist((Object)cachedStat);
            }
            StatData statData = LocaldbFacade.getStatDataOrNull((StatDesc)stat, (StatTimeInterval)sti, (Session)sess);
            if (statData != null) {
                log.fine((Object)("found existing stat data for " + statData.getStatDesc().getDataDesc().getDataPath().getFullKey()));
                statData.accumulate(data);
                dataCache.put(stat, statData);
            } else {
                statData = new StatData(stat, data, sti);
            }
            dataCache.put(stat, statData);
        }
    }

    public void flush(Session sess) {
        for (Map.Entry<DataDesc, Map<StatDesc, StatData>> entry : this.statCache.entrySet()) {
            Iterator<Map.Entry<StatDesc, StatData>> it = entry.getValue().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<StatDesc, StatData> e = it.next();
                StatData val = e.getValue();
                log.finest((Object)("persisting stat data " + val.getStatDesc().getDataDesc().getDataPath().getFullKey() + " and timebinwidth " + val.getStatDesc().getTimeBinWidth()));
                try {
                    if (val.getId() > 0L) {
                        log.fine((Object)("merging : " + val.getStatDesc().getDataDesc().getDataPath().getFullKey()));
                        sess.merge((Object)val);
                    } else {
                        sess.persist((Object)val);
                    }
                }
                catch (Exception ex) {
                    log.error((Object)("cannot persist " + val.getStatDesc().getDataDesc().getDataPath().getFullKey() + " with tbw " + val.getStatTimeInterval().getStartTime() + ":" + val.getStatTimeInterval().getBinWidth()), (Throwable)ex);
                }
                it.remove();
            }
        }
    }
}

