/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.commandbrowser;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.RouteSelectionCommandSet;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.util.ThreadUtil;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.subsystem.shell.ConsoleCommandShell;

class AgentHandle
implements Serializable {
    private final RouteSelectionCommandSet routeSelector = ConsoleCommandShell.createConsoleCommandShell((Agent)Console.getConsole()).getConsoleCommandSet();
    private final String name;
    private AgentInfo info;
    private final AgentLockService lockService;
    private final AgentLockService.AgentLockUpdateListener lockListener;
    private final AgentLockService.AgentLevelListener levelListener;
    final Map<String, Dictionary> dictionaries = new HashMap<String, Dictionary>();
    final Map<String, CommandSet> commandSets = new HashMap<String, CommandSet>();
    private AgentLock lock;
    private int level;
    private boolean online;
    private boolean adjusting;
    private final CopyOnWriteArrayList<ChangeListener> listeners = new CopyOnWriteArrayList();
    private final ChangeEvent changeEvent = new ChangeEvent(this);

    AgentHandle(String agent) {
        this.name = agent;
        this.lockService = (AgentLockService)Console.getConsole().getAgentService(AgentLockService.class);
        this.lockListener = (agentName, agentLock) -> {
            if (agent.equals(agentName)) {
                ThreadUtil.invokeLater(() -> {
                    this.lock = agentLock;
                    this.listeners.forEach(listener -> listener.stateChanged(this.changeEvent));
                });
            }
        };
        this.levelListener = (agentName, agentLevel) -> {
            if (agent.equals(agentName)) {
                ThreadUtil.invokeLater(() -> {
                    this.level = agentLevel;
                    this.listeners.forEach(listener -> listener.stateChanged(this.changeEvent));
                });
            }
        };
        this.online = false;
    }

    AgentHandle(AgentInfo agentInfo) {
        this(agentInfo.getName());
        this.info = agentInfo;
        this.online = true;
    }

    void init() {
        this.lockService.addAgentLockUpdateListener(this.lockListener);
        this.lockService.addAgentLevelListener(this.levelListener);
    }

    void shutdown() {
        this.lockService.removeAgentLockUpdateListener(this.lockListener);
        this.lockService.removeAgentLevelListener(this.levelListener);
    }

    public String getName() {
        return this.name;
    }

    AgentInfo getInfo() {
        return this.info;
    }

    AgentLock getLock() {
        return this.lock;
    }

    int getLevel() {
        return this.level;
    }

    boolean isAdjusting() {
        return this.adjusting;
    }

    Map<String, Dictionary> getDictionaries() {
        return this.dictionaries;
    }

    Map<String, CommandSet> getCommandSets() {
        return this.commandSets;
    }

    boolean isOnline() {
        return this.online;
    }

    boolean isLockedByMe() {
        return this.lock != null && this.lock.getOwnerAgentName().equals(Console.getConsole().getAgentInfo().getName());
    }

    void setLock(final boolean locked) {
        this.adjusting = true;
        this.notifyListeners();
        new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                if (locked) {
                    AgentHandle.this.lockService.lockAgent(AgentHandle.this.name);
                } else {
                    AgentHandle.this.lockService.unlockAgent(AgentHandle.this.name);
                }
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (InterruptedException x) {
                    Console.getConsole().error("Unable to " + (locked ? "" : "un") + "lock the " + AgentHandle.this.name + " subsystem.");
                }
                catch (ExecutionException x) {
                    try {
                        Console.getConsole().error("Unable to " + (locked ? "" : "un") + "lock the " + AgentHandle.this.name + " subsystem.", (Exception)x.getCause());
                    }
                    catch (ClassCastException xx) {
                        Console.getConsole().error("Unable to " + (locked ? "" : "un") + "lock the " + AgentHandle.this.name + " subsystem.", x);
                    }
                }
                AgentHandle.this.adjusting = false;
                AgentHandle.this.notifyListeners();
            }
        }.execute();
    }

    public void setLevel(final int level) {
        this.adjusting = true;
        this.notifyListeners();
        new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                AgentHandle.this.lockService.setLevelForAgent(AgentHandle.this.name, level);
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (InterruptedException x) {
                    Console.getConsole().error("Unable to set level " + level + " for " + AgentHandle.this.name + " subsystem.");
                }
                catch (ExecutionException x) {
                    try {
                        Console.getConsole().error("Unable to set level " + level + " for " + AgentHandle.this.name + " subsystem.", (Exception)x.getCause());
                    }
                    catch (ClassCastException xx) {
                        Console.getConsole().error("Unable to set level " + level + " for " + AgentHandle.this.name + " subsystem.", x);
                    }
                }
                AgentHandle.this.adjusting = false;
                AgentHandle.this.notifyListeners();
            }
        }.execute();
    }

    public void updateDictionaries() {
        this.commandSets.clear();
        this.dictionaries.clear();
        if (this.online) {
            Map commands = this.routeSelector.getCommandSetsForRoute(this.name);
            if (commands.isEmpty()) {
                new SwingWorker<Boolean, Object>(){

                    @Override
                    protected Boolean doInBackground() throws Exception {
                        int attempt = 0;
                        Map c = Collections.emptyMap();
                        while (attempt < 100 && c.isEmpty()) {
                            Thread.sleep(attempt++ < 10 ? 200L : 1000L);
                            c = AgentHandle.this.routeSelector.getCommandSetsForRoute(AgentHandle.this.name);
                        }
                        return !c.isEmpty();
                    }

                    @Override
                    protected void done() {
                        try {
                            if (((Boolean)this.get()).booleanValue()) {
                                AgentHandle.this.updateDictionaries();
                            }
                        }
                        catch (InterruptedException | ExecutionException exception) {
                            // empty catch block
                        }
                    }
                }.execute();
                return;
            }
            for (Map.Entry entry : commands.entrySet()) {
                this.commandSets.put((String)entry.getKey(), (CommandSet)entry.getValue());
                this.dictionaries.put((String)entry.getKey(), ((CommandSet)entry.getValue()).getCommandDictionary());
            }
        }
        this.notifyListeners();
    }

    public void updateOnline(AgentInfo agentInfo) {
        boolean bl = this.online = agentInfo != null;
        if (this.online) {
            this.info = agentInfo;
        }
        this.updateDictionaries();
    }

    public boolean addListener(ChangeListener listener) {
        return this.listeners.addIfAbsent(listener);
    }

    public boolean removeListener(ChangeListener listener) {
        return this.listeners.remove(listener);
    }

    public boolean removeAllListeners() {
        boolean out = !this.listeners.isEmpty();
        this.listeners.clear();
        return out;
    }

    private void notifyListeners() {
        this.listeners.forEach(listener -> listener.stateChanged(this.changeEvent));
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AgentHandle) {
            return this.name.equals(((AgentHandle)obj).name);
        }
        return false;
    }
}

