/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.states.DataProviderState;
import org.lsst.ccs.gconsole.agent.AgentChannel;
import org.lsst.ccs.gconsole.agent.MutableAgentChannel;
import org.lsst.ccs.gconsole.plugins.monitor.AbstractMonitorView1;
import org.lsst.ccs.gconsole.plugins.monitor.ChannelHandle;
import org.lsst.ccs.gconsole.plugins.monitor.DefaultChannelHandle;
import org.lsst.ccs.gconsole.plugins.monitor.Updatable;

public abstract class AbstractMonitorView2
extends AbstractMonitorView1 {
    protected final LinkedHashMap<String, ChannelHandle> path2data = new LinkedHashMap();

    @Override
    public boolean isEmpty() {
        return this.path2data.isEmpty();
    }

    @Override
    protected final void addChannels(AgentInfo agent, Map<String, AgentChannel> channels) {
        for (Map.Entry<String, AgentChannel> e : channels.entrySet()) {
            String path = e.getKey();
            ChannelHandle handle = this.createChannelHandle(path, e.getValue(), null);
            this.path2data.put(path, handle);
        }
        this.resetChannels();
    }

    @Override
    protected final void removeChannels(AgentInfo agent, List<String> paths) {
        for (String path : paths) {
            AgentChannel channel;
            ChannelHandle handle = this.path2data.get(path);
            if (handle == null || !((channel = handle.getChannel()) instanceof MutableAgentChannel)) continue;
            ((MutableAgentChannel)channel).set("state", DataProviderState.OFF_LINE);
            handle.update(null);
        }
    }

    @Override
    protected final void updateChannels(AgentInfo agent, Map<String, Map.Entry<AgentChannel, List<String>>> channels) {
        channels.forEach((path, e) -> {
            ChannelHandle handle = this.path2data.get(path);
            if (handle != null && handle.getTarget() != null) {
                if (!Objects.equals(handle.getChannel(), e.getKey())) {
                    handle.setChannel((AgentChannel)e.getKey());
                    handle.update(null);
                } else {
                    handle.update((List)e.getValue());
                }
            }
        });
    }

    protected abstract void resetChannels();

    protected ChannelHandle createChannelHandle(String path, AgentChannel channel, Updatable view) {
        return new DefaultChannelHandle(path, channel, view);
    }
}

