package org.lsst.ccs.subsystem.vacuum.ui.jas;

import java.time.Duration;
import org.lsst.ccs.gconsole.base.Console;

/**
 * Class for sending a command and receiving the response.
 * 
 * @author saxton
 */
public class CommandSender {
        
    private final Console console = Console.getConsole();
    private int defTimeout = 5000;

    public Object sendCommand(String dest, String cmnd, Object... args) {
        return sendCommand(defTimeout, dest, null, cmnd, args);
    }

    public Object sendCommand(int timeout, String dest, String cmnd, Object... args) {
        return sendCommand(timeout, dest, null, cmnd, args);
    }

    public Object sendCommand(String dest, String target, String cmnd, Object... args) {
        return sendCommand(defTimeout, dest, target, cmnd, args);
    }

    public Object sendCommand(int timeout, String dest, String target, String cmnd, Object... args) {
        try {
            String cmd = dest + (target == null ? "" : "/" + target) + "/" + cmnd;
            return console.sendCommand(Duration.ofMillis(timeout), cmd, args);
        }
        catch (Exception e) {
            console.getLoggerUI().error("Command error: ", e);
            return null;
        }
    }

    public void setTimeout(int timeout) {
        defTimeout = timeout;
    }

}
