/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.util.tree;

import java.util.Comparator;

public enum Sort implements Comparator<String>
{
    NONE("Original order"),
    ALPHABETIC_LEAVES_LAST("Alphabetic, leaves last"){

        @Override
        public int compare(String path1, String path2) {
            return Sort.alphaCompare(path1, path2, true);
        }
    }
    ,
    ALPHABETIC_LEAVES_FIRST("Alphabetic, leaves first"){

        @Override
        public int compare(String path1, String path2) {
            return Sort.alphaCompare(path1, path2, false);
        }
    }
    ,
    ALPHABETIC("Alphabetic"){

        @Override
        public int compare(String path1, String path2) {
            return path1.compareTo(path2);
        }
    };

    private final String humanReadable;

    private Sort(String humanReadable) {
        this.humanReadable = humanReadable;
    }

    @Override
    public int compare(String path1, String path2) {
        throw new UnsupportedOperationException("Value " + this + " does not provide Comparator.");
    }

    public String toString() {
        return this.humanReadable;
    }

    public static Sort parse(String humanReadable) {
        for (Sort sort : Sort.values()) {
            if (!sort.toString().equals(humanReadable)) continue;
            return sort;
        }
        return null;
    }

    private static int alphaCompare(String path1, String path2, boolean leavesLast) {
        String[] p1 = path1.split("/+");
        String[] p2 = path2.split("/+");
        int out = 0;
        int n = Math.max(p1.length, p2.length);
        for (int i = 0; i < n; ++i) {
            if (i == p1.length) {
                return leavesLast ? 1 : -1;
            }
            if (i == p2.length) {
                return leavesLast ? -1 : 1;
            }
            if (out != 0) {
                return out;
            }
            out = p1[i].compareTo(p2[i]);
        }
        return out;
    }
}

