/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.services.persist;

import java.io.Serializable;
import org.lsst.ccs.gconsole.services.persist.Creator;
import org.lsst.ccs.gconsole.services.persist.Editor;
import org.lsst.ccs.gconsole.services.persist.Savable;

public interface Persistable
extends Savable {
    @Override
    default public void restore(Serializable descriptor) {
        if (descriptor instanceof Descriptor) {
            this.restore((Descriptor)descriptor);
        }
    }

    default public void restore(Descriptor descriptor) {
    }

    @Override
    default public Descriptor save() {
        return this.getDescriptor();
    }

    public Descriptor getDescriptor();

    default public String getCategory() {
        Creator.Descriptor desc;
        Descriptor descriptor = this.getDescriptor();
        if (descriptor == null) {
            return null;
        }
        String cat = descriptor.getCategory();
        if (cat == null && (desc = descriptor.getCreator()) != null) {
            cat = desc.getCategory();
        }
        return cat;
    }

    default public Editor getEditor() {
        return null;
    }

    public static class Descriptor
    implements Serializable {
        private Creator.Descriptor creator;
        private String name;
        private String category;
        private String path;
        private String description;

        public void saveOrigin(Descriptor other) {
            if (other == null) {
                return;
            }
            this.setCreator(other.getCreator());
            this.setName(other.getName());
            this.setCategory(other.getCategory());
            this.setPath(other.getPath());
            this.setDescription(other.getDescription());
        }

        public Creator.Descriptor getCreator() {
            return this.creator;
        }

        public void setCreator(Creator.Descriptor creator) {
            this.creator = creator;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getCategory() {
            return this.category;
        }

        public void setCategory(String category) {
            this.category = category;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }
}

