/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.commandbrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.gconsole.agent.AgentStatusEvent;
import org.lsst.ccs.gconsole.agent.AgentStatusListener;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.gconsole.plugins.commandbrowser.AgentHandle;
import org.lsst.ccs.gconsole.plugins.commandbrowser.AgentPanel;
import org.lsst.ccs.gconsole.plugins.commandbrowser.Browser;
import org.lsst.ccs.gconsole.plugins.commandbrowser.FilterDialog;
import org.lsst.ccs.utilities.logging.Logger;

public final class BrowserFull
implements Browser {
    private final Logger logger = Logger.getLogger((String)"org.lsst.ccs.plugin.jas3.dictionary");
    private JPanel browserPanel;
    private AgentTableModel agentTableModel;
    private JTable agentTable;
    private AgentPanel agentPanel;
    private JLabel filterLabel;
    private final ArrayList<AgentHandle> agents = new ArrayList();
    private final Filter filter = new Filter();
    private Descriptor descriptor = new Descriptor();
    private AgentStatusListener connectionsListener;
    private ChangeListener agentHandleListener;

    @Override
    public JComponent getPanel() {
        if (this.browserPanel == null) {
            this.browserPanel = new JPanel(new BorderLayout());
            this.agentPanel = new AgentPanel();
            this.browserPanel.add((Component)this.agentPanel, "Center");
            JPanel leftPane = new JPanel(new BorderLayout());
            leftPane.setPreferredSize(new Dimension(300, 800));
            this.browserPanel.add((Component)leftPane, "West");
            this.agentTableModel = new AgentTableModel();
            this.agentTable = new JTable(this.agentTableModel);
            this.agentTable.setSelectionMode(0);
            this.agentTable.setFillsViewportHeight(true);
            this.agentTable.setDefaultRenderer(String.class, new AgentNameRenderer());
            this.agentTable.setDefaultRenderer(AgentLock.class, new LockRenderer());
            TableCellRenderer headerRenderer = this.agentTable.getTableHeader().getDefaultRenderer();
            for (int i = 0; i < 3; ++i) {
                TableColumn column = this.agentTable.getColumnModel().getColumn(i);
                int w = headerRenderer.getTableCellRendererComponent(null, (Object)column.getHeaderValue(), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width;
                column.setMinWidth(Math.round((float)w * 1.5f));
                column.setPreferredWidth(i == 0 ? 10 * w : Math.round((float)w * 1.5f));
            }
            this.agentTable.setRowHeight(Math.max(this.agentTable.getRowHeight(), 27));
            TableRowSorter<AgentTableModel> sorter = new TableRowSorter<AgentTableModel>(this.agentTableModel);
            ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
            sortKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
            sortKeys.add(new RowSorter.SortKey(1, SortOrder.ASCENDING));
            sorter.setSortKeys(sortKeys);
            sorter.setRowFilter(this.filter);
            this.agentTable.setRowSorter(sorter);
            this.agentTable.getSelectionModel().addListSelectionListener(e -> {
                if (!e.getValueIsAdjusting()) {
                    AgentHandle agent = this.getSelectedAgent();
                    this.agentPanel.setAgent(agent);
                }
            });
            this.agentTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        int row;
                        Point point = e.getPoint();
                        int column = BrowserFull.this.agentTable.columnAtPoint(point);
                        if (column == 1 && (row = BrowserFull.this.agentTable.convertRowIndexToModel(BrowserFull.this.agentTable.rowAtPoint(point))) >= 0) {
                            AgentHandle agent = (AgentHandle)BrowserFull.this.agents.get(row);
                            AgentLock lock = agent.getLock();
                            if (lock == null) {
                                agent.setLock(true);
                            } else if (lock.getOwnerAgentName().equals(Console.getConsole().getAgentInfo().getName())) {
                                agent.setLock(false);
                            }
                        }
                    }
                }
            });
            JScrollPane agentsView = new JScrollPane(this.agentTable);
            leftPane.add((Component)agentsView, "Center");
            Box filterPanel = Box.createHorizontalBox();
            leftPane.add((Component)filterPanel, "South");
            JButton filterButton = new JButton("Filter...");
            filterButton.addActionListener(e -> FilterDialog.show(this.filter, this.browserPanel));
            filterPanel.add(filterButton);
            filterPanel.add(Box.createRigidArea(Const.HDIM));
            this.filterLabel = new JLabel(this.filter.getDescription());
            filterPanel.add(this.filterLabel);
            this.agentHandleListener = e -> {
                AgentHandle agent = (AgentHandle)e.getSource();
                for (int i = 0; i < this.agents.size(); ++i) {
                    if (!agent.equals(this.agents.get(i))) continue;
                    if (agent.isOnline() || agent.isLockedByMe()) {
                        this.agentTableModel.fireTableRowsUpdated(i, i);
                        continue;
                    }
                    this.agents.remove(i);
                    this.agentTableModel.fireTableRowsDeleted(i, i);
                    agent.shutdown();
                }
            };
            this.restore(this.descriptor);
            this.connectionsListener = new AgentStatusListener(){

                @Override
                public void connect(AgentStatusEvent event) {
                    SwingUtilities.invokeLater(() -> {
                        AgentHandle agent = BrowserFull.this.findAgent(event.getSource().getName());
                        if (agent == null) {
                            agent = new AgentHandle(event.getSource());
                            agent.init();
                            BrowserFull.this.agents.add(agent);
                            BrowserFull.this.agentTableModel.fireTableRowsInserted(BrowserFull.this.agents.size() - 1, BrowserFull.this.agents.size() - 1);
                            agent.addListener(BrowserFull.this.agentHandleListener);
                            if (agent.getName().equals(BrowserFull.this.descriptor.getAgent())) {
                                int i = BrowserFull.this.agentTable.convertRowIndexToView(BrowserFull.this.agents.size() - 1);
                                BrowserFull.this.agentTable.getSelectionModel().setSelectionInterval(i, i);
                            }
                        } else {
                            agent.updateOnline(event.getSource());
                        }
                    });
                }

                @Override
                public void disconnect(AgentStatusEvent event) {
                    String agentName = event.getSource().getName();
                    SwingUtilities.invokeLater(() -> {
                        for (int i = 0; i < BrowserFull.this.agents.size(); ++i) {
                            AgentHandle agent = (AgentHandle)BrowserFull.this.agents.get(i);
                            if (!agent.getName().equals(agentName)) continue;
                            agent.updateOnline(null);
                        }
                    });
                }
            };
            Console.getConsole().getStatusAggregator().addListener(this.connectionsListener, null, Collections.emptyList());
        }
        return this.browserPanel;
    }

    @Override
    public void shutdown() {
        this.agents.forEach(a -> a.shutdown());
        Console.getConsole().getStatusAggregator().removeListener(this.connectionsListener);
        this.browserPanel = null;
    }

    @Override
    public String getName() {
        return this.descriptor.getName();
    }

    @Override
    public void restore(Serializable descriptor) {
        if (descriptor instanceof Descriptor) {
            this.descriptor = (Descriptor)descriptor;
            this.filter.restore();
            if (this.browserPanel != null) {
                String selectedAgentName = this.descriptor.getAgent();
                if (selectedAgentName == null) {
                    this.agentTable.getSelectionModel().clearSelection();
                } else {
                    for (int i = this.agents.size() - 1; i >= 0; --i) {
                        if (!selectedAgentName.equals(this.agents.get(i).getName())) continue;
                        i = this.agentTable.convertColumnIndexToView(i);
                        this.agentTable.getSelectionModel().setSelectionInterval(i, i);
                        break;
                    }
                }
                AgentPanel.Descriptor apDesc = this.descriptor.getAgentPanel();
                if (apDesc != null) {
                    this.agentPanel.restore(apDesc);
                }
            }
        } else {
            this.logger.debug((Object)("Incorrect descriptor type for BrowserFull command browser: " + descriptor));
        }
    }

    @Override
    public Serializable save() {
        if (this.agentPanel == null) {
            this.descriptor.setAgentPanel(null);
        } else {
            this.descriptor.setAgentPanel(this.agentPanel.save());
        }
        return this.descriptor;
    }

    private AgentHandle getSelectedAgent() {
        if (this.agentTable == null) {
            return null;
        }
        int i = this.agentTable.getSelectedRow();
        if (i != -1) {
            i = this.agentTable.convertRowIndexToModel(i);
        }
        return i < 0 ? null : this.agents.get(i);
    }

    private AgentHandle findAgent(String name) {
        for (AgentHandle agent : this.agents) {
            if (!agent.getName().equals(name)) continue;
            return agent;
        }
        return null;
    }

    class Filter
    extends RowFilter<Object, Integer> {
        EnumSet<AgentInfo.AgentType> types;
        ArrayList<String> names;
        ArrayList<String> groups;
        HashMap<String, String> properties;

        Filter() {
        }

        @Override
        public boolean include(RowFilter.Entry<? extends Object, ? extends Integer> entry) {
            String group;
            int i = entry.getIdentifier();
            AgentInfo info = ((AgentHandle)BrowserFull.this.agents.get(i)).getInfo();
            String name = ((AgentHandle)BrowserFull.this.agents.get(i)).getName();
            if (this.types != null && info != null && !this.types.contains(info.getType())) {
                return false;
            }
            if (this.names != null) {
                boolean fail = true;
                for (String string : this.names) {
                    if (!name.contains(string)) continue;
                    fail = false;
                    break;
                }
                if (fail) {
                    return false;
                }
            }
            if (this.groups != null && info != null && !this.groups.contains(group = info.getAgentProperty("agentGroup", ""))) {
                return false;
            }
            if (this.properties != null && info != null) {
                boolean fail = true;
                for (Map.Entry entry2 : this.properties.entrySet()) {
                    String value = info.getAgentProperty((String)entry2.getKey());
                    if (!Objects.equals(value, entry2.getValue()) && (value == null || !"".equals(entry2.getValue()))) continue;
                    fail = false;
                    break;
                }
                if (fail) {
                    return false;
                }
            }
            return true;
        }

        void apply() {
            BrowserFull.this.agentTableModel.fireTableDataChanged();
            BrowserFull.this.filterLabel.setText(this.getDescription());
        }

        void save() {
            if (this.types == null) {
                BrowserFull.this.descriptor.setFilterTypes(null);
            } else {
                String[] tt = new String[this.types.size()];
                int i = 0;
                for (AgentInfo.AgentType type : this.types) {
                    tt[i++] = type.name();
                }
                BrowserFull.this.descriptor.setFilterTypes(tt);
            }
            BrowserFull.this.descriptor.setFilterNames(this.names == null ? null : new ArrayList<String>(this.names));
            BrowserFull.this.descriptor.setFilterGroups(this.groups == null ? null : new ArrayList<String>(this.groups));
            BrowserFull.this.descriptor.setFilterProperties(this.properties == null ? null : new HashMap<String, String>(this.properties));
        }

        void restore() {
            if (BrowserFull.this.descriptor.getFilterTypes() == null) {
                this.types = null;
            } else {
                this.types = EnumSet.noneOf(AgentInfo.AgentType.class);
                for (String s : BrowserFull.this.descriptor.getFilterTypes()) {
                    try {
                        this.types.add(AgentInfo.AgentType.valueOf((String)s));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
            this.names = BrowserFull.this.descriptor.getFilterNames() == null ? null : new ArrayList<String>(BrowserFull.this.descriptor.getFilterNames());
            this.groups = BrowserFull.this.descriptor.getFilterGroups() == null ? null : new ArrayList<String>(BrowserFull.this.descriptor.getFilterGroups());
            this.properties = BrowserFull.this.descriptor.getFilterProperties() == null ? null : new HashMap<String, String>(BrowserFull.this.descriptor.getFilterProperties());
        }

        String getDescription() {
            if (this.types == null) {
                if (this.names == null && this.groups == null && this.properties == null) {
                    return "All";
                }
            } else if (this.names == null && this.groups == null && this.properties == null && this.types.size() < 3) {
                return String.join((CharSequence)" & ", this.types.stream().map(t -> t.displayName()).collect(Collectors.toList()));
            }
            return "Custom";
        }
    }

    private static class LockRenderer
    extends DefaultTableCellRenderer {
        private final String consoleName = Console.getConsole().getName();

        private LockRenderer() {
        }

        @Override
        protected void setValue(Object value) {
            super.setValue(value);
            this.setText("");
            if (value == null) {
                this.setIcon(Browser.ICON_UNLOCKED);
                this.setToolTipText("double-click to lock");
            } else {
                AgentLock lock = (AgentLock)value;
                if (lock.getOwnerAgentName().equals(this.consoleName)) {
                    this.setIcon(Browser.ICON_LOCKED);
                    this.setToolTipText("double-click to unlock");
                } else {
                    this.setIcon(Browser.ICON_UNAVAILABLE);
                    this.setToolTipText("locked by: " + lock.getOwnerAgentName());
                }
            }
        }
    }

    private class AgentNameRenderer
    extends DefaultTableCellRenderer {
        private AgentNameRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setToolTipText(value.toString());
            AgentHandle agent = (AgentHandle)BrowserFull.this.agents.get(table.convertRowIndexToModel(row));
            this.setEnabled(agent.isOnline());
            return this;
        }
    }

    private class AgentTableModel
    extends AbstractTableModel {
        private AgentTableModel() {
        }

        @Override
        public int getRowCount() {
            return BrowserFull.this.agents.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            AgentHandle a = (AgentHandle)BrowserFull.this.agents.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return a.getName();
                }
                case 1: {
                    return a.getLock();
                }
                case 2: {
                    return a.getLevel();
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 2 && !((AgentHandle)BrowserFull.this.agents.get(rowIndex)).isAdjusting();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return AgentLock.class;
                }
                case 2: {
                    return Integer.class;
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Subsystem";
                }
                case 1: {
                    return "Lock";
                }
                case 2: {
                    return "Level";
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 2) {
                try {
                    int level = Integer.parseInt(aValue.toString());
                    BrowserFull.this.getSelectedAgent().setLevel(level);
                }
                catch (NullPointerException | NumberFormatException runtimeException) {
                    // empty catch block
                }
            }
        }
    }

    public static class Descriptor
    extends Browser.Descriptor {
        private String[] filterTypes;
        private ArrayList<String> filterNames;
        private ArrayList<String> filterGroups;
        private HashMap<String, String> filterProperties;

        public String[] getFilterTypes() {
            return this.filterTypes;
        }

        public void setFilterTypes(String[] filterTypes) {
            this.filterTypes = filterTypes;
        }

        public ArrayList<String> getFilterNames() {
            return this.filterNames;
        }

        public void setFilterNames(ArrayList<String> filterNames) {
            this.filterNames = filterNames;
        }

        public ArrayList<String> getFilterGroups() {
            return this.filterGroups;
        }

        public void setFilterGroups(ArrayList<String> filterGroups) {
            this.filterGroups = filterGroups;
        }

        public HashMap<String, String> getFilterProperties() {
            return this.filterProperties;
        }

        public void setFilterProperties(HashMap<String, String> filterProperties) {
            this.filterProperties = filterProperties;
        }
    }
}

