/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.monitor.ui;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;
import org.lsst.ccs.subsystem.monitor.data.MonitorChan;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;
import org.lsst.ccs.subsystem.monitor.data.MonitorState;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;
import org.lsst.ccs.subsystem.monitor.ui.MonitorTrendingView;
import org.lsst.ccs.subsystem.monitor.ui.tree.Channel;
import org.lsst.ccs.subsystem.monitor.ui.tree.DataTree;
import org.lsst.ccs.subsystem.monitor.ui.tree.Field;
import org.lsst.ccs.subsystem.monitor.ui.tree.MonitorDisplay;

public class MonitorTrendingTree
extends JPanel
implements MonitorTrendingView {
    private final CommandSender sender;
    private final AgentChannelsFilter filter;
    private final Map<String, SubsysDesc> subsysMap = new HashMap<String, SubsysDesc>();
    private final LinkedHashMap<String, Channel> data = new LinkedHashMap();
    private final LinkedHashMap<String, DataTree> displayPath2view = new LinkedHashMap();

    public MonitorTrendingTree(CommandSender sender, AgentChannelsFilter filter) {
        this.sender = sender;
        this.filter = filter == null ? AgentChannelsFilter.ALL : filter;
        List<String> subsystems = this.filter.getAgents();
        if (subsystems != null) {
            for (String sName : subsystems) {
                SubsysDesc sDesc = new SubsysDesc(sName);
                this.subsysMap.put(sName, sDesc);
            }
        }
        this.add(new EmptyPanel());
    }

    @Override
    public void setSubsystems(String ... sNames) {
        if (this.subsysMap.isEmpty()) {
            for (String sName : sNames) {
                SubsysDesc sDesc = new SubsysDesc(sName);
                this.subsysMap.put(sName, sDesc);
            }
        } else {
            HashSet<String> subs = new HashSet<String>(Arrays.asList(sNames));
            Iterator<Map.Entry<String, SubsysDesc>> it = this.subsysMap.entrySet().iterator();
            while (it.hasNext()) {
                String sName = it.next().getKey();
                if (subs.contains(sName)) continue;
                it.remove();
            }
        }
    }

    @Override
    public void updateTableModel(String sName, MonitorFullState status) {
        SubsysDesc sDesc = this.subsysMap.get(sName);
        if (sDesc == null) {
            return;
        }
        SwingUtilities.invokeLater(new UpdateTableModel(sDesc, status));
    }

    @Override
    public void updateTableValue(String sName, String cName, double value) {
        Target target = this.makeTarget(sName, cName);
        if (target == null) {
            return;
        }
        SwingUtilities.invokeLater(new UpdateTableValue(target, value));
    }

    @Override
    public void updateTableLimit(String sName, String cName, String limName, String value) {
        Target target = this.makeTarget(sName, cName);
        if (target == null) {
            return;
        }
        try {
            double limitValue = Double.parseDouble(value);
            Field field = limName.equals("alarmHigh") ? Field.HIGH : Field.LOW;
            SwingUtilities.invokeLater(new UpdateLimitValue(target, field, limitValue));
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public void updateTableState(String sName, MonitorState status) {
        SubsysDesc sDesc = this.subsysMap.get(sName);
        if (sDesc == null) {
            return;
        }
        SwingUtilities.invokeLater(new UpdateState(sDesc, status));
    }

    @Override
    public void disableSystem(String sName) {
        SubsysDesc sDesc = this.subsysMap.get(sName);
        if (sDesc == null) {
            return;
        }
        SwingUtilities.invokeLater(new DisableSystem(sDesc));
    }

    private Target makeTarget(String sName, String cName) {
        SubsysDesc sDesc = this.subsysMap.get(sName);
        if (sDesc == null) {
            return null;
        }
        Channel channel = sDesc.name2channel.get(cName);
        if (channel == null) {
            return null;
        }
        List<String> displayPaths = this.filter.getDisplayPath(channel.getPath());
        if (displayPaths.isEmpty()) {
            return null;
        }
        return new Target(sDesc, channel, displayPaths);
    }

    static class EmptyPanel
    extends JPanel
    implements MonitorDisplay {
        EmptyPanel() {
        }

        @Override
        public void saveData(OutputStream out, String mimeType) {
        }
    }

    static class DisplayPath {
        final String page;
        final String node;

        DisplayPath(String displayPath, String page) {
            String[] ss = displayPath.split("//");
            if (ss.length == 1) {
                this.page = page == null ? "Monitor" : page;
                this.node = displayPath;
            } else {
                this.page = ss[0];
                this.node = ss[1];
            }
        }
    }

    static class Target {
        final SubsysDesc sDesc;
        final Channel channel;
        final List<String> displayPaths;

        Target(SubsysDesc sDesc, Channel channel, List<String> displayPaths) {
            this.sDesc = sDesc;
            this.channel = channel;
            this.displayPaths = displayPaths;
        }
    }

    static class SubsysDesc {
        final String name;
        boolean enabled;
        final List<Channel> channels = new ArrayList<Channel>();
        final BitSet goodChans = new BitSet();
        final BitSet onlineChans = new BitSet();
        final BitSet lowLimitChange = new BitSet();
        final BitSet highLimitChange = new BitSet();
        final HashMap<String, Channel> name2channel = new HashMap();

        SubsysDesc(String name) {
            this.name = name;
        }
    }

    class DisableSystem
    implements Runnable {
        final SubsysDesc sDesc;

        DisableSystem(SubsysDesc sDesc) {
            this.sDesc = sDesc;
        }

        @Override
        public void run() {
            this.sDesc.enabled = false;
            for (Channel chan : this.sDesc.channels) {
                for (String dp : MonitorTrendingTree.this.filter.getDisplayPath(chan.getPath())) {
                    DataTree view = (DataTree)MonitorTrendingTree.this.displayPath2view.get(dp);
                    if (view == null) continue;
                    view.update(dp, Field.VALUE);
                }
            }
        }
    }

    class UpdateState
    implements Runnable {
        SubsysDesc sDesc;
        MonitorState s;

        UpdateState(SubsysDesc sDesc, MonitorState s) {
            this.sDesc = sDesc;
            this.s = s;
        }

        @Override
        public void run() {
            BitSet updateValue = (BitSet)this.s.getGoodChans().clone();
            updateValue.xor(this.sDesc.goodChans);
            this.sDesc.goodChans.xor(updateValue);
            BitSet updateOnline = (BitSet)this.s.getOnlineChans().clone();
            updateOnline.xor(this.sDesc.onlineChans);
            this.sDesc.onlineChans.xor(updateOnline);
            if (!this.sDesc.channels.isEmpty()) {
                updateValue.or(updateOnline);
                int i = updateValue.nextSetBit(0);
                while (i >= 0) {
                    Channel channel;
                    if (i < this.sDesc.channels.size() && (channel = this.sDesc.channels.get(i)) != null) {
                        channel.setGood(this.sDesc.goodChans.get(i));
                        channel.setOnline(this.sDesc.onlineChans.get(i));
                        for (String string : MonitorTrendingTree.this.filter.getDisplayPath(channel.getPath())) {
                            DataTree view = (DataTree)MonitorTrendingTree.this.displayPath2view.get(string);
                            if (view == null) continue;
                            view.update(string, Field.VALUE);
                        }
                    }
                    i = updateValue.nextSetBit(i + 1);
                }
            }
            BitSet updateHigh = (BitSet)this.s.getHighLimitChange().clone();
            updateHigh.xor(this.sDesc.highLimitChange);
            this.sDesc.highLimitChange.xor(updateHigh);
            int i = updateHigh.nextSetBit(0);
            while (i >= 0) {
                Channel channel;
                if (i < this.sDesc.channels.size() && (channel = this.sDesc.channels.get(i)) != null) {
                    channel.setHighLimitChanged(this.sDesc.highLimitChange.get(i));
                    for (String dp : MonitorTrendingTree.this.filter.getDisplayPath(channel.getPath())) {
                        DataTree view = (DataTree)MonitorTrendingTree.this.displayPath2view.get(dp);
                        if (view == null) continue;
                        view.update(dp, Field.HIGH);
                    }
                }
                i = updateHigh.nextSetBit(i + 1);
            }
            BitSet updateLow = (BitSet)this.s.getLowLimitChange().clone();
            updateLow.xor(this.sDesc.lowLimitChange);
            this.sDesc.lowLimitChange.xor(updateLow);
            int i2 = updateLow.nextSetBit(0);
            while (i2 >= 0) {
                Channel channel;
                if (i2 < this.sDesc.channels.size() && (channel = this.sDesc.channels.get(i2)) != null) {
                    channel.setLowLimitChanged(this.sDesc.lowLimitChange.get(i2));
                    for (String dp : MonitorTrendingTree.this.filter.getDisplayPath(channel.getPath())) {
                        DataTree view = (DataTree)MonitorTrendingTree.this.displayPath2view.get(dp);
                        if (view == null) continue;
                        view.update(dp, Field.LOW);
                    }
                }
                i2 = updateLow.nextSetBit(i2 + 1);
            }
        }
    }

    class UpdateLimitValue
    implements Runnable {
        final Target target;
        final Field field;
        final double value;

        UpdateLimitValue(Target target, Field field, double value) {
            this.target = target;
            this.field = field;
            this.value = value;
        }

        @Override
        public void run() {
            this.target.channel.set(this.field, this.value);
            for (String dp : this.target.displayPaths) {
                DataTree view = (DataTree)MonitorTrendingTree.this.displayPath2view.get(dp);
                if (view == null) continue;
                view.update(dp, this.field);
            }
        }
    }

    class UpdateTableValue
    implements Runnable {
        Target target;
        double value;

        UpdateTableValue(Target target, double value) {
            this.target = target;
            this.value = value;
        }

        @Override
        public void run() {
            this.target.channel.setValue(this.value);
            for (String dp : this.target.displayPaths) {
                DataTree view = (DataTree)MonitorTrendingTree.this.displayPath2view.get(dp);
                if (view == null) continue;
                view.update(dp);
            }
        }
    }

    class UpdateTableModel
    implements Runnable {
        final SubsysDesc sDesc;
        final MonitorFullState s;

        UpdateTableModel(SubsysDesc sDesc, MonitorFullState s) {
            this.sDesc = sDesc;
            this.s = s;
        }

        @Override
        public void run() {
            this.sDesc.enabled = true;
            this.sDesc.channels.clear();
            this.sDesc.goodChans.clear();
            this.sDesc.onlineChans.clear();
            this.sDesc.lowLimitChange.clear();
            this.sDesc.highLimitChange.clear();
            this.sDesc.name2channel.clear();
            MonitorState state = this.s.getMonitorState();
            this.sDesc.goodChans.or(state.getGoodChans());
            this.sDesc.onlineChans.or(state.getOnlineChans());
            this.sDesc.lowLimitChange.or(state.getLowLimitChange());
            this.sDesc.highLimitChange.or(state.getHighLimitChange());
            List<String> originChannels = MonitorTrendingTree.this.filter.getOriginChannels();
            List<String> displayChannels = MonitorTrendingTree.this.filter.getDisplayChannels();
            int i = 0;
            for (Object mc : this.s.getChannels()) {
                Channel chan = new Channel(this.sDesc.name, (MonitorChan)mc);
                chan.setOnline(this.sDesc.onlineChans.get(i));
                chan.setGood(this.sDesc.goodChans.get(i));
                chan.setLowLimitChanged(this.sDesc.lowLimitChange.get(i));
                chan.setHighLimitChanged(this.sDesc.highLimitChange.get(i++));
                String originPath = chan.getPath();
                if (originChannels == null || originChannels.contains(originPath)) {
                    List<String> list = MonitorTrendingTree.this.filter.getDisplayPath(originPath);
                    boolean needed = false;
                    for (String dp : list) {
                        if (displayChannels != null && !displayChannels.contains(dp)) continue;
                        needed = true;
                    }
                    this.sDesc.channels.add(needed ? chan : null);
                    continue;
                }
                this.sDesc.channels.add(null);
            }
            Iterator it = MonitorTrendingTree.this.data.entrySet().iterator();
            while (it.hasNext()) {
                if (!((Channel)((Object)it.next().getValue())).getSubsystemName().equals(this.sDesc.name)) continue;
                it.remove();
            }
            for (Object c : this.sDesc.channels) {
                if (c == null) continue;
                this.sDesc.name2channel.put(c.getName(), (Channel)((Object)c));
                MonitorTrendingTree.this.data.put(c.getPath(), c);
            }
            HashMap<String, ArrayList<String>> page2channels = new HashMap<String, ArrayList<String>>();
            for (Object sub : MonitorTrendingTree.this.subsysMap.values()) {
                for (Channel c : ((SubsysDesc)sub).channels) {
                    if (c == null) continue;
                    for (String displayPath : MonitorTrendingTree.this.filter.getDisplayPath(c.getPath())) {
                        if (displayChannels != null && !displayChannels.contains(displayPath)) continue;
                        String page = (String)this.s.getPages().get(c.getPage());
                        DisplayPath dp = new DisplayPath(displayPath, page);
                        ArrayList<String> channels = (ArrayList<String>)page2channels.get(dp.page);
                        if (channels == null) {
                            channels = new ArrayList<String>();
                            page2channels.put(dp.page, channels);
                        }
                        channels.add(displayPath);
                    }
                }
            }
            MonitorTrendingTree.this.displayPath2view.clear();
            ArrayList<DataTree> views = new ArrayList<DataTree>();
            for (Map.Entry entry : page2channels.entrySet()) {
                DataTree view = new DataTree(MonitorTrendingTree.this.sender);
                views.add(view);
                view.setName((String)entry.getKey());
                LinkedHashMap<String, Channel> cc = new LinkedHashMap<String, Channel>();
                for (String dp : (List)entry.getValue()) {
                    MonitorTrendingTree.this.displayPath2view.put(dp, view);
                    String originChannel = MonitorTrendingTree.this.filter.getOriginPath(dp);
                    cc.put(dp, (Channel)((Object)MonitorTrendingTree.this.data.get(originChannel)));
                }
                view.setChannels(cc);
            }
            MonitorTrendingTree.this.removeAll();
            MonitorTrendingTree.this.setLayout(new BoxLayout(MonitorTrendingTree.this, 2));
            if (views.size() == 1) {
                MonitorTrendingTree.this.add(new JScrollPane(((DataTree)views.get(0)).getView()));
            } else if (views.size() > 1) {
                JTabbedPane tabs = new JTabbedPane();
                for (DataTree view : views) {
                    tabs.add(view.getName(), new JScrollPane(view.getView()));
                }
                MonitorTrendingTree.this.add(tabs);
            }
            MonitorTrendingTree.this.validate();
        }
    }
}

