/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.vacuum.ui.jas;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.gconsole.plugins.monitor.SectionedTableView;
import org.lsst.ccs.gconsole.plugins.monitor.TabbedView;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.vacuum.data.VacuumState;
import org.lsst.ccs.subsystem.vacuum.ui.VacControlPanel;
import org.lsst.ccs.subsystem.vacuum.ui.VacuumPage;
import org.lsst.ccs.subsystem.vacuum.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.vacuum.ui.jas.VacControlFilter;

@Plugin(name="Vacuum Control Plugin", description="Vacuum Control Plugin")
public class VacControlPlugin
extends ConsolePlugin {
    public void initialize() {
        OptionalPage.getService().add((OptionalPage)new VacImageOptionalPage());
        OptionalPage.getService().add((OptionalPage)new VacControlOptionalPage());
    }

    static class BusListener
    implements StatusMessageListener {
        private final VacControlPanel controls;
        private final String agentName;

        BusListener(VacControlPanel controls, String agentName) {
            this.controls = controls;
            this.agentName = agentName;
        }

        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals("VacuumState")) {
                    this.controls.updateControlPanel((VacuumState)sd.getSubsystemData().getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException embeddedObjectDeserializationException) {
                // empty catch block
            }
        }
    }

    static class VacImageOptionalPage
    implements OptionalPage {
        private VacuumPage vacuumPage;

        VacImageOptionalPage() {
        }

        public boolean isAutoOpen() {
            return false;
        }

        public String getPage(AgentInfo agent) {
            return agent != null && agent.hasAgentProperty("vacuumType") ? "CCS Subsystems/" + agent.getName() + "/Schematic" : null;
        }

        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            this.vacuumPage = new VacuumPage(agent);
            return this.vacuumPage.getView().getPanel();
        }

        public void opened(String page) {
            this.vacuumPage.getView().install();
        }

        public void closed(String page) {
            this.vacuumPage.getView().uninstall();
            this.vacuumPage = null;
        }
    }

    static class VacControlOptionalPage
    implements OptionalPage {
        private final CommandSender cmdSender = new CommandSender();
        private final Map<String, BusListener> busListeners = new ConcurrentHashMap<String, BusListener>();

        VacControlOptionalPage() {
        }

        public boolean isAutoOpen() {
            return false;
        }

        public String getPage(AgentInfo agent) {
            return agent != null && agent.hasAgentProperty("vacuumType") ? this.getPageName(agent) : null;
        }

        public boolean agentDisconnected(AgentInfo agent) {
            BusListener listener = this.busListeners.get(this.getPageName(agent));
            if (listener == null) {
                return true;
            }
            listener.controls.disableSystem();
            return false;
        }

        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            String pageName = this.getPageName(agent);
            String agentName = agent.getName();
            BusListener listener = this.busListeners.get(pageName);
            if (listener != null) {
                this.initControls(agentName, listener.controls);
                return existingComponent;
            }
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            TabbedView view = new TabbedView();
            view.setViewFactory(name -> new SectionedTableView());
            VacControlFilter monitorFilter = new VacControlFilter(agent.getName());
            view.setFilter((AgentChannelsFilter)monitorFilter);
            view.install();
            panel.add((Component)view.getPanel(), "Center");
            VacControlPanel controls = new VacControlPanel(this.cmdSender);
            controls.setSubsystem(agent.getName());
            panel.add((Component)controls, "South");
            listener = new BusListener(controls, agent.getName());
            AgentMessagingLayer aml = Console.getConsole().getMessagingAccess();
            aml.addStatusMessageListener((StatusMessageListener)listener, msg -> msg.getOriginAgentInfo().getName().equals(agentName) && msg instanceof StatusSubsystemData);
            this.busListeners.put(pageName, listener);
            this.initControls(agentName, controls);
            return panel;
        }

        public void closed(String pageName) {
            BusListener listener = this.busListeners.remove(pageName);
            if (listener == null) {
                throw new RuntimeException("No page exists with the name " + pageName);
            }
            Console.getConsole().getMessagingAccess().removeStatusMessageListener((StatusMessageListener)listener);
        }

        private String getPageName(AgentInfo agent) {
            return "CCS Subsystems/" + agent.getName() + "/Control";
        }

        private void initControls(String agentName, VacControlPanel controls) {
            Object response = this.cmdSender.sendCommand(agentName, null, "getVacuumState", new Object[0]);
            if (response instanceof VacuumState) {
                controls.updateControlPanel((VacuumState)response);
            }
        }
    }
}

