/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.vacuum.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import org.lsst.ccs.subsystem.vacuum.constants.ConditionState;
import org.lsst.ccs.subsystem.vacuum.constants.DeviceState;
import org.lsst.ccs.subsystem.vacuum.constants.SwitchEnable;
import org.lsst.ccs.subsystem.vacuum.constants.SwitchState;
import org.lsst.ccs.subsystem.vacuum.data.VacuumState;
import org.lsst.ccs.subsystem.vacuum.ui.jas.CommandSender;

public class VacControlPanel
extends JPanel {
    static final Font FONT = new Font("Tahoma", 1, 12);
    static final Color RED = new Color(175, 0, 0);
    static final Color GREEN = new Color(0, 175, 0);
    static final Color BLUE = new Color(0, 75, 175);
    static final Color PURPLE = new Color(175, 0, 175);
    static final int SWTP_PUMP = 0;
    static final int SWTP_VALVE = 1;
    static final String[] switchNames = new String[17];
    static final int[] switchTypes;
    static final String[] conditionNames;
    private final CommandSender sender;
    private String subsys;
    private double mainPeriod = 5.0;
    private int switchMask;
    private int conditionMask;
    private final JPanel mainPanel = new JPanel();
    private final JPanel headPanel = new JPanel();
    private final JLabel stateLabel = new JLabel("System State:  ");
    private final JLabel stateStatus = new JLabel("STOPPED");
    private final JPanel periodPanel = new JPanel();
    private final JLabel periodLabel = new JLabel("Update Period: ");
    private final JTextField periodTextField = new JTextField();
    private final JLabel periodUnitsLabel = new JLabel("sec");
    private final JPanel switchPanel = new JPanel();
    private final JLabel[] switchLabel = new JLabel[17];
    private final JLabel[] switchStatus = new JLabel[17];
    private final ButtonGroup[] switchBG = new ButtonGroup[17];
    private final JRadioButton[] switchOffRB = new JRadioButton[17];
    private final JRadioButton[] switchOnRB = new JRadioButton[17];
    private final JPanel conditionPanel = new JPanel();
    private final JLabel[] conditionLabel = new JLabel[8];
    private final JLabel[] conditionStatus = new JLabel[8];
    private final JButton[] conditionResetBtn = new JButton[8];
    private static final long serialVersionUID = 1L;

    public VacControlPanel(CommandSender cons) {
        this.sender = cons;
        this.initComponents();
        new UpdateVacStatus(new VacuumState()).run();
        new DisableSystem().run();
    }

    public void setSubsystem(String name) {
        this.subsys = name;
    }

    private void initComponents() {
        JLabel label;
        this.stateLabel.setFont(FONT);
        this.stateStatus.setFont(FONT);
        Dimension d = this.stateStatus.getPreferredSize();
        d.width = 150;
        this.stateStatus.setMinimumSize(d);
        this.stateStatus.setPreferredSize(d);
        this.periodLabel.setFont(FONT);
        d = this.periodTextField.getPreferredSize();
        d.width = 45;
        this.periodTextField.setMinimumSize(d);
        this.periodTextField.setPreferredSize(d);
        this.periodTextField.setHorizontalAlignment(0);
        this.periodTextField.setText("...");
        this.periodTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VacControlPanel.this.setUpdatePeriod();
            }
        });
        this.periodUnitsLabel.setFont(FONT);
        for (int sw = 0; sw < 17; ++sw) {
            label = this.switchLabel[sw] = new JLabel(switchNames[sw]);
            label.setFont(FONT);
            d = label.getPreferredSize();
            d.width = 130;
            label.setMinimumSize(d);
            label.setPreferredSize(d);
            label = this.switchStatus[sw] = new JLabel("XXX");
            label.setFont(FONT);
            d = label.getPreferredSize();
            d.width = 80;
            label.setMinimumSize(d);
            label.setPreferredSize(d);
            int swType = switchTypes[sw];
            JRadioButton buttonOff = this.switchOffRB[sw] = new JRadioButton(swType == 0 ? "Off" : "Shut");
            buttonOff.setFont(FONT);
            buttonOff.setFocusable(false);
            buttonOff.setName(Integer.toString(sw));
            buttonOff.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String name = ((JRadioButton)evt.getSource()).getName();
                    VacControlPanel.this.setSwitchOn(Integer.valueOf(name), false);
                }
            });
            JRadioButton buttonOn = this.switchOnRB[sw] = new JRadioButton(swType == 0 ? "On" : "Open");
            buttonOn.setFont(FONT);
            buttonOn.setFocusable(false);
            buttonOn.setName(Integer.toString(sw));
            buttonOn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String name = ((JRadioButton)evt.getSource()).getName();
                    VacControlPanel.this.setSwitchOn(Integer.valueOf(name), true);
                }
            });
            ButtonGroup bg = this.switchBG[sw] = new ButtonGroup();
            bg.add(buttonOff);
            bg.add(buttonOn);
        }
        for (int cond = 0; cond < 8; ++cond) {
            label = this.conditionLabel[cond] = new JLabel(conditionNames[cond]);
            label.setFont(FONT);
            d = label.getPreferredSize();
            d.width = 170;
            label.setMinimumSize(d);
            label.setPreferredSize(d);
            label = this.conditionStatus[cond] = new JLabel("XXX");
            label.setFont(FONT);
            d = label.getPreferredSize();
            d.width = 80;
            label.setMinimumSize(d);
            label.setPreferredSize(d);
            JButton button = this.conditionResetBtn[cond] = new JButton("Reset");
            Insets i = button.getMargin();
            i.left -= 3;
            i.right -= 3;
            button.setMargin(i);
            d = button.getPreferredSize();
            d.height -= 9;
            button.setPreferredSize(d);
            button.setFont(FONT);
            button.setFocusable(false);
            button.setName(Integer.toString(cond));
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String name = ((JButton)evt.getSource()).getName();
                    VacControlPanel.this.clearCondition(Integer.valueOf(name));
                }
            });
        }
        this.periodPanel.add(this.periodTextField);
        this.periodPanel.add(this.periodUnitsLabel);
        this.headPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbh = new GridBagConstraints();
        gbh.insets = new Insets(5, 0, 0, 0);
        gbh.gridx = 0;
        gbh.gridy = 0;
        gbh.anchor = 13;
        this.headPanel.add((Component)this.stateLabel, gbh);
        ++gbh.gridx;
        gbh.anchor = 17;
        this.headPanel.add((Component)this.stateStatus, gbh);
        ++gbh.gridx;
        gbh.gridwidth = 2;
        gbh.anchor = 13;
        this.headPanel.add((Component)this.periodLabel, gbh);
        gbh.gridx += 2;
        gbh.gridwidth = 1;
        gbh.anchor = 17;
        this.headPanel.add((Component)this.periodPanel, gbh);
        gbh.gridx = 0;
        TitledBorder border = BorderFactory.createTitledBorder("Switches");
        border.setTitleJustification(2);
        this.switchPanel.setBorder(border);
        this.switchPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbs = new GridBagConstraints();
        gbs.gridx = 0;
        gbs.gridy = 0;
        gbs.insets.bottom = -8;
        this.switchPanel.add((Component)new JLabel(" "), gbs);
        border = BorderFactory.createTitledBorder("PLC Error Conditions");
        border.setTitleJustification(2);
        this.conditionPanel.setBorder(border);
        this.conditionPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets.bottom = -8;
        this.conditionPanel.add((Component)new JLabel(" "), gbc);
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.insets = new Insets(0, 0, 0, 0);
        gbm.anchor = 11;
        gbm.gridx = 0;
        gbm.gridy = 0;
        this.mainPanel.add((Component)this.headPanel, gbm);
        ++gbm.gridy;
        this.mainPanel.add((Component)this.switchPanel, gbm);
        ++gbm.gridy;
        gbm.insets.top = 6;
        this.mainPanel.add((Component)this.conditionPanel, gbm);
        this.add(this.mainPanel);
    }

    private void updateSwitchLayout(int switches) {
        for (int sw = 0; sw < 17; ++sw) {
            if ((this.switchMask & 1 << sw) == 0) continue;
            this.switchPanel.remove(this.switchLabel[sw]);
            this.switchPanel.remove(this.switchStatus[sw]);
            this.switchPanel.remove(this.switchOffRB[sw]);
            this.switchPanel.remove(this.switchOnRB[sw]);
        }
        GridBagConstraints gbs = new GridBagConstraints();
        gbs.anchor = 18;
        gbs.gridy = 0;
        int colm = 0;
        for (int sw = 0; sw < 17; ++sw) {
            if ((switches & 1 << sw) == 0) continue;
            if (colm == 0) {
                gbs.gridx = 0;
                ++gbs.gridy;
            }
            gbs.insets.top = 0;
            gbs.insets.left = colm == 0 ? 4 : 50;
            this.switchPanel.add((Component)this.switchLabel[sw], gbs);
            gbs.insets.left = 0;
            ++gbs.gridx;
            this.switchPanel.add((Component)this.switchStatus[sw], gbs);
            ++gbs.gridx;
            gbs.insets.top = -4;
            this.switchPanel.add((Component)this.switchOffRB[sw], gbs);
            ++gbs.gridx;
            gbs.insets.left = 6;
            gbs.insets.right = 3;
            this.switchPanel.add((Component)this.switchOnRB[sw], gbs);
            gbs.insets.right = 0;
            ++gbs.gridx;
            colm = (colm + 1) % 2;
        }
        this.switchMask = switches;
    }

    private void updateConditionLayout(int conditions) {
        for (int cond = 0; cond < 8; ++cond) {
            if ((this.conditionMask & 1 << cond) == 0) continue;
            this.conditionPanel.remove(this.conditionLabel[cond]);
            this.conditionPanel.remove(this.conditionStatus[cond]);
            this.conditionPanel.remove(this.conditionResetBtn[cond]);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridy = 0;
        int colm = 0;
        for (int cond = 0; cond < 8; ++cond) {
            if ((conditions & 1 << cond) == 0) continue;
            if (colm == 0) {
                gbc.gridx = 0;
                ++gbc.gridy;
            }
            gbc.insets.top = 0;
            gbc.insets.bottom = 4;
            gbc.insets.left = colm == 0 ? 3 : 50;
            this.conditionPanel.add((Component)this.conditionLabel[cond], gbc);
            gbc.insets.left = 0;
            ++gbc.gridx;
            this.conditionPanel.add((Component)this.conditionStatus[cond], gbc);
            ++gbc.gridx;
            gbc.insets.top = -1;
            gbc.insets.right = 4;
            this.conditionPanel.add((Component)this.conditionResetBtn[cond], gbc);
            gbc.insets.right = 0;
            ++gbc.gridx;
            colm = (colm + 1) % 2;
        }
        this.conditionMask = conditions;
    }

    private void setUpdatePeriod() {
        try {
            double value = Double.valueOf(this.periodTextField.getText());
            this.sender.sendCommand(this.subsys, "setUpdatePeriod", (int)(1000.0 * value));
            this.periodTextField.setEnabled(false);
        }
        catch (NumberFormatException nfe) {
            this.periodTextField.setText(String.valueOf(this.mainPeriod));
        }
    }

    private void setSwitchOn(int sw, boolean value) {
        this.switchOffRB[sw].setEnabled(false);
        this.switchOnRB[sw].setEnabled(false);
        this.sender.sendCommand(this.subsys, "setSwitchOn", sw, value);
    }

    private void clearCondition(int cond) {
        this.conditionResetBtn[cond].setEnabled(false);
        this.sender.sendCommand(this.subsys, "clearCondition", cond);
    }

    public void updateControlPanel(VacuumState rs) {
        SwingUtilities.invokeLater(new UpdateVacStatus(rs));
    }

    public void disableSystem() {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    static {
        VacControlPanel.switchNames[0] = "Cryo Turbo Pump";
        VacControlPanel.switchNames[1] = "Cryo Ion Pump 1";
        VacControlPanel.switchNames[2] = "Cryo Ion Pump 2";
        VacControlPanel.switchNames[3] = "Cryo Ion Pump 3";
        VacControlPanel.switchNames[4] = "Cryo Ion Pump 4";
        VacControlPanel.switchNames[5] = "Cryo Ion Pump 5";
        VacControlPanel.switchNames[6] = "Cryo Ion Pump 6";
        VacControlPanel.switchNames[7] = "Cryo Gate Valve";
        VacControlPanel.switchNames[8] = "Hx Turbo Pump";
        VacControlPanel.switchNames[9] = "Hx Ion Pump 1";
        VacControlPanel.switchNames[10] = "Hx Ion Pump 2";
        VacControlPanel.switchNames[11] = "Hx Gate Valve";
        VacControlPanel.switchNames[12] = "O-ring Ion Pump";
        VacControlPanel.switchNames[13] = "O-ring Fpp Valve";
        VacControlPanel.switchNames[14] = "O-ring Fh Valve";
        VacControlPanel.switchNames[15] = "O-ring L3h Valve";
        VacControlPanel.switchNames[16] = "O-ring L3 Valve";
        switchTypes = new int[17];
        VacControlPanel.switchTypes[0] = 0;
        VacControlPanel.switchTypes[1] = 0;
        VacControlPanel.switchTypes[2] = 0;
        VacControlPanel.switchTypes[3] = 0;
        VacControlPanel.switchTypes[4] = 0;
        VacControlPanel.switchTypes[5] = 0;
        VacControlPanel.switchTypes[6] = 0;
        VacControlPanel.switchTypes[7] = 1;
        VacControlPanel.switchTypes[8] = 0;
        VacControlPanel.switchTypes[9] = 0;
        VacControlPanel.switchTypes[10] = 0;
        VacControlPanel.switchTypes[11] = 1;
        VacControlPanel.switchTypes[12] = 0;
        VacControlPanel.switchTypes[13] = 1;
        VacControlPanel.switchTypes[14] = 1;
        VacControlPanel.switchTypes[15] = 1;
        VacControlPanel.switchTypes[16] = 1;
        conditionNames = new String[8];
        VacControlPanel.conditionNames[2] = "Cryo Gate Can't Open";
        VacControlPanel.conditionNames[1] = "Cryo Gate Forced Shut";
        VacControlPanel.conditionNames[0] = "Cryo Vacuum Bad";
        VacControlPanel.conditionNames[3] = "Cryo Turbo Pump Bad";
        VacControlPanel.conditionNames[6] = "Hx Gate Can't Open";
        VacControlPanel.conditionNames[5] = "Hx Gate Forced Shut";
        VacControlPanel.conditionNames[4] = "Hx Vacuum Bad";
        VacControlPanel.conditionNames[7] = "Hx Turbo Pump Bad";
    }

    class DisableSystem
    implements Runnable {
        DisableSystem() {
        }

        @Override
        public void run() {
            VacControlPanel.this.stateStatus.setText("STOPPED");
            VacControlPanel.this.stateStatus.setForeground(RED);
            VacControlPanel.this.periodTextField.setEnabled(false);
            for (int sw = 0; sw < 17; ++sw) {
                VacControlPanel.this.switchStatus[sw].setEnabled(false);
                VacControlPanel.this.switchOffRB[sw].setEnabled(false);
                VacControlPanel.this.switchOnRB[sw].setEnabled(false);
            }
            for (int cond = 0; cond < 8; ++cond) {
                VacControlPanel.this.conditionStatus[cond].setEnabled(false);
                VacControlPanel.this.conditionResetBtn[cond].setEnabled(false);
            }
        }
    }

    class UpdateVacStatus
    implements Runnable {
        private final VacuumState vs;

        UpdateVacStatus(VacuumState vs) {
            this.vs = vs;
        }

        @Override
        public void run() {
            VacControlPanel.this.stateStatus.setText("RUNNING");
            VacControlPanel.this.stateStatus.setForeground(GREEN);
            VacControlPanel.this.periodTextField.setEnabled(true);
            VacControlPanel.this.mainPeriod = (double)this.vs.getTickMillis() / 1000.0;
            VacControlPanel.this.periodTextField.setText(String.valueOf(VacControlPanel.this.mainPeriod));
            int switches = 0;
            for (int sw = 0; sw < 17; ++sw) {
                Color color;
                String text;
                if (!this.vs.hasSwitch(sw)) continue;
                switches |= 1 << sw;
                SwitchState state = this.vs.getSwitchState(sw);
                SwitchEnable enable = this.vs.getSwitchEnable(sw);
                if (enable == SwitchEnable.OFF || enable == SwitchEnable.WAS_OFF) {
                    text = "DISABLD";
                    color = RED;
                } else {
                    text = state.name();
                    if (switchTypes[sw] == 1) {
                        String string = state == SwitchState.OFF ? "SHUT" : (text = state == SwitchState.ON ? "OPEN" : text);
                    }
                    color = state == SwitchState.OFF ? Color.black : (state == SwitchState.ON ? GREEN : BLUE);
                    DeviceState devState = this.vs.getDeviceState(sw);
                    if (devState != null && state != SwitchState.OFFLINE) {
                        text = devState.name();
                        if (devState == DeviceState.FAILED) {
                            color = RED;
                        }
                    }
                }
                VacControlPanel.this.switchStatus[sw].setText(text);
                VacControlPanel.this.switchStatus[sw].setForeground(color);
                JRadioButton selButton = state == SwitchState.ON ? VacControlPanel.this.switchOnRB[sw] : VacControlPanel.this.switchOffRB[sw];
                selButton.setSelected(true);
                VacControlPanel.this.switchStatus[sw].setEnabled(true);
                VacControlPanel.this.switchOffRB[sw].setEnabled(true);
                VacControlPanel.this.switchOnRB[sw].setEnabled(true);
            }
            if (switches != VacControlPanel.this.switchMask) {
                VacControlPanel.this.updateSwitchLayout(switches);
            }
            int conditions = 0;
            for (int cond = 0; cond < 8; ++cond) {
                if (!this.vs.hasCondition(cond)) continue;
                conditions |= 1 << cond;
                ConditionState state = this.vs.getCondition(cond);
                String text = state.name();
                Color color = state == ConditionState.OFFLINE ? BLUE : (state == ConditionState.CLEAR ? GREEN : (state == ConditionState.ACTIVE ? RED : PURPLE));
                VacControlPanel.this.conditionStatus[cond].setText(text);
                VacControlPanel.this.conditionStatus[cond].setForeground(color);
                VacControlPanel.this.conditionStatus[cond].setEnabled(true);
                VacControlPanel.this.conditionResetBtn[cond].setEnabled(true);
            }
            if (conditions != VacControlPanel.this.conditionMask) {
                VacControlPanel.this.updateConditionLayout(conditions);
            }
        }
    }
}

