package org.lsst.ccs.subsystem.vacuum.data;

import java.io.Serializable;
import java.util.Arrays;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.subsystem.vacuum.constants.ConditionState;
import org.lsst.ccs.subsystem.vacuum.constants.Conditions;
import org.lsst.ccs.subsystem.vacuum.constants.DeviceState;
import org.lsst.ccs.subsystem.vacuum.constants.LatchState;
import org.lsst.ccs.subsystem.vacuum.constants.Latches;
import org.lsst.ccs.subsystem.vacuum.constants.PLCState;
import org.lsst.ccs.subsystem.vacuum.constants.SwitchEnable;
import org.lsst.ccs.subsystem.vacuum.constants.SwitchState;
import org.lsst.ccs.subsystem.vacuum.constants.Switches;
import org.lsst.ccs.subsystem.vacuum.constants.CryoVacuumState;
import org.lsst.ccs.subsystem.vacuum.constants.HxVacuumState;

/**
 *  Contains the state of the vacuum subsystem
 *
 *  @author Owen Saxton
 */
@SkipEncoding
public class VacSysState implements Serializable {
    
    public static final String KEY = "VacuumState";

    private int tickMillis;           // Data status update period (ms)
    private CryoVacuumState cryoVacuumState = CryoVacuumState.UNKNOWN;  // The cryo vacuum state
    private HxVacuumState hxVacuumState = HxVacuumState.UNKNOWN;  // The HX vacuum state
    private PLCState plcState = PLCState.ALIVE;  // The PLC state
    private final SwitchState[] switchState = new SwitchState[Switches.NUM_SWITCHES];  // Switch state array
    private final SwitchEnable[] switchEnable = new SwitchEnable[Switches.NUM_SWITCHES];  // Switch enable array
    private final DeviceState[] deviceState = new DeviceState[Switches.NUM_SWITCHES];  // Extra device state array
    private final LatchState[] latchState = new LatchState[Latches.NUM_LATCHES];  // Latched PLC conditions array
    private final ConditionState[] conditionState = new ConditionState[Conditions.NUM_CONDITIONS];  // PLC conditions array

    public VacSysState() {
        Arrays.fill(switchState, SwitchState.OFFLINE);
        Arrays.fill(switchEnable, SwitchEnable.OFF);
        Arrays.fill(latchState, LatchState.CLEAR);
        Arrays.fill(conditionState, ConditionState.NO);
    }

    public void setTickMillis(int value) {
        tickMillis = value;
    }

    public int getTickMillis() {
        return tickMillis;
    }

    public void setCryoVacuumState(CryoVacuumState value) {
        cryoVacuumState = value;
    }

    public CryoVacuumState getCryoVacuumState() {
        return cryoVacuumState;
    }

    public void setHxVacuumState(HxVacuumState value) {
        hxVacuumState = value;
    }

    public HxVacuumState getHxVacuumState() {
        return hxVacuumState;
    }

    public void setPlcState(PLCState value) {
        plcState = value;
    }

    public PLCState getPlcState() {
        return plcState;
    }

    public void setSwitchState(int sw, SwitchState state) {
        switchState[sw] = state;
    }

    public SwitchState getSwitchState(int sw) {
        return switchState[sw];
    }

    public void setSwitchEnable(int sw, SwitchEnable enable) {
        switchEnable[sw] = enable;
    }

    public SwitchEnable getSwitchEnable(int sw) {
        return switchEnable[sw];
    }

    public void setDeviceState(int sw, DeviceState state) {
        deviceState[sw] = state;
    }

    public DeviceState getDeviceState(int sw) {
        return deviceState[sw];
    }

    public void setLatch(int latch, LatchState state) {
        latchState[latch] = state;
    }

    public LatchState getLatch(int latch) {
        return latchState[latch];
    }

    public void setCondition(int cond, ConditionState state) {
        conditionState[cond] = state;
    }

    public ConditionState getCondition(int cond) {
        return conditionState[cond];
    }

    private static final long serialVersionUID = -2669272698864689859L;
}
