package org.lsst.ccs.subsystem.vacuum.constants;

import org.lsst.ccs.bus.data.Alert;

/**
 * Vacuum Alerts.
 * 
 * @author The LSST CCS Team
 */
public enum VacuumAlert {

    /**
     * Vacuum PLC is unresponsive or has error conditions
     */
    VACUUM_PLC_NOT_ALIVE("VacuumPLCNotAlive", "Vacuum PLC not alive"),
    CRYO_VACUUM_BAD("CryoVacuumBad", "Cryo Vacuum Bad"),
    CRYO_GATE_FORCED_SHUT("CryoGateForcedShut", "Cryo Gate Valve Forced Shut"),
    CRYO_GATE_CANNOT_OPEN("CryoGateCannotOpen", "Cryo Gate Valve Cannot Open"),
    CRYO_TURBO_PUMP_BAD("CryoTurboPumpBad", "Cryo Turbo Pump Bad"),
    CRYO_VAC_CC_STOPPED("CryoVacColdCathodeStopped", "Cryo Vac Gauge Cold Cathode Stopped by CCS"),
    CRYO_TURBO_CC_STOPPED("CryoTurboColdCathodeStopped", "Cryo Turbo Gauge Cold Cathode Stopped by CCS"),
    HX_VACUUM_BAD("HxVacuumBad", "HX Vacuum Bad"),
    HX_GATE_FORCED_SHUT("HxGateForcedShut", "HX Gate Valve Forced Shut"),
    HX_GATE_CANNOT_OPEN("HxGateCannotOpen", "HX Gate Valve Cannot Open"),
    HX_TURBO_PUMP_BAD("HxTurboPumpBad", "HX Turbo Pump Bad"),
    HX_VAC_CC_STOPPED("HxVacColdCathodeStopped", "HX Vac Gauge Cold Cathode Stopped by CCS"),
    HX_TURBO_CC_STOPPED("HxTurboColdCathodeStopped", "HX Turbo Gauge Cold Cathode Stopped by CCS"),
    CRYO_TURBO_PUMP_STOPPED("CryoTurboPumpStopped", "Cryo Turbo Pump Stopped by CCS"),
    CRYO_ION_PUMPS_STOPPED("CryoIonPumpsStopped", "Cryo Ion Pumps Stopped by CCS"),
    CRYO_GATE_CLOSED("CryoGateClosed", "Cryo Gate Valve Closed by CCS"),
    HX_TURBO_PUMP_STOPPED("HxTurboPumpStopped", "HX Turbo Pump Stopped by CCS"),
    HX_ION_PUMPS_STOPPED("HxIonPumpsStopped", "HX Ion Pumps Stopped by CCS"),
    HX_GATE_CLOSED("HxGateClosed", "HX Gate Valve Closed by CCS"),
    REFRIG_NOT_PERMITTED("RefrigNotPermitted", "Refrig permits removed by CCS");
        
    private final String id, description;
    
    VacuumAlert(String id, String description) {
        this.id = id;
        this.description = description;
    }
    
    public String getId() {
        return id;
    }
    
    public String getDescription() {
        return description;
    }
    
    public Alert getAlert() {
        return new Alert(id, description);
    }
    
}
