package org.lsst.ccs.subsystem.vacuum.data;

import java.io.Serializable;
import java.util.Arrays;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.subsystem.vacuum.constants.ConditionState;
import org.lsst.ccs.subsystem.vacuum.constants.Conditions;
import org.lsst.ccs.subsystem.vacuum.constants.DeviceState;
import org.lsst.ccs.subsystem.vacuum.constants.LatchState;
import org.lsst.ccs.subsystem.vacuum.constants.Latches;
import org.lsst.ccs.subsystem.vacuum.constants.PLCState;
import org.lsst.ccs.subsystem.vacuum.constants.SwitchEnable;
import org.lsst.ccs.subsystem.vacuum.constants.SwitchState;
import org.lsst.ccs.subsystem.vacuum.constants.Switches;
import org.lsst.ccs.subsystem.vacuum.constants.CryoVacuumState;
import org.lsst.ccs.subsystem.vacuum.constants.HxVacuumState;

/**
 *  Contains the state of the vacuum subsystem
 *
 *  @author Owen Saxton
 */
@SkipEncoding
public class VacSysState implements Serializable {
    
    public static final String KEY = "VacuumState";

    private int tickMillis;           // Data status update period (ms)
    private CryoVacuumState cryoVacuumState = CryoVacuumState.UNKNOWN;  // The cryo vacuum state
    private HxVacuumState hxVacuumState = HxVacuumState.UNKNOWN;  // The HX vacuum state
    private PLCState plcState = PLCState.ALIVE;  // The PLC state

    private double CryoPress, HXPress, CryoTurboPress, HXTurboPress, CryoFlinePress, HXFlinePress, PCPress, pcTargetPressure,
	maxVentPressure,minPumpPressure; 

    private int cyclingStatus, ventingStatus;
    private String cryoForelineValveStatus, hxForelineValveStatus, pcTargetPressureSrc;
    private boolean pumpCartPumpingSwitchState, pumpCartVentingSwitchState, pumpPCAbortPumpState, pumpPCAbortVentState;
    private boolean cryoTurboVentingSwitchState, hxTurboVentingSwitchState; 
    private Boolean cryoTurboPumpSwitchState, hxTurboPumpSwitchState;

    private final SwitchState[] switchState = new SwitchState[Switches.NUM_SWITCHES];  // Switch state array
    private final SwitchEnable[] switchEnable = new SwitchEnable[Switches.NUM_SWITCHES];  // Switch enable array
    private final DeviceState[] deviceState = new DeviceState[Switches.NUM_SWITCHES];  // Extra device state array
    private final LatchState[] latchState = new LatchState[Latches.NUM_LATCHES];  // Latched PLC conditions array
    private final ConditionState[] conditionState = new ConditionState[Conditions.NUM_CONDITIONS];  // PLC conditions array

    public VacSysState() {
        Arrays.fill(switchState, SwitchState.OFFLINE);
        Arrays.fill(switchEnable, SwitchEnable.OFF);
        Arrays.fill(latchState, LatchState.CLEAR);
        Arrays.fill(conditionState, ConditionState.NO);
    }

    public void setTickMillis(int value) {
        tickMillis = value;
    }

    public int getTickMillis() {
        return tickMillis;
    }

    public void setCryoVacuumState(CryoVacuumState value) {
        cryoVacuumState = value;
    }

    public CryoVacuumState getCryoVacuumState() {
        return cryoVacuumState;
    }

    public void setHxVacuumState(HxVacuumState value) {
        hxVacuumState = value;
    }

    public HxVacuumState getHxVacuumState() {
        return hxVacuumState;
    }

    public void setPlcState(PLCState value) {
        plcState = value;
    }

    public PLCState getPlcState() {
        return plcState;
    }

    public void setSwitchState(int sw, SwitchState state) {
        switchState[sw] = state;
    }

    public SwitchState getSwitchState(int sw) {
        return switchState[sw];
    }

    public void setSwitchEnable(int sw, SwitchEnable enable) {
        switchEnable[sw] = enable;
    }

    public SwitchEnable getSwitchEnable(int sw) {
        return switchEnable[sw];
    }

    public void setDeviceState(int sw, DeviceState state) {
        deviceState[sw] = state;
    }

    public DeviceState getDeviceState(int sw) {
        return deviceState[sw];
    }

    public void setLatch(int latch, LatchState state) {
        latchState[latch] = state;
    }

    public LatchState getLatch(int latch) {
        return latchState[latch];
    }

    public void setCondition(int cond, ConditionState state) {
        conditionState[cond] = state;
    }

    public ConditionState getCondition(int cond) {
        return conditionState[cond];
    }

    // ----- pressure value additions ------

    public void setCryoPress(double value) {
        CryoPress = value;
    }

    public double getCryoPress() {
        return CryoPress;
    }

    public void setHXPress(double value) {
        HXPress = value;
    }

    public double getHXPress() {
        return HXPress;
    }

    public void setCryoTurboPress(double value) {
        CryoTurboPress = value;
    }

    public double getCryoTurboPress() {
        return CryoTurboPress;
    }

    public void setHXTurboPress(double value) {
        HXTurboPress = value;
    }

    public double getHXTurboPress() {
        return HXTurboPress;
    }

    public void setCryoFlinePress(double value) {
        CryoFlinePress = value;
    }

    public double getCryoFlinePress() {
        return CryoFlinePress;
    }

    public void setHXFlinePress(double value) {
        HXFlinePress = value;
    }

    public double getHXFlinePress() {
        return HXFlinePress;
    }

    public void setCyclingStatus(int value) {
        cyclingStatus = value;
    }

    public double getCyclingStatus() {
        return cyclingStatus;
    }

    public void setPumpCartPumpingSwitchState(boolean value) {
        pumpCartPumpingSwitchState = value;
    }

    public boolean getPumpCartPumpingSwitchState() {
        return pumpCartPumpingSwitchState;
    }

    public void setPumpCartVentingSwitchState(boolean value) {
        pumpCartVentingSwitchState = value;
    }

    public boolean getPumpCartVentingSwitchState() {
        return pumpCartVentingSwitchState;
    }
    // ---
    public void setCryoTurboVentingSwitchState(boolean value) {
        cryoTurboVentingSwitchState = value;
    }

    public boolean getCryoTurboVentingSwitchState() {
        return cryoTurboVentingSwitchState;
    }

    public void setCryoTurboPumpSwitchState(boolean value) {
        cryoTurboPumpSwitchState = value;
    }

    public Boolean getCryoTurboPumpSwitchState() {
        return cryoTurboPumpSwitchState;
    }
    // ---
    public void setHXTurboVentingSwitchState(boolean value) {
        hxTurboVentingSwitchState = value;
    }

    public boolean getHXTurboVentingSwitchState() {
        return hxTurboVentingSwitchState;
    }

    public void setHXTurboPumpSwitchState(boolean value) {
        hxTurboPumpSwitchState = value;
    }

    public Boolean getHXTurboPumpSwitchState() {
        return hxTurboPumpSwitchState;
    }
    // ---
    public void setPCAbortVentState(boolean value) {
        pumpPCAbortVentState = value;
    }

    public boolean getPCAbortVentState() {
        return pumpPCAbortVentState;
    }

    public void setPCAbortPumpState(boolean value) {
        pumpPCAbortPumpState = value;
    }

    public boolean getPCAbortPumpState() {
        return pumpPCAbortPumpState;
    }

    public void setPCTargetPressureSrc(String value) {
        pcTargetPressureSrc = value;
    }

    public String getPCTargetPressureSrc() {
        return pcTargetPressureSrc;
    }

    public void setPCTargetPressure(double value) {
        pcTargetPressure = value;
    }

    public double getPCTargetPressure() {
        return pcTargetPressure;
    }

    public void setMinPumpPressure(double value) {
        minPumpPressure = value;
    }

    public double getMinPumpPressure() {
        return minPumpPressure;
    }

    public void setMaxVentPressure(double value) {
        maxVentPressure = value;
    }

    public double getMaxVentPressure() {
        return maxVentPressure;
    }

    public void setVentingStatus(int value) {
        ventingStatus = value;
    }

    public double getVentingStatus() {
        return ventingStatus;
    }

    public void setCryoForelineValveStatus(String value) {
        cryoForelineValveStatus = value;
    }

    public String getCryoForelineValveStatus() {
        return cryoForelineValveStatus;
    }

    public void setHXForelineValveStatus(String value) {
        hxForelineValveStatus = value;
    }

    public String getHXForelineValveStatus() {
        return hxForelineValveStatus;
    }

    public void setPCPress(double value) {
        PCPress = value;
    }

    public double getPCPress() {
        return PCPress;
    }
    private static final long serialVersionUID = -2669272698864689859L;
}
