package org.lsst.ccs.subsystem.vacuum.config;

import java.io.Serializable;

/**
 *  Contains a set of cryo configuration values.
 *
 *  @author Owen Saxton
 */
public class VacuumConfig implements Serializable {

    public static final String CRYO = "Cryo";

    private String name;
    private Channel[] channels;

    public static class Channel implements Serializable {

        private String name;
        private double voltage;
        private double current;
        private double power;

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public double getVoltage() {
            return voltage;
        }

        public void setVoltage(double voltage) {
            this.voltage = voltage;
        }

        public double getCurrent() {
            return current;
        }

        public void setCurrent(double current) {
            this.current = current;
        }

        public double getPower() {
            return power;
        }

        public void setPower(double power) {
            this.power = power;
        }

        private static final long serialVersionUID = -2199926246558369020L;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Channel[] getChannels() {
        return channels;
    }

    public void setChannels(Channel[] channels) {
        this.channels = channels;
    }

    private static final long serialVersionUID = 2947550617334327895L;
}
