package org.lsst.ccs.subsystem.vacuum.constants;

import org.lsst.ccs.bus.data.Alert;

/**
 * Vacuum Alerts.
 * 
 * @author The LSST CCS Team
 */
public enum VacuumAlert {

    /**
     * Vacuum PLC is unresponsive or has error conditions
     */
    VACUUM_PLC_NOT_ALIVE("VacuumPLCNotAlive", "Vacuum PLC not alive"),
    CRYO_VACUUM_BAD("CryoVacuumBad", "Cryo vacuum bad"),
    CRYO_GATE_FORCED_SHUT("CryoGateForcedShut", "Cryo gate valve forced shut"),
    CRYO_GATE_CANNOT_OPEN("CryoGateCannotOpen", "Cryo gate valve cannot open"),
    CRYO_TURBO_PUMP_BAD("CryoTurboPumpBad", "Cryo turbo pump bad"),
    CRYO_VAC_CC_STOPPED("CryoVacColdCathodeStopped", "Cryo vac gauge cold cathode stopped by CCS"),
    CRYO_TURBO_CC_STOPPED("CryoTurboColdCathodeStopped", "Cryo turbo gauge cold cathode stopped by CCS"),
    HX_VACUUM_BAD("HxVacuumBad", "HX vacuum bad"),
    HX_GATE_FORCED_SHUT("HxGateForcedShut", "HX gate valve forced shut"),
    HX_GATE_CANNOT_OPEN("HxGateCannotOpen", "HX gate valve cannot open"),
    HX_TURBO_PUMP_BAD("HxTurboPumpBad", "HX turbo pump bad"),
    HX_VAC_CC_STOPPED("HxVacColdCathodeStopped", "HX vac gauge cold cathode stopped by CCS"),
    HX_TURBO_CC_STOPPED("HxTurboColdCathodeStopped", "HX turbo gauge cold cathode stopped by CCS"),
    CRYO_TURBO_PUMP_STOPPED("CryoTurboPumpStopped", "Cryo turbo pump stopped by CCS"),
    CRYO_ION_PUMPS_STOPPED("CryoIonPumpsStopped", "Cryo ion pumps stopped by CCS"),
    CRYO_GATE_CLOSED("CryoGateClosed", "Cryo gate valve closed by CCS"),
    HX_TURBO_PUMP_STOPPED("HxTurboPumpStopped", "HX turbo pump stopped by CCS"),
    HX_ION_PUMPS_STOPPED("HxIonPumpsStopped", "HX ion pumps stopped by CCS"),
    HX_GATE_CLOSED("HxGateClosed", "HX gate valve closed by CCS"),
    REFRIG_NOT_PERMITTED("RefrigNotPermitted", "Refrig permits removed by CCS"),
    CRYO_GATE_POSN_ERROR("CryoGatePosnError", "Cryo gate valve position readback inconsistent"),
    HX_GATE_POSN_ERROR("HxGatePosnError", "HX gate valve position readback inconsistent"),
    CRYO_GATE_IN_TRANSIT("CryoGateInTransit", "Cryo gate valve stuck in transit"),
    HX_GATE_IN_TRANSIT("HxGateInTransit", "HX gate valve stuck in transit"),
    BOTH_PUMPING_VENTING("BothPumpVent", "Tried to pump and vent simultaneously"),


    // Monitoring alerts
    /**
     * Alert raised if TurboPump status shows pump failure
     */
    CRYO_TURBO_PUMP_FAIL("CryoTurboPumpFailure", "Alert raised when Cryo TurboPump status is Fail"),
    HX_TURBO_PUMP_FAIL("HxTurboPumpFailure", "Alert raised when HX TurboPump status is Fail"),
    /**
     * Alert raised if TurboPump power is too high
     */
    CRYO_TURBO_PUMP_POWER_HIGH("CryoTurboPowerHigh", "Alert raised when the Cryo Turbo Power is too high"),
    HX_TURBO_PUMP_POWER_HIGH("HxTurboPowerHigh", "Alert raised when the HX Turbo Power is too high"),
   /**
     * Alert raised if TurboPump temperature is too high
     */
    CRYO_TURBO_PUMP_TEMP_HIGH("CryoTurboTempHigh", "Alert raised when the Cryo Turbo Temp is too high"),
    HX_TURBO_PUMP_TEMP_HIGH("HxTurboTempHigh", "Alert raised when the HX Turbo Temp is too high");

        
    private final String id, description;
    
    VacuumAlert(String id, String description) {
        this.id = id;
        this.description = description;
    }
    
    public String getId() {
        return id;
    }
    
    public String getDescription() {
        return description;
    }
    
    public Alert getAlert() {
        return new Alert(id, description);
    }
    
}
