package org.lsst.ccs.subsystem.vacuum.constants;

import org.lsst.ccs.bus.data.Alert;

/**
 * Vacuum Gauge Relay Setting Alerts.
 * 
 * @author The LSST CCS Team
 */
public enum RelayAlert {

    /**
     * Vacuum gauge has incorrect settings
     */
    RELAY_DIRN_BAD("DirnBad", "Relay direction is not BELOW"),
    RELAY_NOT_ENAB("NotEnab", "Relay is not enabled"),
    RELAY_TRIP_BAD("TripBad", "Relay trip point is set incorrectly");

    private final String id, description;
    
    RelayAlert(String id, String description) {
        this.id = id;
        this.description = description;
    }
    
    public Alert getAlert(String gauge, int relay) {
        return new Alert(gauge + "/Relay" + relay + id, description);
    }
    
}
