package org.lsst.ccs.subsystem.vacuum.constants;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.subsystem.vacuum.data.VacSysState;

/**
 *  Definitions of the vacuum system switch names.
 *
 *  @author The CCS team
 */
public class SwitchNames {

    public static final String
        CRYO_TURBO_PUMP = "CryoTurboPump",
        CRYO_ION_PUMP1  = "CryoIonPump1",
        CRYO_ION_PUMP2  = "CryoIonPump2",
        CRYO_ION_PUMP3  = "CryoIonPump3",
        CRYO_ION_PUMP4  = "CryoIonPump4",
        CRYO_ION_PUMP5  = "CryoIonPump5",
        CRYO_ION_PUMP6  = "CryoIonPump6",
        CRYO_GATE_VALVE = "CryoGateValve",
        HX_TURBO_PUMP   = "HxTurboPump",
        HX_ION_PUMP1    = "HxIonPump1",
        HX_ION_PUMP2    = "HxIonPump2",
        HX_GATE_VALVE   = "HxGateValve",
        OR_ION_PUMP     = "OrIonPump",
        OR_FPP_VALVE    = "OrFppValve",
        OR_FH_VALVE     = "OrFhValve",
        OR_L3H_VALVE    = "OrL3hValve",
        OR_L3_VALVE     = "OrL3Valve";

    public static final Map<String, Integer> NAME_MAP = new HashMap<>();
    static {
        NAME_MAP.put(CRYO_TURBO_PUMP, VacSysState.SW_CRYO_TURBO_PUMP);
        NAME_MAP.put(CRYO_ION_PUMP1, VacSysState.SW_CRYO_ION_PUMP1);
        NAME_MAP.put(CRYO_ION_PUMP2, VacSysState.SW_CRYO_ION_PUMP2);
        NAME_MAP.put(CRYO_ION_PUMP3, VacSysState.SW_CRYO_ION_PUMP3);
        NAME_MAP.put(CRYO_ION_PUMP4, VacSysState.SW_CRYO_ION_PUMP4);
        NAME_MAP.put(CRYO_ION_PUMP5, VacSysState.SW_CRYO_ION_PUMP5);
        NAME_MAP.put(CRYO_ION_PUMP6, VacSysState.SW_CRYO_ION_PUMP6);
        NAME_MAP.put(CRYO_GATE_VALVE, VacSysState.SW_CRYO_GATE_VALVE);
        NAME_MAP.put(HX_TURBO_PUMP, VacSysState.SW_HX_TURBO_PUMP);
        NAME_MAP.put(HX_ION_PUMP1, VacSysState.SW_HX_ION_PUMP1);
        NAME_MAP.put(HX_ION_PUMP2, VacSysState.SW_HX_ION_PUMP2);
        NAME_MAP.put(HX_GATE_VALVE, VacSysState.SW_HX_GATE_VALVE);
        NAME_MAP.put(OR_FPP_VALVE, VacSysState.SW_OR_FPP_VALVE);
        NAME_MAP.put(OR_FH_VALVE, VacSysState.SW_OR_FH_VALVE);
        NAME_MAP.put(OR_L3H_VALVE, VacSysState.SW_OR_L3H_VALVE);
        NAME_MAP.put(OR_L3_VALVE, VacSysState.SW_OR_L3_VALVE);
        NAME_MAP.put(OR_ION_PUMP, VacSysState.SW_OR_ION_PUMP);
    }
    public static final Map<Integer, String> ID_MAP = new HashMap<>();
    static {
        for (Map.Entry e : NAME_MAP.entrySet()) {
            ID_MAP.put((Integer)e.getValue(), (String)e.getKey());
        }
    }

}
