/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.config.ConfigurationParameterDescription;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.PIController;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20PWMControl;
import org.lsst.ccs.subsystem.utility.data.UtilityException;

public class FanPIControl
implements HasLifecycle {
    private static final String PIC = "Pic";
    @LookupField(strategy=LookupField.Strategy.TOP)
    Subsystem subsys;
    @LookupName
    private String name;
    @LookupPath
    private String path;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskServices;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile Double gain = Double.NaN;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile Double timeConst = Double.NaN;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile Double smoothTime = Double.NaN;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile Double awGain = Double.NaN;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile Double baseDuty = Double.NaN;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile Double tolerance = Double.NaN;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile double minInput = -10.0;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile double maxInput = 10.0;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile double minDutyCycle = 0.1;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile double maxDutyCycle = 0.9;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile double offDutyCycle = 0.05;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile int minRpm = 1000;
    @ConfigurationParameter(category="Pic", isFinal=true)
    private volatile int maxRpm = 7000;
    private List<Channel> refTempChans;
    private List<Channel> ctrlTempChans;
    private double[] ctrlTempWeights;
    private Maq20PWMControl fan;
    private static final Logger LOG = Logger.getLogger(FanPIControl.class.getName());
    private final List<TempData> ctrlTempDataList = new ArrayList<TempData>();
    private PIController pic;
    private double dcSlope;
    private double lastDuty;
    private boolean active = false;
    private double setTemp;
    private long speedSetTime;
    private boolean loopFailed = false;

    public void build() {
        ConfigurationParameterDescription desc = new ConfigurationParameterDescription().withCategory(PIC).withName("updateTime");
        AgentPeriodicTask apt = new AgentPeriodicTask("fan-loop-" + this.name, () -> this.iterateLoop()).withPeriod(Duration.ofMillis(10000L)).withPeriodParameterDescription(desc);
        this.periodicTaskServices.scheduleAgentPeriodicTask(apt);
    }

    public void init() {
        this.dcSlope = (this.maxDutyCycle - this.minDutyCycle) / (double)(this.maxRpm - this.minRpm);
        if (!Double.isFinite(this.dcSlope) || this.dcSlope < 0.0) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)"RPM conversion constants", (String)"are invalid");
        }
        if (this.fan == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)"fan", (String)"has not been specified");
        }
        if (this.refTempChans == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)"refTempChans", (String)"has not been specified");
        }
        if (this.ctrlTempChans == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)"ctrlTempChans", (String)"has not been specified");
        }
        if (this.ctrlTempWeights == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)"ctrlTempWeights", (String)"has not been specified");
        }
        if (this.ctrlTempWeights.length != this.ctrlTempChans.size()) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)"ctrlTempWeights and ctrlTempChans", (String)"have different numbers of elements");
        }
        double total = 0.0;
        for (int j = 0; j < this.ctrlTempChans.size(); ++j) {
            double weight = this.ctrlTempWeights[j];
            if (weight < 0.0) {
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)"ctrlTempWeights", (String)"contains a negative value");
            }
            this.ctrlTempDataList.add(new TempData(this.ctrlTempChans.get(j), weight));
            total += weight;
        }
        if (this.ctrlTempDataList.isEmpty() ^ this.refTempChans.isEmpty()) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)"ctrlTempChans and refTempChans", (String)"are neither both non-empty nor both empty");
        }
        if (this.ctrlTempDataList.isEmpty()) {
            return;
        }
        if (total == 0.0) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)"ctrlTempWeights", (String)"total is zero");
        }
        if (this.gain == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)"gain", (String)"is missing");
        }
        if (this.timeConst.isNaN()) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)"timeConst", (String)"is missing");
        }
        if (this.smoothTime.isNaN()) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)"smoothTime", (String)"is missing");
        }
        if (this.awGain.isNaN()) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)"awGain", (String)"is missing");
        }
        if (this.baseDuty.isNaN()) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)"baseDuty", (String)"is missing");
        }
        if (this.tolerance.isNaN()) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)"tolerance", (String)"is missing");
        }
        this.pic = new PIController(-this.gain.doubleValue(), this.timeConst.doubleValue());
        this.pic.setSmoothTime(this.smoothTime.doubleValue());
        this.pic.setAwGain(this.awGain.doubleValue());
        this.pic.setBaseOutput(this.baseDuty.doubleValue());
        this.pic.setInputRange(this.minInput, this.maxInput);
        this.pic.setOutputRange(this.minDutyCycle, this.maxDutyCycle);
        this.pic.setTolerance(this.tolerance.doubleValue());
    }

    public void setSpeed(double speed) {
        try {
            this.fan.setDutyCycle1(speed);
            this.speedSetTime = System.currentTimeMillis();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Error setting {0} fan speed: {1}", new Object[]{this.fan, ex});
        }
    }

    public Double getSpeed() {
        try {
            return this.fan.getDutyCycle1();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Error getting {0} fan speed: {1}", new Object[]{this.fan, ex});
            return null;
        }
    }

    public Integer getRpm() {
        Double speed = this.getSpeed();
        return speed == null ? null : Integer.valueOf(speed < this.offDutyCycle ? 0 : Math.max(this.minRpm, Math.min(this.maxRpm, (int)((double)this.minRpm + (speed - this.minDutyCycle) / this.dcSlope))));
    }

    public long getSpeedSetTime() {
        return this.speedSetTime;
    }

    public void setTemperature(double temp) throws UtilityException {
        this.checkPicPresent();
        this.setTemp = temp;
        this.pic.setSetpoint(this.setTemp);
    }

    public double getTemperature() {
        return this.setTemp;
    }

    public void setGain(double gain) throws UtilityException {
        this.checkPicPresent();
        this.gain = gain;
        if (this.pic != null) {
            this.pic.setPID(-gain, this.timeConst.doubleValue());
        }
    }

    public double getGain() {
        return this.gain;
    }

    public void setTimeConstant(double time) throws UtilityException {
        this.checkPicPresent();
        this.timeConst = time;
        this.pic.setPID(-this.gain.doubleValue(), this.timeConst.doubleValue());
    }

    public double getTimeConstant() {
        return this.timeConst;
    }

    public void startLoop(double duty) throws UtilityException {
        this.checkPicPresent();
        if (this.active) {
            return;
        }
        this.lastDuty = duty;
        this.startLoop();
    }

    public void startLoop() throws UtilityException {
        this.checkPicPresent();
        if (this.active) {
            return;
        }
        this.pic.reset();
        this.pic.setIntegral(this.lastDuty - this.baseDuty);
        this.active = true;
    }

    public void stopLoop() throws UtilityException {
        this.checkPicPresent();
        if (!this.active) {
            return;
        }
        this.active = false;
    }

    public boolean isLoopActive() {
        return this.active;
    }

    public void reset() throws UtilityException {
        this.checkPicPresent();
        this.pic.reset();
    }

    private void iterateLoop() {
        if (!this.active) {
            return;
        }
        double refTemp = 0.0;
        int count = 0;
        for (Channel tempChan : this.refTempChans) {
            double value = tempChan.getValue();
            if (Double.isNaN(value)) continue;
            refTemp += value;
            ++count;
        }
        if (count > 0) {
            refTemp /= (double)count;
        } else {
            if (!this.loopFailed) {
                LOG.log(Level.SEVERE, "{0} control loop iteration failed: no valid reference temperature values available", this.path);
                this.loopFailed = true;
            }
            return;
        }
        double ctrlTemp = 0.0;
        double totalWeight = 0.0;
        for (TempData tempData : this.ctrlTempDataList) {
            double value = tempData.chan.getValue();
            if (Double.isNaN(value)) continue;
            ctrlTemp += value * tempData.weight;
            totalWeight += tempData.weight;
        }
        if (!(totalWeight > 0.0)) {
            if (!this.loopFailed) {
                LOG.log(Level.SEVERE, "{0} control loop iteration failed: no valid control temperature values available", this.path);
                this.loopFailed = true;
            }
            return;
        }
        this.lastDuty = this.pic.performPI(new double[]{(ctrlTemp /= totalWeight) - refTemp}, (double)System.currentTimeMillis() / 1000.0);
        this.setSpeed(this.lastDuty);
        this.loopFailed = false;
    }

    private void checkPicPresent() throws UtilityException {
        if (this.pic == null) {
            throw new UtilityException("Control loop not present");
        }
    }

    private static class TempData {
        Channel chan;
        double weight;

        TempData(Channel chan, double weight) {
            this.chan = chan;
            this.weight = weight;
        }
    }
}

