/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility;

import java.io.Serializable;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.alert.AlertEvent;
import org.lsst.ccs.services.alert.AlertListener;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.MonitorTaskControl;
import org.lsst.ccs.subsystem.utility.MpmPlutoDevice;
import org.lsst.ccs.subsystem.utility.constants.ConditionState;
import org.lsst.ccs.subsystem.utility.constants.LatchState;
import org.lsst.ccs.subsystem.utility.constants.MpmAlert;
import org.lsst.ccs.subsystem.utility.constants.MpmLatches;
import org.lsst.ccs.subsystem.utility.constants.MpmSwitches;
import org.lsst.ccs.subsystem.utility.constants.PLCState;
import org.lsst.ccs.subsystem.utility.constants.SwitchState;
import org.lsst.ccs.subsystem.utility.data.MpmSysState;
import org.lsst.ccs.subsystem.utility.data.UtilityException;

public class MpmMain
extends Subsystem
implements HasLifecycle,
AlertListener {
    private static final Map<Integer, MpmAlert> alertMap = new HashMap<Integer, MpmAlert>();
    private static final Map<String, String> revAlertMap;
    private static final MpmAlert[] plcAlerts;
    private static final String[] plcNames;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService propertiesService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private MpmPlutoDevice plutoDevc;
    private static final Logger LOG;
    private final MpmSysState mpmState = new MpmSysState();
    private MonitorTaskControl monitorControl;
    private boolean running = false;
    private boolean gotCommand = false;

    public MpmMain() {
        super("mpm", AgentInfo.AgentType.WORKER);
    }

    public void build() {
        this.monitorControl = MonitorTaskControl.createNode((Subsystem)this, (String)"MonitorControl");
        AgentPeriodicTask pt = new AgentPeriodicTask("Protection-state", () -> this.updateMpmState()).withPeriod(Duration.ofMillis(1000L));
        this.periodicTaskService.scheduleAgentPeriodicTask(pt);
    }

    public void init() {
        for (MpmAlert alert : plcAlerts) {
            this.alertService.registerAlert(alert.getAlert());
        }
        for (MpmAlert alert : alertMap.values()) {
            this.alertService.registerAlert(alert.getAlert());
        }
    }

    public void postInit() {
        this.propertiesService.setAgentProperty("mpmType", MpmMain.class.getCanonicalName());
        this.alertService.addListener((AlertListener)this);
        if (this.plutoDevc != null) {
            int cond;
            for (cond = 0; cond < 11; ++cond) {
                this.mpmState.setLatch(cond, LatchState.CLEAR);
            }
            for (cond = 0; cond < 7; ++cond) {
                this.mpmState.setCondition(cond, ConditionState.NO);
            }
        } else {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"Pluto device", (String)"not specified");
        }
    }

    public void postStart() {
        LOG.info("Protection subsystem started");
        this.running = true;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the protection system state")
    public MpmSysState getSystemState() {
        this.mpmState.setTickMillis(this.monitorControl.getFastPeriod());
        return this.mpmState;
    }

    @Command(type=Command.CommandType.QUERY, description="Get switch names")
    public List<String> getSwitchNames() throws UtilityException {
        return MpmSwitches.getNames();
    }

    @Command(type=Command.CommandType.ACTION, description="Turn on/off a named switch")
    public void setNamedSwitchOn(@Argument(description="The switch name") String swch, @Argument(description="Whether to turn on") boolean on) throws UtilityException {
        this.gotCommand = true;
        int sw = MpmSwitches.getId((String)swch);
        SwitchState state = this.mpmState.getSwitchState(sw);
        if (state == SwitchState.OFFLINE) {
            return;
        }
        this.plutoDevc.setSwitchOn(sw, on, false);
    }

    @Command(type=Command.CommandType.QUERY, description="Get latched condition names")
    public List<String> getLatchNames() throws UtilityException {
        return MpmLatches.getNames();
    }

    @Command(type=Command.CommandType.ACTION, description="Clear a latched condition")
    public void clearLatch(@Argument(description="The condition name") String cond) throws UtilityException {
        this.gotCommand = true;
        this.plutoDevc.clearLatch(MpmLatches.getId((String)cond));
    }

    private void updateMpmState() {
        int cond;
        Boolean active;
        if (!this.running) {
            return;
        }
        boolean changed = this.monitorControl.hasPeriodChanged();
        for (int plc = 0; plc < 3; ++plc) {
            PLCState newState;
            active = this.plutoDevc.isPlcActive(plc);
            PLCState pLCState = active == null ? PLCState.OFFLINE : (newState = active != false ? PLCState.ALIVE : PLCState.DEAD);
            if (newState == this.mpmState.getPlcState(plc)) continue;
            changed = true;
            this.mpmState.setPlcState(plc, newState);
            MpmAlert alert = plcAlerts[plc];
            String plcDesc = plcNames[plc] + " protection PLC ";
            if (newState == PLCState.ALIVE) {
                this.lowerAlert(alert, plcDesc + "is alive");
                continue;
            }
            String errDesc = newState == PLCState.DEAD ? "has died: error = " + this.plutoDevc.getErrorCode(plc) : "is offline";
            this.raiseAlert(alert, plcDesc + errDesc);
        }
        for (int sw = 0; sw < 7; ++sw) {
            SwitchState state = this.plutoDevc.getSwitchState(sw);
            if (state == this.mpmState.getSwitchState(sw)) continue;
            this.mpmState.setSwitchState(sw, state);
            changed = true;
        }
        for (cond = 0; cond < 11; ++cond) {
            active = this.plutoDevc.isLatchActive(cond);
            Boolean latched = this.plutoDevc.isLatchLatched(cond);
            LatchState state = active == null || latched == null ? LatchState.OFFLINE : (latched != false ? LatchState.LATCHED : (active != false ? LatchState.ACTIVE : LatchState.CLEAR));
            MpmAlert alert = alertMap.get(cond);
            LatchState oldState = this.mpmState.getLatch(cond);
            if (state == oldState) continue;
            this.mpmState.setLatch(cond, state);
            if (state == LatchState.ACTIVE) {
                this.raiseAlert(alert, "Protection PLC error condition set");
            } else if (state != LatchState.OFFLINE) {
                if (oldState != LatchState.ACTIVE && state == LatchState.LATCHED) {
                    this.raiseAlert(alert, "Protection PLC error condition set");
                }
                if (oldState == LatchState.ACTIVE || state == LatchState.LATCHED) {
                    this.lowerAlert(alert, "Protection PLC error condition cleared");
                }
            }
            changed = true;
        }
        for (cond = 0; cond < 7; ++cond) {
            ConditionState state;
            active = this.plutoDevc.isConditionActive(cond);
            ConditionState conditionState = active == null ? ConditionState.OFF : (state = active != false ? ConditionState.YES : ConditionState.NO);
            if (state == this.mpmState.getCondition(cond)) continue;
            this.mpmState.setCondition(cond, state);
            changed = true;
        }
        if (this.mpmState.getLimit(0) == Integer.MAX_VALUE) {
            int[] limits = this.plutoDevc.getTempLimits();
            for (int j = 0; j < 4; ++j) {
                this.mpmState.setLimit(j, limits[j]);
            }
            changed = true;
        }
        if (this.gotCommand) {
            changed = true;
            this.gotCommand = false;
        }
        if (changed) {
            this.publishState();
        }
    }

    private void raiseAlert(MpmAlert alert, String cond) {
        this.alertService.raiseAlert(alert.getAlert(), AlertState.ALARM, cond);
    }

    private void lowerAlert(MpmAlert alert, String cond) {
        this.alertService.raiseAlert(alert.getAlert(), AlertState.NOMINAL, cond);
    }

    public void onAlert(AlertEvent event) {
        if (event.getType() != AlertEvent.AlertEventType.ALERT_CLEARED) {
            return;
        }
        for (String id : event.getClearedIds()) {
            String cond = revAlertMap.get(id);
            if (cond == null) continue;
            try {
                this.clearLatch(cond);
            }
            catch (UtilityException e) {
                LOG.log(Level.SEVERE, "Error clearing latched PLC condition ({0}): {1}", new Object[]{cond, e});
            }
        }
    }

    private void publishState() {
        this.mpmState.setTickMillis(this.monitorControl.getFastPeriod());
        this.publishSubsystemDataOnStatusBus(new KeyValueData("MPMState", (Serializable)this.mpmState));
    }

    static {
        alertMap.put(5, MpmAlert.COLD_TEMP_HIGH);
        alertMap.put(6, MpmAlert.COLD_TEMP_LOW);
        alertMap.put(7, MpmAlert.CRYO_TEMP_HIGH);
        alertMap.put(8, MpmAlert.CRYO_TEMP_LOW);
        alertMap.put(9, MpmAlert.CRYO_VACUUM_BAD);
        alertMap.put(10, MpmAlert.HEX_VACUUM_BAD);
        alertMap.put(1, MpmAlert.UT_COOLANT_LEAK);
        alertMap.put(2, MpmAlert.UT_LEAK_DETC_FAULT);
        alertMap.put(3, MpmAlert.UT_SMOKE_DETC);
        alertMap.put(4, MpmAlert.UT_SMOKE_DETC_FAULT);
        alertMap.put(0, MpmAlert.UT_TEMP_HIGH);
        revAlertMap = new HashMap<String, String>();
        for (Map.Entry<Integer, MpmAlert> e : alertMap.entrySet()) {
            revAlertMap.put(e.getValue().getId(), MpmLatches.getName((int)e.getKey()));
        }
        plcAlerts = new MpmAlert[3];
        MpmMain.plcAlerts[0] = MpmAlert.POWER_PLC_NOT_ALIVE;
        MpmMain.plcAlerts[1] = MpmAlert.COLD_PLC_NOT_ALIVE;
        MpmMain.plcAlerts[2] = MpmAlert.CRYO_PLC_NOT_ALIVE;
        plcNames = new String[3];
        MpmMain.plcNames[0] = "Power";
        MpmMain.plcNames[1] = "Cold";
        MpmMain.plcNames[2] = "Cryo";
        LOG = Logger.getLogger(MpmMain.class.getName());
    }
}

