/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility;

import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.MessagingService;
import org.lsst.ccs.services.alert.AlertEvent;
import org.lsst.ccs.services.alert.AlertListener;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.actions.MpmAction;
import org.lsst.ccs.subsystem.utility.MpmPlutoDevice;

public class MpmActionManager
implements HasLifecycle,
AlertListener,
AgentPresenceListener {
    private static final Logger LOG = Logger.getLogger(MpmActionManager.class.getName());
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService propertiesService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private MpmPlutoDevice plutoDevice;
    private final Set<String> origins = new ConcurrentSkipListSet<String>();
    private final Set<String> clearOrigins = new ConcurrentSkipListSet<String>();
    private final Set<String>[] active = new ConcurrentSkipListSet[MpmAction.Action.values().length];

    public MpmActionManager() {
        for (int j = 0; j < this.active.length; ++j) {
            this.active[j] = new ConcurrentSkipListSet<String>();
        }
    }

    public void build() {
        if (this.plutoDevice == null) {
            throw new RuntimeException("Could not find an instance of MpmPlutoDevice in the tree.");
        }
    }

    public void init() {
        this.propertiesService.setAgentProperty(MpmAction.getManagerName(), "");
        this.alertService.startStatusAlertListening(info -> info.isAgentWorkerOrService());
        ((MessagingService)this.agent.getAgentService(MessagingService.class)).getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
    }

    public void start() {
        this.alertService.addListener((AlertListener)this);
    }

    public void shutdown() {
        ((MessagingService)this.agent.getAgentService(MessagingService.class)).getMessagingAccess().getAgentPresenceManager().removeAgentPresenceListener((AgentPresenceListener)this);
        this.alertService.removeListener((AlertListener)this);
    }

    public void connecting(AgentInfo ... agents) {
        for (AgentInfo ai : agents) {
            if (!ai.hasAgentProperty(MpmAction.getClientName())) continue;
            LOG.log(Level.INFO, "Adding agent {0} to list of origins for payload {1}", new Object[]{ai.getName(), MpmAction.getName()});
            this.origins.add(ai.getName());
            this.clearOrigins.remove(ai.getName());
        }
    }

    public void disconnected(AgentInfo ... agents) {
        for (AgentInfo ai : agents) {
            if (!ai.hasAgentProperty(MpmAction.getClientName())) continue;
            LOG.log(Level.INFO, "Removing agent {0} from list of origins for payload {1}", new Object[]{ai.getName(), MpmAction.getName()});
            this.removeOrigin(ai.getName());
        }
    }

    public void onAlert(AlertEvent event) {
        String origin = event.getSource();
        if (this.origins.contains(origin)) {
            switch (event.getType()) {
                case AGENT_CONNECTION: {
                    for (RaisedAlertHistory alertHistory : event.getSummary().getAllRaisedAlertHistories()) {
                        this.processAlert(origin, alertHistory.getLatestAlert(), alertHistory.getLatestAlertState());
                    }
                    break;
                }
                case AGENT_DISCONNECTION: {
                    this.removeOrigin(origin);
                    for (MpmAction.Action action : MpmAction.Action.values()) {
                        if (!this.active[action.ordinal()].remove(origin) || !this.active[action.ordinal()].isEmpty()) continue;
                        this.performAction(action, false);
                    }
                    break;
                }
                case ALERT_RAISED: {
                    this.processAlert(origin, event.getAlert(), event.getLevel());
                }
            }
        }
    }

    private synchronized void processAlert(String origin, Alert alert, AlertState state) {
        MpmAction.Action action = MpmAction.getData((Alert)alert);
        if (action != null) {
            boolean on;
            LOG.log(Level.INFO, "Received {0} level alert from {1}: action = {2}", new Object[]{state, origin, action});
            int index = action.ordinal();
            boolean bl = on = state == AlertState.ALARM;
            if (on) {
                this.active[index].add(origin);
            } else {
                this.active[index].remove(origin);
                if (!this.active[index].isEmpty()) {
                    return;
                }
            }
            this.performAction(action, on);
        }
    }

    private void performAction(MpmAction.Action action, boolean on) {
        switch (action) {
            case BLOCK_UT_POWER: {
                this.plutoDevice.setSwitchOn(0, on, true);
                break;
            }
            case BLOCK_REFRIG: {
                this.plutoDevice.setSwitchOn(3, on, true);
                this.plutoDevice.setSwitchOn(5, on, true);
            }
        }
    }

    private void removeOrigin(String origin) {
        if (this.clearOrigins.contains(origin)) {
            this.origins.remove(origin);
            this.clearOrigins.remove(origin);
        } else {
            this.clearOrigins.add(origin);
        }
    }
}

