package org.lsst.ccs.subsystem.utility;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20PWMControl;

/**
 *  Compressor extension to MAQ20 PWM control.
 * 
 *  @author saxton
 */
public class SimMaq20PWMControl extends Maq20PWMControl {

    @LookupPath
    private String path;

    private static final Logger LOG = Logger.getLogger(SimMaq20PWMControl.class.getName());

    @Override
    public void init() {}

    @Override
    public void initialize() {}

    @Override
    public void close() {}


    /**
     *  Sets duty cycle 1.
     *
     *  @param  duty  The duty cycle (0 - 1)
     *  @throws DriverException
     */
    @Override
    public void setDutyCycle1(double duty) throws DriverException
    {
        LOG.log(Level.INFO, "Setting {0} duty cycle to {1}", new Object[]{path, duty});
    }

}
