package org.lsst.ccs.subsystem.utility;

import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.DerivedChannel;

/**
 *  A DerivedChannel to compute the deviation of the measured fan speed from the expected.
 * 
 *  This channel's value does not need to be trended: it's purpose is just to generate
 *  alerts when the deviation exceeds the specified limits.
 *
 *  @author The CCS team
 */
public class FanSpeedErrorChannel extends DerivedChannel {

    @LookupPath
    private String path;

    private Channel speedChannel;
    private FanPIControl fanControl;

   /**
    *  Check that required channels have been specified.
    */
    @Override
    public void postInit() {
        if (speedChannel == null) {
            throw new RuntimeException(path + ": speedChannel has not been specified");
        }
        if (fanControl == null) {
            throw new RuntimeException(path + ": fanControl has not been specified");
        }
    }

   /**
    *  Evaluate the absolute value of the percentage deviation of measured from expected speed.
    *
    *  @return  double 
    */
    @Override
    public double evaluateDerivedValue() {
        return 100.0 * Math.abs((speedChannel.getValue() - fanControl.getRpm()) / fanControl.getMaxRpm());
    }

}

