import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.bootstrap.BootstrapResourceUtils
import org.lsst.ccs.drivers.auxelex.Bfr
import org.lsst.ccs.subsystem.utility.UtilTrunkMain
import org.lsst.ccs.subsystem.utility.FanPIControl
import org.lsst.ccs.subsystem.utility.Maq20DeviceUT
import org.lsst.ccs.subsystem.utility.BfrDeviceUT
import org.lsst.ccs.subsystem.utility.Pdu48VDeviceUT
import org.lsst.ccs.subsystem.utility.VpcControlUT
import org.lsst.ccs.subsystem.utility.TelescopeDevice
import org.lsst.ccs.subsystem.utility.AccumTimeChannel
import org.lsst.ccs.subsystem.utility.WeightedAverageChannel
import org.lsst.ccs.subsystem.utility.HeatTransferChannel
import org.lsst.ccs.subsystem.common.alertaction.MpmActionClient
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20Device
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20PWMControl
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20PulseControl
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20AnalogControl
import org.lsst.ccs.monitor.Alarm
import org.lsst.ccs.monitor.Channel
import org.lsst.ccs.monitor.CalcChannel

CCSBuilder builder = ["utiltrunk"]

builder.main (UtilTrunkMain, utFan: ref("UTFan"), vpcFan: ref("VPCFan"), mpcFan: ref("MPCFan"),
              utValvePosn: ref("UT/ValvePosn"), vpcValvePosn: ref("VPC/ValvePosn"), mpcValvePosn: ref("MPC/ValvePosn"),
              utFanSpeed: ref("UT/FanSpeed"), vpcFanSpeed: ref("VPC/FanSpeed"), mpcFanSpeed: ref("MPC/FanSpeed"),
              utTemps: [ref("UT/W2Q1Temp"), ref("UT/W4Q3Temp"), ref("UT/MidXPlusTemp"), ref("UT/MidXMinusTemp"),
                        ref("UT/TopXPlusTemp"), ref("UT/TopXMinusTemp"), ref("UT/SuppXPlusTemp"), ref("UT/SuppXMinusTemp"),
                        ref("UT/FanInletTemp")]) {

    ActionClient (MpmActionClient)

    UTFlowAlarm (Alarm, description: "UT Coolant flow alarm")

    UTTempLoAlarm (Alarm, description: "UT Low temperature alarm")

    UTTempHiAlarm (Alarm, description: "UT High temperature alarm")

    UTSpeedHiAlarm (Alarm, description: "UT High fan speed alarm")

    UtMaq20 (Maq20DeviceUT, modules: ["DIOL:pwm:pulse", "DIOL:pwm:pulse", "DIOL:pwm:pulse", "IO", "IS", "TTC", "RTD"]) {

       MPCPwm (Maq20PWMControl, modIndex: 1, funcIndex: 0, frequency: 200.0)

       MPCPulse (Maq20PulseControl, modIndex: 1, funcIndex: 1, pulsesPerRevn: 2)

       VPCPwm (Maq20PWMControl, modIndex: 0, funcIndex: 0, frequency: 200.0)

       VPCPulse (Maq20PulseControl, modIndex: 0, funcIndex: 1, pulsesPerRevn: 2)

       UTPwm (Maq20PWMControl, modIndex: 2, funcIndex: 0, frequency: 200.0)

       UTPulse (Maq20PulseControl, modIndex: 2, funcIndex: 1, pulsesPerRevn: 6)

       AnalogOut (Maq20AnalogControl, modIndex: 3, ranges: ["MA4_20", "MA4_20", "MA4_20"])
    }

    BodyMaq20 (Maq20Device, modules: ["IS", "RTD", "RTD", "RTD", "RTD", "RTD"])

    BFR (BfrDeviceUT)

    PDU_48V (Pdu48VDeviceUT)

    Telescope (TelescopeDevice)

    //"Body/MPPlenumInTemp" (Channel, description: "MP plenum in temperature", units: "\u00b0C",
    //                       devcName: "BodyMaq20", hwChan: 0, type: "1", subtype: "R200")

    "Body/VPPlenumInTemp" (Channel, description: "VP plenum in temperature", units: "\u00b0C",
                           devcName: "BodyMaq20", hwChan: 1, type: "1", subtype: "R200")

    "Body/BackFlngYMinusTemp" (Channel, description: "Back flange Y- in temperature", units: "\u00b0C",
                               devcName: "BodyMaq20", hwChan: 2, type: "1", subtype: "R200")

    //"Body/BackFlngYPlusTemp" (Channel, description: "Back flange Y+ in temperature", units: "\u00b0C",
    //                          devcName: "BodyMaq20", hwChan: 3, type: "1", subtype: "R200")

    "Body/BackFlngXMinusTemp" (Channel, description: "Back flange X- in temperature", units: "\u00b0C",
                               devcName: "BodyMaq20", hwChan: 4, type: "1", subtype: "R200")

    //"Body/BackFlngXPlusTemp" (Channel, description: "Back flange X+ in temperature", units: "\u00b0C",
    //                          devcName: "BodyMaq20", hwChan: 5, type: "1", subtype: "R200")

    "Body/DomeXMinusTemp" (Channel, description: "Dome X- air temperature", units: "\u00b0C",
                           devcName: "BodyMaq20", hwChan: 0, type: "2", subtype: "R200")

    "Body/DomeYMinusTemp" (Channel, description: "Dome Y- air temperature", units: "\u00b0C",
                           devcName: "BodyMaq20", hwChan: 1, type: "2", subtype: "R200")

    "Body/CamHousXMinusTemp" (Channel, description: "Camera housing X- temperature", units: "\u00b0C",
                              devcName: "BodyMaq20", hwChan: 2, type: "2", subtype: "R200")

    "Body/CamHousXPlusTemp" (Channel, description: "Camera housing X+ temperature", units: "\u00b0C",
                             devcName: "BodyMaq20", hwChan: 3, type: "2", subtype: "R200")

    "Body/CamHousYMinusTemp" (Channel, description: "Camera housing Y- temperature", units: "\u00b0C",
                              devcName: "BodyMaq20", hwChan: 4, type: "2", subtype: "R200")

    "Body/CamHousYPlusTemp" (Channel, description: "Camera housing Y+ temperature", units: "\u00b0C",
                             devcName: "BodyMaq20", hwChan: 5, type: "2", subtype: "R200")

    //"Body/CamBodyXMinusTemp" (Channel, description: "Camera body X- air temperature", units: "\u00b0C",
    //                          devcName: "BodyMaq20", hwChan: 0, type: "3", subtype: "R200")

    "Body/CamBodyXPlusTemp" (Channel, description: "Camera body X+ air temperature", units: "\u00b0C",
                             devcName: "BodyMaq20", hwChan: 1, type: "3", subtype: "R200")

    "Body/CamBodyYMinusTemp" (Channel, description: "Camera body Y- air temperature", units: "\u00b0C",
                              devcName: "BodyMaq20", hwChan: 2, type: "3", subtype: "R200")

    "Body/CamBodyYPlusTemp" (Channel, description: "Camera body Y+ air temperature", units: "\u00b0C",
                             devcName: "BodyMaq20", hwChan: 3, type: "3", subtype: "R200")

    "Body/ShrdRngXMinusTemp" (Channel, description: "Shroud ring X- temperature", units: "\u00b0C",
                              devcName: "BodyMaq20", hwChan: 4, type: "3", subtype: "R200")

    "Body/ShrdRngXPlusTemp" (Channel, description: "Shroud ring X+ temperature", units: "\u00b0C",
                             devcName: "BodyMaq20", hwChan: 5, type: "3", subtype: "R200")

    //"Body/ShrdRngYMinusTemp" (Channel, description: "Shroud ring Y- temperature", units: "\u00b0C",
    //                          devcName: "BodyMaq20", hwChan: 0, type: "4", subtype: "R200")

    "Body/ShrdRngYPlusTemp" (Channel, description: "Shroud ring Y+ temperature", units: "\u00b0C",
                             devcName: "BodyMaq20", hwChan: 1, type: "4", subtype: "R200")

    "Body/L2XMinusTemp" (Channel, description: "L2 X- temperature", units: "\u00b0C",
                         devcName: "BodyMaq20", hwChan: 2, type: "4", subtype: "R200")

    "Body/L2XPlusTemp" (Channel, description: "L2 X+ temperature", units: "\u00b0C",
                        devcName: "BodyMaq20", hwChan: 3, type: "4", subtype: "R200")

    //"Body/L2YMinusTemp" (Channel, description: "L2 Y- temperature", units: "\u00b0C",
    //                     devcName: "BodyMaq20", hwChan: 4, type: "4", subtype: "R200")

    "Body/L2YPlusTemp" (Channel, description: "L2 Y+ temperature", units: "\u00b0C",
                        devcName: "BodyMaq20", hwChan: 5, type: "4", subtype: "R200")

    "Body/L1XMinusTemp" (Channel, description: "L1 X- temperature", units: "\u00b0C",
                         devcName: "BodyMaq20", hwChan: 0, type: "5", subtype: "R200")

    //"Body/L1XPlusTemp" (Channel, description: "L1 X+ temperature", units: "\u00b0C",
    //                    devcName: "BodyMaq20", hwChan: 1, type: "5", subtype: "R200")

    "Body/L1YMinusTemp" (Channel, description: "L1 Y- temperature", units: "\u00b0C",
                         devcName: "BodyMaq20", hwChan: 2, type: "5", subtype: "R200")

    //"Body/L1YPlusTemp" (Channel, description: "L1 Y+ temperature", units: "\u00b0C",
    //                    devcName: "BodyMaq20", hwChan: 3, type: "5", subtype: "R200")

    "Body/ShtrEboxRtnAirVel" (Channel, description: "Shutter electronics return air velocity", units: "m/s",
                              devcName: "BodyMaq20", hwChan: 6, type: "0", subtype: "MA4_20",
                              scale: 1250.0, offset: -5.0)

    "Body/ShtrEboxRtnAirTemp" (Channel, description: "Shutter electronics return air temperature", units: "\u00b0C",
                               devcName: "BodyMaq20", hwChan: 7, type: "0", subtype: "MA4_20",
                               scale: 6250.0, offset: -50.0)

    "Body/ShtrMtrRtnAirVel" (Channel, description: "Shutter motors return air velocity", units: "m/s",
                             devcName: "BodyMaq20", hwChan: 2, type: "0", subtype: "MA4_20",
                             scale: 1250.0, offset: -5.0)

    "Body/ShtrMtrRtnAirTemp" (Channel, description: "Shutter motors return air temperature", units: "\u00b0C",
                              devcName: "BodyMaq20", hwChan: 3, type: "0", subtype: "MA4_20",
                              scale: 6250.0, offset: -50.0)

    "Body/ChgrYMinusRtnAirVel" (Channel, description: "Autochanger Y- return air velocity", units: "m/s",
                                devcName: "BodyMaq20", hwChan: 4, type: "0", subtype: "MA4_20",
                                scale: 1250.0, offset: -5.0)

    "Body/ChgrYMinusRtnAirTemp" (Channel, description: "Autochanger Y- return air temperature", units: "\u00b0C",
                                 devcName: "BodyMaq20", hwChan: 5, type: "0", subtype: "MA4_20",
                                 scale: 6250.0, offset: -50.0)

    //"Body/ChgrYPlusRtnAirVel" (Channel, description: "Autochanger Y+ return air velocity", units: "m/s",
    //                           devcName: "BodyMaq20", hwChan: 0, type: "0", subtype: "MA4_20",
    //                           scale: 1250.0, offset: -5.0)

    //"Body/ChgrYPlusRtnAirTemp" (Channel, description: "Autochanger Y+ return air temperature", units: "\u00b0C",
    //                            devcName: "BodyMaq20", hwChan: 1, type: "0", subtype: "MA4_20",
    //                            scale: 6250.0, offset: -50.0)

    "Body/AverageTemp" (WeightedAverageChannel, description: "Camera average temperature", units: "\u00b0C",
                        channels: [ref("Body/CamHousXMinusTemp"), ref("Body/CamHousXPlusTemp"), ref("Body/CamHousYMinusTemp"),
                                   ref("Body/CamHousYPlusTemp"), /*ref("Body/CamBodyXMinusTemp"),*/ ref("Body/CamBodyXPlusTemp"),
                                   ref("Body/CamBodyYMinusTemp"), ref("Body/CamBodyYPlusTemp"), ref("Body/ShrdRngXMinusTemp"),
                                   ref("Body/ShrdRngXPlusTemp"), /*ref("Body/ShrdRngYMinusTemp"),*/ ref("Body/ShrdRngYPlusTemp"),
                                   ref("Body/L2XMinusTemp"), ref("Body/L2XPlusTemp"), /*ref("Body/L2YMinusTemp"),*/
                                   ref("Body/L2YPlusTemp"), ref("Body/L1XMinusTemp"), /*ref("Body/L1XPlusTemp"),*/
                                   ref("Body/L1YMinusTemp")/*, ref("Body/L1YPlusTemp")*/],
                        weights: [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0/*, 1.0, 1.0, 1.0, 1.0, 1.0*/])

    "Body/AmbAirtemp" (WeightedAverageChannel, description: "Ambient air temperature", units: "\u00b0C",
                       channels: [ref("Body/DomeXMinusTemp"), ref("Body/DomeYMinusTemp")], weights: [1.0, 1.0])

    "UT/W2Q1Temp" (Channel, description: "UT W2 Q1 temperature", units: "\u00b0C",
                   devcName: "UtMaq20", hwChan: 0, type: "5", subtype: "T220",
                   checkLo: "alarm", alarmLo: "UTTempLoAlarm", checkHi: "alarm", alarmHi: "UTTempHiAlarm")

    "UT/W4Q3Temp" (Channel, description: "UT W4 Q3 temperature", units: "\u00b0C",
                   devcName: "UtMaq20", hwChan: 2, type: "5", subtype: "T220",
                   checkLo: "alarm", alarmLo: "UTTempLoAlarm", checkHi: "alarm", alarmHi: "UTTempHiAlarm")

    "UT/MidXPlusTemp" (Channel, description: "UT Mid-plate X+ temperature", units: "\u00b0C",
                       devcName: "UtMaq20", hwChan: 1, type: "5", subtype: "T220",
                       checkLo: "alarm", alarmLo: "UTTempLoAlarm", checkHi: "alarm", alarmHi: "UTTempHiAlarm")

    "UT/MidXMinusTemp" (Channel, description: "UT Mid-plate X- temperature", units: "\u00b0C",
                        devcName: "UtMaq20", hwChan: 3, type: "5", subtype: "T220",
                        checkLo: "alarm", alarmLo: "UTTempLoAlarm", checkHi: "alarm", alarmHi: "UTTempHiAlarm")

    "UT/TopXPlusTemp" (Channel, description: "UT Top end X+ temperature", units: "\u00b0C",
                       devcName: "UtMaq20", hwChan: 4, type: "5", subtype: "T220",
                       checkLo: "alarm", alarmLo: "UTTempLoAlarm", checkHi: "alarm", alarmHi: "UTTempHiAlarm")

    "UT/TopXMinusTemp" (Channel, description: "UT Top end X- temperature", units: "\u00b0C",
                        devcName: "UtMaq20", hwChan: 5, type: "5", subtype: "T220",
                        checkLo: "alarm", alarmLo: "UTTempLoAlarm", checkHi: "alarm", alarmHi: "UTTempHiAlarm")

    "UT/SuppXPlusTemp" (Channel, description: "UT Support ring X+ temperature", units: "\u00b0C",
                        devcName: "UtMaq20", hwChan: 6, type: "5", subtype: "T220",
                        checkLo: "alarm", alarmLo: "UTTempLoAlarm", checkHi: "alarm", alarmHi: "UTTempHiAlarm")

    "UT/SuppXMinusTemp" (Channel, description: "UT Support ring X- temperature", units: "\u00b0C",
                         devcName: "UtMaq20", hwChan: 7, type: "5", subtype: "T220",
                         checkLo: "alarm", alarmLo: "UTTempLoAlarm", checkHi: "alarm", alarmHi: "UTTempHiAlarm")

    "UT/FanInletTemp" (Channel, description: "UT fan inlet temperature", units: "\u00b0C",
                       devcName: "UtMaq20", hwChan: 3, type: "6", subtype: "R200",
                       checkLo: "alarm", alarmLo: "UTTempLoAlarm", checkHi: "alarm", alarmHi: "UTTempHiAlarm")

    "UT/AverageTemp" (WeightedAverageChannel, description: "UT weighted average temperature", units: "\u00b0C",
                      channels: [ref("UT/W2Q1Temp"), ref("UT/W4Q3Temp"), ref("UT/FanInletTemp"),
                                 ref("UT/MidXPlusTemp"), ref("UT/MidXMinusTemp"), ref("UT/TopXPlusTemp"),
                                 ref("UT/TopXMinusTemp"), ref("UT/SuppXPlusTemp"), ref("UT/SuppXMinusTemp")],
                      weights: [2.0, 2.0, 2.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0])

    "UT/FanSpeed" (Channel, description: "UT fan speed", units: "rpm", format: ".0f",
                   devcName: "UtMaq20", hwChan: Maq20DeviceUT.CHAN_PULSE_RPM, type: "2", subtype: "1",
                   checkHi: "alarm", alarmHi: "UTSpeedHiAlarm")

    "UT/FanRunTime" (AccumTimeChannel, description: "UT fan accumulated run time", units: "hour", format: ".1f",
                     channel: ref("UT/FanSpeed"))

    "UT/CoolFlowRate" (Channel, description: "UT coolant flow rate", units: "gallon/min",
                       devcName: "UtMaq20", hwChan: Maq20DeviceUT.CHAN_UT_FLOW_RATE, type: "4", subtype: "MA4_20",
                       scale: 3500.0, offset: -14.0,  // Calibrated by hand
                       checkLo: "alarm", alarmLo: "UTFlowAlarm")

    "UT/CoolPipeSplyTemp" (Channel, description: "UT coolant pipe supply temperature", units: "\u00b0C",
                           devcName: "UtMaq20", hwChan: 4, type: "6", subtype: "R200",
                           checkHi: "alarm", alarmHi: "UTTempHiAlarm")

    "UT/CoolPipeRetnTemp" (Channel, description: "UT coolant pipe return temperature", units: "\u00b0C",
                           devcName: "UtMaq20", hwChan: 5, type: "6", subtype: "R200")

    "UT/ValvePosn" (Channel, description: "UT coolant valve position", units: "%",
                    devcName: "UtMaq20", hwChan: Maq20DeviceUT.CHAN_UT_VALVE_POSN, type: "4", subtype: "MA4_20")

    "UT/CoolHeatXfer" (HeatTransferChannel, description: "UT coolant heat transfer rate", units: "Watt", format: ".0f",
                       flowChannel: ref("UT/CoolFlowRate"), inletTChannel: ref("UT/CoolPipeSplyTemp"),
                       outletTChannel: ref("UT/CoolPipeRetnTemp"), checkLo: "none", checkHi: "none")

    "UT/DomeXMinusTemp" (Channel, description: "Telescope dome X- temperature", units: "\u00b0C",
                         devcName: "Telescope", hwChan: TelescopeDevice.CHAN_DOME_XMINUS_TEMP)

    "UT/DomeYMinusTemp" (Channel, description: "Telescope dome Y- temperature", units: "\u00b0C",
                         devcName: "Telescope", hwChan: TelescopeDevice.CHAN_DOME_YMINUS_TEMP)

    "VPC/SplyAirVel" (Channel, description: "VPC supply air velocity", units: "m/s",
                      devcName: "UtMaq20", hwChan: Maq20DeviceUT.CHAN_VPC_SPLY_AIR_VEL, type: "4", subtype: "MA4_20",
                      scale: 1250.0, offset: -5.0)

    "VPC/SplyAirTemp" (Channel, description: "VPC supply air temperature", units: "\u00b0C",
                       devcName: "UtMaq20", hwChan: Maq20DeviceUT.CHAN_VPC_SPLY_AIR_TEMP, type: "4", subtype: "MA4_20",
                       scale: 6250.0, offset: -50.0)

    "VPC/RetnAirTemp" (Channel, description: "VPC return air temperature", units: "\u00b0C",
                       devcName: "UtMaq20", hwChan: 2, type: "6", subtype: "R200")

    "VPC/DeltaTempAct" (CalcChannel, description: "VPC actual delta temperature", units: "\u00b0C",
                        type: CalcChannel.Operation.DIFF, channelPaths: ["Body/AverageTemp", "Body/AmbAirtemp"])

    "VPC/FanSpeed" (Channel, description: "VPC fan speed", units: "rpm", format: ".0f",
                    devcName: "UtMaq20", hwChan: Maq20DeviceUT.CHAN_PULSE_RPM, type: "0", subtype: "1")

    "VPC/FanRunTime" (AccumTimeChannel, description: "VPC fan accumulated run time", units: "hour", format: ".1f",
                      channel: ref("VPC/FanSpeed"))

    "VPC/PreFiltPress" (Channel, description: "VPC pre-filter air pressure", units: "in. H\u2082O",
                        devcName: "UtMaq20", hwChan: Maq20DeviceUT.CHAN_VPC_PREFILT_PRESS, type: "4", subtype: "MA4_20",
                        scale: 625.0, offset: -2.5)

    "VPC/SplyPress" (Channel, description: "VPC supply air pressure", units: "in. H\u2082O",
                     devcName: "UtMaq20", hwChan: Maq20DeviceUT.CHAN_VPC_SPLY_PRESS, type: "4", subtype: "MA4_20",
                     scale: 625.0, offset: -2.5)

    "VPC/RetnPress" (Channel, description: "VPC return air pressure", units: "in. H\u2082O",
                     devcName: "UtMaq20", hwChan: Maq20DeviceUT.CHAN_VPC_RETN_PRESS, type: "4", subtype: "MA4_20",
                     scale: 625.0, offset: -2.5)

    "VPC/DeltaPressTotal" (CalcChannel, description: "VPC total delta pressure", units: "in. H\u2082O",
                           type: CalcChannel.Operation.DIFF, channelPaths: ["VPC/PreFiltPress", "VPC/RetnPress"])

    "VPC/DeltaPressFilt" (CalcChannel, description: "VPC filter delta pressure", units: "in. H\u2082O",
                          type: CalcChannel.Operation.DIFF, channelPaths: ["VPC/PreFiltPress", "VPC/SplyPress"])

    "VPC/Humidity" (Channel, description: "VPC relative humidity", units: "%",
                    devcName: "UtMaq20", hwChan: Maq20DeviceUT.CHAN_VPC_HUMIDITY, type: "4", subtype: "MA4_20",
                    scale: 6250.0, offset: -25.0)

    "VPC/ValvePosn" (Channel, description: "VPC coolant valve position", units: "%", format: ".2f",
                     devcName: "UtMaq20", hwChan: Maq20DeviceUT.CHAN_VPC_VALVE_POSN, type: "4", subtype: "MA4_20")

    "VPC/HtrCurrent" (Channel, description: "VPC heater current", units: "mA", format: ".1f",
                      devcName: "BFR", hwChan: Bfr.SENSOR_HTRS, scale: 1000.0)

    "MPC/SplyAirTemp" (Channel, description: "MPC supply air temperature", units: "\u00b0C",
                       devcName: "UtMaq20", hwChan: 1, type: "6", subtype: "R200")

    "MPC/RetnAirTemp" (Channel, description: "MPC return air temperature", units: "\u00b0C",
                       devcName: "UtMaq20", hwChan: 0, type: "6", subtype: "R200")

    "MPC/AvgAirtempOut" (WeightedAverageChannel, description: "MPC average air temperature", units: "\u00b0C",
                         channels: [ref("Body/ShtrEboxRtnAirTemp"), ref("Body/ShtrMtrRtnAirTemp"), ref("Body/ChgrYMinusRtnAirTemp")/*,
                                    ref("Body/ChgrYPlusRtnAirTemp")*/],
                         weights: [1.0, 1.0, 1.0/*, 1.0*/])

    "MPC/DeltaTempAct" (CalcChannel, description: "MPC actual delta temperature", units: "\u00b0C",
                        type: CalcChannel.Operation.DIFF, channelPaths: ["MPC/AvgAirtempOut", "Body/AmbAirtemp"])

    "MPC/FanSpeed" (Channel, description: "MPC fan speed", units: "rpm", format: ".0f",
                    devcName: "UtMaq20", hwChan: Maq20DeviceUT.CHAN_PULSE_RPM, type: "1", subtype: "1")

    "MPC/FanRunTime" (AccumTimeChannel, description: "MPC fan accumulated run time", units: "hour", format: ".1f",
                      channel: ref("MPC/FanSpeed"))

    "MPC/PreFiltPress" (Channel, description: "MPC pre-filter air pressure", units: "in. H\u2082O",
                        devcName: "UtMaq20", hwChan: Maq20DeviceUT.CHAN_MPC_PREFILT_PRESS, type: "4", subtype: "MA4_20",
                        scale: 625.0, offset: -2.5)

    "MPC/SplyPress" (Channel, description: "MPC supply air pressure", units: "in. H\u2082O",
                     devcName: "UtMaq20", hwChan: Maq20DeviceUT.CHAN_MPC_SPLY_PRESS, type: "4", subtype: "MA4_20",
                     scale: 625.0, offset: -2.5)

    "MPC/RetnPress" (Channel, description: "MPC return air pressure", units: "in. H\u2082O",
                     devcName: "UtMaq20", hwChan: Maq20DeviceUT.CHAN_MPC_RETN_PRESS, type: "4", subtype: "MA4_20",
                     scale: 625.0, offset: -2.5)

    "MPC/DeltaPressTotal" (CalcChannel, description: "MPC total delta pressure", units: "in. H\u2082O",
                           type: CalcChannel.Operation.DIFF, channelPaths: ["MPC/PreFiltPress", "MPC/RetnPress"])

    "MPC/DeltaPressFilt" (CalcChannel, description: "MPC filter delta pressure", units: "in. H\u2082O",
                          type: CalcChannel.Operation.DIFF, channelPaths: ["MPC/PreFiltPress", "MPC/SplyPress"])

    "MPC/Humidity" (Channel, description: "MPC relative humidity", units: "%",
                    devcName: "UtMaq20", hwChan: Maq20DeviceUT.CHAN_MPC_HUMIDITY, type: "4", subtype: "MA4_20",
                    scale: 6250.0, offset: -25.0)

    "MPC/ValvePosn" (Channel, description: "MPC coolant valve position", units: "%",
                     devcName: "UtMaq20", hwChan: Maq20DeviceUT.CHAN_MPC_VALVE_POSN, type: "4", subtype: "MA4_20")

    UTFan   (FanPIControl, fan: ref("UtMaq20/UTPwm"), refTempChans: [ref("Body/AmbAirtemp")],
             ctrlTempChans: [ref("UT/AverageTemp")], ctrlTempWeights: [1.0])

    VPCFan  (FanPIControl, fan: ref("UtMaq20/VPCPwm"), refTempChans: [], ctrlTempChans: [], ctrlTempWeights: [])

    VPCHtrs (VpcControlUT, refTempChans: [ref("Body/AverageTemp")], ctrlTempChans: [ref("Body/AmbAirtemp")])

    MPCFan  (FanPIControl, fan: ref("UtMaq20/MPCPwm"), refTempChans: [ref("MPC/AvgAirtempOut")],
             ctrlTempChans: [ref("Body/AmbAirtemp")], ctrlTempWeights: [1.0])

}
