/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.abb;

import java.util.LinkedHashMap;
import java.util.Map;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.abb.Cms;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.modbus.TestModbus;

public class TestCms
extends TestModbus {
    private final Cms cms;

    public TestCms() {
        super(new Cms());
        this.cms = (Cms)this.mod;
    }

    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="ident", description="Device identifier") String ident, @Argument(name="baud", description="Baud rate") int baud) throws DriverException {
        this.cms.open(ident, baud);
    }

    @Command(name="readDC", description="Show DC current")
    public double readDC(@Argument(name="baddr", description="Modbus address") int bAddr, @Argument(name="sensor", description="Sensor number") int sensor) throws DriverException {
        return this.cms.readDC(bAddr, sensor);
    }

    @Command(name="readAC", description="Show AC current")
    public double readAC(@Argument(name="baddr", description="Modbus address") int bAddr, @Argument(name="sensor", description="Sensor number") int sensor) throws DriverException {
        return this.cms.readAC(bAddr, sensor);
    }

    @Command(name="readRMS", description="Show RMS current")
    public double readRMS(@Argument(name="baddr", description="Modbus address") int bAddr, @Argument(name="sensor", description="Sensor number") int sensor) throws DriverException {
        return this.cms.readRMS(bAddr, sensor);
    }

    @Command(name="readMaxDC", description="Show maximum DC current")
    public double readMaxDC(@Argument(name="baddr", description="Modbus address") int bAddr, @Argument(name="sensor", description="Sensor number") int sensor) throws DriverException {
        return this.cms.readMaxDC(bAddr, sensor);
    }

    @Command(name="readMaxAC", description="Show maximum AC current")
    public double readMaxAC(@Argument(name="baddr", description="Modbus address") int bAddr, @Argument(name="sensor", description="Sensor number") int sensor) throws DriverException {
        return this.cms.readMaxAC(bAddr, sensor);
    }

    @Command(name="readMaxRMS", description="Show maximum RMS current")
    public double readMaxRMS(@Argument(name="baddr", description="Modbus address") int bAddr, @Argument(name="sensor", description="Sensor number") int sensor) throws DriverException {
        return this.cms.readMaxRMS(bAddr, sensor);
    }

    @Command(name="readMinDC", description="Show minimum DC current")
    public double readMinDC(@Argument(name="baddr", description="Modbus address") int bAddr, @Argument(name="sensor", description="Sensor number") int sensor) throws DriverException {
        return this.cms.readMinDC(bAddr, sensor);
    }

    @Command(name="readMinAC", description="Show minimum AC current")
    public double readMinAC(@Argument(name="baddr", description="Modbus address") int bAddr, @Argument(name="sensor", description="Sensor number") int sensor) throws DriverException {
        return this.cms.readMinAC(bAddr, sensor);
    }

    @Command(name="readMinRMS", description="Show minimum RMS current")
    public double readMinRMS(@Argument(name="baddr", description="Modbus address") int bAddr, @Argument(name="sensor", description="Sensor number") int sensor) throws DriverException {
        return this.cms.readMinRMS(bAddr, sensor);
    }

    @Command(name="readHeldDC", description="Show held DC current")
    public double readHeldDC(@Argument(name="baddr", description="Modbus address") int bAddr, @Argument(name="sensor", description="Sensor number") int sensor) throws DriverException {
        return this.cms.readHeldDC(bAddr, sensor);
    }

    @Command(name="readHeldAC", description="Show held AC current")
    public double readHeldAC(@Argument(name="baddr", description="Modbus address") int bAddr, @Argument(name="sensor", description="Sensor number") int sensor) throws DriverException {
        return this.cms.readHeldAC(bAddr, sensor);
    }

    @Command(name="readHeldRMS", description="Show held RMS current")
    public double readHeldRMS(@Argument(name="baddr", description="Modbus address") int bAddr, @Argument(name="sensor", description="Sensor number") int sensor) throws DriverException {
        return this.cms.readHeldRMS(bAddr, sensor);
    }

    @Command(name="readAllDC", description="Show all DC currents")
    public Map readAllDC(@Argument(name="baddr", description="Modbus address") int bAddr, @Argument(name="sensor", description="Sensor number") int sensor) throws DriverException {
        LinkedHashMap<String, Double> values = new LinkedHashMap<String, Double>();
        values.put("Curr", this.cms.readDC(bAddr, sensor));
        values.put("Min", this.cms.readMinDC(bAddr, sensor));
        values.put("Max", this.cms.readMaxDC(bAddr, sensor));
        values.put("Held", this.cms.readHeldDC(bAddr, sensor));
        return values;
    }

    @Command(name="readAllAC", description="Show all AC currents")
    public Map readAllAC(@Argument(name="baddr", description="Modbus address") int bAddr, @Argument(name="sensor", description="Sensor number") int sensor) throws DriverException {
        LinkedHashMap<String, Double> values = new LinkedHashMap<String, Double>();
        values.put("Curr", this.cms.readAC(bAddr, sensor));
        values.put("Min", this.cms.readMinAC(bAddr, sensor));
        values.put("Max", this.cms.readMaxAC(bAddr, sensor));
        values.put("Held", this.cms.readHeldAC(bAddr, sensor));
        return values;
    }

    @Command(name="readAllRMS", description="Show all RMS currents")
    public Map readAllRMS(@Argument(name="baddr", description="Modbus address") int bAddr, @Argument(name="sensor", description="Sensor number") int sensor) throws DriverException {
        LinkedHashMap<String, Double> values = new LinkedHashMap<String, Double>();
        values.put("Curr", this.cms.readRMS(bAddr, sensor));
        values.put("Min", this.cms.readMinRMS(bAddr, sensor));
        values.put("Max", this.cms.readMaxRMS(bAddr, sensor));
        values.put("Held", this.cms.readHeldRMS(bAddr, sensor));
        return values;
    }

    @Command(name="showSensor", description="Set whether sensor shows itself")
    public void showSensor(@Argument(name="baddr", description="Modbus address") int bAddr, @Argument(name="sensor", description="Sensor number") int sensor, @Argument(name="show", description="Whether to show") boolean show) throws DriverException {
        this.cms.showSensor(bAddr, sensor, show);
    }

    @Command(name="triggerHold", description="Trigger hold operation")
    public void triggerHold(@Argument(name="baddr", description="Modbus address") int bAddr) throws DriverException {
        this.cms.triggerHold(bAddr);
    }

    @Command(name="resetExtrema", description="Reset minima and maxima")
    public void resetExtrema(@Argument(name="baddr", description="Modbus address") int bAddr) throws DriverException {
        this.cms.resetExtrema(bAddr);
    }
}

