/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import org.hibernate.Query;
import org.hibernate.Session;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.data.RaisedAlertInstance;
import org.lsst.ccs.bus.messages.StatusAlert;
import org.lsst.ccs.bus.messages.StatusClearedAlert;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusRaisedAlert;
import org.lsst.ccs.bus.messages.StatusRaisedAlertSummary;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.localdb.configdb.ConfigurationPersister;
import org.lsst.ccs.localdb.configdb.model.ConfigurationInfoData;
import org.lsst.ccs.localdb.dao.LocaldbFacade;
import org.lsst.ccs.localdb.statusdb.AgentPresenceEvent;
import org.lsst.ccs.localdb.statusdb.BatchPersister;
import org.lsst.ccs.localdb.statusdb.LocalDBAlert;
import org.lsst.ccs.localdb.statusdb.model.AgentDesc;
import org.lsst.ccs.localdb.statusdb.model.AgentState;
import org.lsst.ccs.localdb.statusdb.model.AlertData;
import org.lsst.ccs.localdb.statusdb.model.AlertDesc;
import org.lsst.ccs.localdb.statusdb.model.ClearedAlertData;
import org.lsst.ccs.localdb.statusdb.model.RaisedAlertData;
import org.lsst.ccs.localdb.statusdb.model.StateChangeNotificationData;
import org.lsst.ccs.localdb.statusdb.model.StatusMessageData;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class StatusPersister
extends BatchPersister<Object[]>
implements StatusMessageListener,
AgentPresenceListener,
HasLifecycle {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.localdb.statusdb");
    private final List<String> agentsToCheck = new CopyOnWriteArrayList<String>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationPersister configurationPersister;
    @LookupField(strategy=LookupField.Strategy.TREE)
    AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent subsys;

    public StatusPersister() {
        super(1000, true);
    }

    public void build() {
        this.periodicTaskService.scheduleAgentPeriodicTask(new AgentPeriodicTask("status-accumulator", (Runnable)this).withIsFixedRate(false).withPeriod(Duration.ofSeconds(1L)));
    }

    public void start() {
        this.subsys.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
        this.subsys.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this, BusMessageFilterFactory.messageOrigin(null).and(BusMessageFilterFactory.messageClass(StatusAlert.class).or(BusMessageFilterFactory.messageClass(StatusStateChangeNotification.class).or(BusMessageFilterFactory.messageClass(StatusConfigurationInfo.class)).and(bm -> bm.getOriginAgentInfo().getType().compareTo((Enum)AgentInfo.AgentType.WORKER) >= 0))));
    }

    public void onStatusMessage(StatusMessage msg) {
        if (msg instanceof StatusAlert) {
            StatusAlert statusAlert = (StatusAlert)msg;
            if (statusAlert instanceof StatusRaisedAlert) {
                StatusRaisedAlert statusRaisedAlert = (StatusRaisedAlert)statusAlert;
                String alertId = ((Alert)statusAlert.getEncodedData()).getAlertId();
                String alertDescription = statusRaisedAlert.getCause();
                AlertState currentSeverity = statusRaisedAlert.getRaisedAlertState();
                RaisedAlertData arad = new RaisedAlertData(currentSeverity, alertDescription, msg.getCCSTimeStamp().getUTCInstant().toEpochMilli());
                this.addToQueue(new Object[]{arad, statusAlert, alertId});
            } else if (statusAlert instanceof StatusClearedAlert) {
                StatusClearedAlert sca = (StatusClearedAlert)statusAlert;
                String[] clearedAlerts = sca.getClearAlertIds();
                if (clearedAlerts != null) {
                    for (String clearedId : clearedAlerts) {
                        ClearedAlertData cad = new ClearedAlertData();
                        cad.setTime(msg.getCCSTimeStamp().getUTCInstant().toEpochMilli());
                        this.addToQueue(new Object[]{cad, statusAlert, clearedId});
                    }
                }
            } else if (statusAlert instanceof StatusRaisedAlertSummary && this.agentsToCheck.contains(statusAlert.getOriginAgentInfo().getName())) {
                this.addToQueue(new Object[]{msg, null});
            }
        } else if (msg instanceof StatusStateChangeNotification) {
            StatusStateChangeNotification statusSCN = (StatusStateChangeNotification)msg;
            StateChangeNotificationData scnd = new StateChangeNotificationData();
            scnd.setTime(msg.getCCSTimeStamp().getUTCInstant().toEpochMilli());
            this.addToQueue(new Object[]{scnd, statusSCN});
        } else if (msg instanceof StatusConfigurationInfo) {
            StatusConfigurationInfo sci = (StatusConfigurationInfo)msg;
            ConfigurationInfoData cid = new ConfigurationInfoData();
            cid.setTime(msg.getCCSTimeStamp().getUTCInstant().toEpochMilli());
            this.addToQueue(new Object[]{cid, sci});
        }
    }

    public void connecting(AgentInfo ... agents) {
        for (AgentInfo agent : agents) {
            if (agent.getType().compareTo((Enum)AgentInfo.AgentType.WORKER) < 0) continue;
            this.addToQueue(new Object[]{new AgentPresenceEvent(agent, System.currentTimeMillis(), true)});
            this.agentsToCheck.add(agent.getName());
        }
    }

    public void disconnecting(AgentInfo agent) {
        if (agent.getType().compareTo((Enum)AgentInfo.AgentType.WORKER) >= 0) {
            this.addToQueue(new Object[]{new AgentPresenceEvent(agent, System.currentTimeMillis(), false)});
        }
    }

    private void pushActiveAlerts(String agentName, long agentStartTime, Session sess) {
        this.agentsToCheck.remove(agentName);
        Query q = sess.createQuery("update RaisedAlertData rad set rad.active=FALSE where rad.agentDesc.agentName=:name and rad.active=true and rad.time<=:t");
        q.setString("name", agentName);
        q.setLong("t", agentStartTime);
        int nPushed = q.executeUpdate();
        if (nPushed > 0) {
            log.info((Object)("updated " + nPushed + " active alerts for agent : " + agentName));
        }
    }

    @Override
    public void persist(Object[] obj, Session sess) {
        if (obj[0] instanceof StatusMessageData) {
            StatusMessageData msgData = (StatusMessageData)obj[0];
            StatusMessage statusMsg = (StatusMessage)obj[1];
            AgentInfo ai = statusMsg.getOriginAgentInfo();
            StateBundle state = statusMsg.getState();
            AgentDesc agDesc = LocaldbFacade.getAgentDesc((AgentInfo)ai, (Session)sess);
            msgData.setAgentDesc(agDesc);
            AgentState stateData = LocaldbFacade.getAgentState((AgentDesc)agDesc, (StateBundle)state, (Session)sess);
            msgData.setAgentState(stateData);
            if (msgData instanceof AlertData) {
                AlertData alData = (AlertData)msgData;
                StatusAlert statusAlert = (StatusAlert)statusMsg;
                String alertId = (String)obj[2];
                if (statusAlert instanceof StatusRaisedAlert) {
                    Alert al = ((StatusRaisedAlert)statusAlert).getRaisedAlert();
                    AlertDesc ad = LocaldbFacade.getAlertDescOrPersist((AgentDesc)agDesc, (Alert)al, (Session)sess);
                    alData.setAlertDesc(ad);
                    sess.persist((Object)alData);
                } else if (statusAlert instanceof StatusClearedAlert) {
                    AlertDesc ad = LocaldbFacade.getAlertDesc((AgentDesc)agDesc, (String)alertId, (Session)sess);
                    if (ad != null) {
                        alData.setAlertDesc(ad);
                        sess.persist((Object)alData);
                    } else {
                        log.warn((Object)("could not find description for alert with id " + alertId));
                    }
                    Query q = sess.createQuery("from RaisedAlertData rad where rad.agentDesc.agentName=:name and rad.alertDesc.alertId =:id and rad.active=true").setString("id", alertId).setString("name", agDesc.getAgentName());
                    List res = q.list();
                    for (RaisedAlertData arad : res) {
                        arad.setClearingAlert((ClearedAlertData)alData);
                        sess.update((Object)arad);
                    }
                    log.fine((Object)("cleared " + res.size() + " instances of " + agDesc.getAgentName() + "/" + alertId));
                }
            } else if (msgData instanceof StateChangeNotificationData) {
                StateChangeNotificationData scnd = (StateChangeNotificationData)msgData;
                StateBundle oldState = ((StatusStateChangeNotification)statusMsg).getOldState();
                if (oldState == null) {
                    log.log(Level.WARNING, "Null old state in StateChangeNotificationData for {0}", (Object)ai.getName());
                    return;
                }
                scnd.setOldState(LocaldbFacade.getAgentState((AgentDesc)agDesc, (StateBundle)oldState, (Session)sess));
                if (scnd.getOldState().getId() == scnd.getNewState().getId() && !state.equals((Object)oldState)) {
                    log.warn((Object)("configuration persister considers old state and new state equal (" + scnd.getOldState().getId() + "). Diff actually is :\n" + state.diffState(oldState)));
                    this.alertService.raiseAlert(LocalDBAlert.WrongStatePersistence.addData("oldState", oldState).addData("newState", state).getAlert(null, null), AlertState.WARNING, "for agent " + ai.getName());
                }
                sess.persist((Object)scnd);
            } else if (msgData instanceof ConfigurationInfoData && this.configurationPersister != null) {
                this.configurationPersister.submit(obj);
            }
        } else if (obj[0] instanceof AgentPresenceEvent) {
            AgentPresenceEvent ape;
            if (this.configurationPersister != null) {
                this.configurationPersister.submit(obj);
            }
            if (!(ape = (AgentPresenceEvent)obj[0]).isConnecting()) {
                this.pushActiveAlerts(ape.getAgent().getName(), ape.getTime(), sess);
            }
        } else if (obj[0] instanceof StatusRaisedAlertSummary) {
            StatusRaisedAlertSummary summary = (StatusRaisedAlertSummary)obj[0];
            Set alertHistorySet = summary.getRaisedAlertSummary().getAllRaisedAlertHistories();
            CCSTimeStamp earliestAlertTimestamp = CCSTimeStamp.currentTime();
            for (RaisedAlertHistory alertHistory : alertHistorySet) {
                RaisedAlertInstance earliestRaiseAlert = (RaisedAlertInstance)alertHistory.getRaisedAlertInstancesList().get(0);
                if (!earliestAlertTimestamp.getUTCInstant().isAfter(earliestRaiseAlert.getCCSTimeStamp().getUTCInstant())) continue;
                earliestAlertTimestamp = earliestRaiseAlert.getCCSTimeStamp();
            }
            Instant instant = earliestAlertTimestamp.getUTCInstant().minusMillis(1L);
            this.pushActiveAlerts(summary.getOriginAgentInfo().getName(), instant.getEpochSecond(), sess);
        }
    }
}

