/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.auxelex.Bfr;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.utility.SwitchControl;

public class BfrDeviceUT
extends Device
implements SwitchControl {
    public static final int CHAN_HEATER_1 = 0;
    public static final int CHAN_HEATER_2 = 1;
    private static final String NODE = "node";
    private static final Logger LOG = Logger.getLogger(BfrDeviceUT.class.getName());
    private boolean initError = false;
    @ConfigurationParameter(category="Util", isFinal=true, name="node", units="unitless", description="BFR node number")
    private volatile Integer node;
    private final Bfr bfr = new Bfr();
    private double[] currents = null;

    protected void initDevice() {
        if (this.node == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)NODE, (String)"is missing");
        }
        this.fullName = this.path + " (BFR board at node " + this.node + ")";
    }

    public void initialize() {
        block2: {
            try {
                this.bfr.open(this.node.intValue(), 8193);
                this.initSensors();
                LOG.log(Level.INFO, "Connected to {0}", this.fullName);
                this.initError = false;
                this.setOnline(true);
            }
            catch (DriverException e) {
                if (this.initError) break block2;
                LOG.log(Level.SEVERE, "Error connecting to {0}: {1}", new Object[]{this.fullName, e});
                this.initError = true;
            }
        }
    }

    protected void close() {
        try {
            this.bfr.close();
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error disconnecting from {0}: {1}", new Object[]{this.fullName, e});
        }
    }

    protected int[] checkChannel(Channel ch) throws Exception {
        int hwChan = ch.getHwChan();
        if (hwChan < 0 || hwChan >= 11) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)ch.getPath(), (String)"hw channel number", (Object)hwChan);
        }
        return new int[]{0, 0};
    }

    protected String getGroupForChannel(Channel ch) {
        return "currents";
    }

    protected void readChannelGroup(String group) {
        this.currents = null;
        if (this.isOnline()) {
            try {
                this.currents = this.bfr.readCurrent(Bfr.CurrentType.AC);
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "Error reading {0} currents: {1}", new Object[]{this.fullName, e});
                this.setOnline(false);
            }
        }
    }

    protected double readChannel(Channel ch) {
        return this.currents == null ? Double.NaN : this.currents[ch.getHwChan()];
    }

    @Override
    public int getSwitchDevice() {
        return 0;
    }

    @Override
    public void switchOn(int relay) {
        try {
            this.bfr.setRelayOn(relay);
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error setting relay {0} on {1}: {2}", new Object[]{relay, this.fullName, e});
        }
    }

    @Override
    public void switchOff(int relay) {
        try {
            this.bfr.setRelayOff(relay);
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error setting relay {0} on {1}: {2}", new Object[]{relay, this.fullName, e});
        }
    }

    @Override
    public Boolean isSwitchOn(int relay) {
        if (!this.isOnline() || relay < 0) {
            return null;
        }
        try {
            return this.bfr.isRelayOn(relay);
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error getting state for relay {0} on {1}: {2}", new Object[]{relay, this.fullName, e});
            return null;
        }
    }
}

