/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.dataforth.Maq20;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20AnalogControl;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20Device;
import org.lsst.ccs.subsystem.utility.constants.UtilTrunkValves;
import org.lsst.ccs.subsystem.utility.data.UtilityException;

public class Maq20DeviceUT
extends Maq20Device {
    public static final int CHAN_UT_VALVE_SET = 0;
    public static final int CHAN_VPC_VALVE_SET = 1;
    public static final int CHAN_MPC_VALVE_SET = 2;
    public static final int CHAN_VPC_SPLY_AIR_VEL = 0;
    public static final int CHAN_VPC_SPLY_AIR_TEMP = 1;
    public static final int CHAN_VPC_RETN_PRESS = 2;
    public static final int CHAN_VPC_SPLY_PRESS = 3;
    public static final int CHAN_VPC_PREFILT_PRESS = 4;
    public static final int CHAN_VPC_HUMIDITY = 5;
    public static final int CHAN_MPC_RETN_PRESS = 6;
    public static final int CHAN_MPC_PREFILT_PRESS = 7;
    public static final int CHAN_MPC_SPLY_PRESS = 8;
    public static final int CHAN_MPC_HUMIDITY = 9;
    public static final int CHAN_UT_FLOW_RATE = 10;
    public static final int CHAN_VPC_VALVE_POSN = 11;
    public static final int CHAN_UT_VALVE_POSN = 12;
    public static final int CHAN_MPC_VALVE_POSN = 13;
    public static final int VALVE_SETTLE_TIME = 12000;
    private static final double VALVE_OFFSET = 0.004;
    private static final double VALVE_SCALE = 0.016;
    private static final int[] valveSetChans = new int[3];
    private static final Set<Integer> valveReadChans;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private Maq20AnalogControl maqCtrl;
    private static final Logger LOG;
    private int ctrlModIndex;
    private int currModIndex = -1;
    private final long[] stableValveTime = new long[3];

    public void initDevice() {
        super.initDevice();
        if (this.maqCtrl == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)"analog control", (String)"not defined");
        }
        this.ctrlModIndex = this.maqCtrl.getModIndex();
        for (int ix = 0; ix < this.getModuleCount(); ++ix) {
            Maq20Device.ModuleData modData = this.getModuleData(ix);
            if (modData.modDef.type != Maq20.ModuleType.IS) continue;
            this.currModIndex = ix;
            break;
        }
    }

    protected double readChannel(Channel ch) {
        double value = super.readChannel(ch);
        int hwChan = ch.getHwChan();
        int index = ch.getType() & 0xFF;
        if (index == this.ctrlModIndex) {
            value = 100.0 * (value - 0.004) / 0.016;
        } else if (index == this.currModIndex && valveReadChans.contains(hwChan)) {
            double posn = (value - 0.004) / 0.016;
            value = 100.0 * (hwChan == 13 ? 1.0 - posn : posn);
        }
        return value;
    }

    public void setValvePosition(int valveId, double posn) throws UtilityException {
        int chan = valveSetChans[valveId];
        double value = 0.016 * Math.min(Math.max(chan == 2 ? 1.0 - posn : posn, 0.0), 1.0) + 0.004;
        try {
            this.maqCtrl.writeValue(chan, value);
            this.stableValveTime[valveId] = System.currentTimeMillis() + 12000L;
        }
        catch (DriverException e) {
            throw new UtilityException("Error setting valve " + UtilTrunkValves.getName((int)valveId) + " (channel " + chan + ") position: " + e);
        }
    }

    public double getValvePosition(int valveId) throws UtilityException {
        int chan = valveSetChans[valveId];
        try {
            double posn = (this.maqCtrl.readValue(chan) - 0.004) / 0.016;
            return chan == 2 ? 1.0 - posn : posn;
        }
        catch (DriverException e) {
            throw new UtilityException("Error getting valve " + UtilTrunkValves.getName((int)valveId) + " (channel " + chan + ") position: " + e);
        }
    }

    public long getStableValveTime(int valveId) {
        return this.stableValveTime[valveId];
    }

    @Command(type=Command.CommandType.ACTION, description="Set a simulated channel value")
    public void setChannelValue(@Argument(description="Channel name") String chanName, @Argument(description="Channel value") double value) throws DriverException {
        double val = value;
        Channel chan = (Channel)this.channelMap.get(chanName);
        if (chan != null) {
            int hwChan = chan.getHwChan();
            int index = chan.getType() & 0xFF;
            if (index == this.ctrlModIndex) {
                val = val * 0.016 / 100.0 + 0.004;
            } else if (index == this.currModIndex && valveReadChans.contains(hwChan)) {
                val = (hwChan == 13 ? 100.0 - val : val) * 0.016 / 100.0 + 0.004;
            }
        }
        super.setChannelValue(chanName, val);
    }

    static {
        Maq20DeviceUT.valveSetChans[0] = 0;
        Maq20DeviceUT.valveSetChans[1] = 1;
        Maq20DeviceUT.valveSetChans[2] = 2;
        valveReadChans = new HashSet<Integer>();
        valveReadChans.add(12);
        valveReadChans.add(11);
        valveReadChans.add(13);
        LOG = Logger.getLogger(Maq20DeviceUT.class.getName());
    }
}

