/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility.constants;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.subsystem.utility.data.UtilityException;

public class UtilTrunkFans {
    public static final String FAN_UT = "UtFan";
    public static final String FAN_VPC = "VpcFan";
    public static final String FAN_MPC = "MpcFan";
    public static final int FAN_UT_ID = 0;
    public static final int FAN_VPC_ID = 1;
    public static final int FAN_MPC_ID = 2;
    public static final int NUM_FANS = 3;
    private static final Map<Integer, Integer> fanSwitchMap = new LinkedHashMap<Integer, Integer>();
    private static final Map<String, Integer> fanNameToId = new LinkedHashMap<String, Integer>();
    private static final Map<Integer, String> fanIdToName;
    private static final boolean[] hasTempState;

    public static List<String> getNames() {
        return new ArrayList<String>(fanNameToId.keySet());
    }

    public static String getName(int id) {
        return fanIdToName.get(id);
    }

    public static int getId(String name) throws UtilityException {
        Integer id = fanNameToId.get(name);
        if (id == null) {
            throw new UtilityException("Invalid fan name: " + name);
        }
        return id;
    }

    public static Integer getSwitch(int id) {
        return fanSwitchMap.get(id);
    }

    public static boolean hasTempState(int id) {
        return hasTempState[id];
    }

    static {
        fanNameToId.put(FAN_UT, 0);
        fanNameToId.put(FAN_VPC, 1);
        fanNameToId.put(FAN_MPC, 2);
        fanIdToName = new LinkedHashMap<Integer, String>();
        for (Map.Entry<String, Integer> entry : fanNameToId.entrySet()) {
            fanIdToName.put(entry.getValue(), entry.getKey());
        }
        hasTempState = new boolean[3];
        UtilTrunkFans.hasTempState[0] = true;
        UtilTrunkFans.hasTempState[1] = false;
        UtilTrunkFans.hasTempState[2] = true;
    }
}

