package org.lsst.ccs.subsystem.utility;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20AnalogControl;

/**
 *  Handles a simulated Dataforth Maq20 system analog output module.
 *
 *  @author Owen Saxton
 */
public class SimMaq20AnalogControl extends Maq20AnalogControl {

    private final Map<Integer, Double> chanMap = new HashMap<>();


    /**
     *  Life-cycle initialization.
     */
    @Override
    public void init()
    {
    }


    /**
     *  Post-connection initialization.
     */
    @Override
    public void initialize()
    {
    }


    /**
     *  Pre-closure cleanup.
     */
    @Override
    public void close()
    {
    }


    /**
     *  Writes an analog value.
     *
     *  @param  chan   The channel number
     *  @param  value  The value
     */
    @Override
    public void writeValue(int chan, double value)
    {
        chanMap.put(chan, value);
    }


    /**
     *  Reads an analog value.
     *
     *  @param  chan   The channel number
     *  @return  The value
     */
    @Override
    public double readValue(int chan)
    {
        return chanMap.getOrDefault(chan, 0.0);
    }


    /**
     *  Gets the module index.
     *
     *  @return  The module index
     */
    @Override
    public int getModIndex()
    {
        return 0;
    }

}
