/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility;

import java.util.Arrays;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.common.devices.pluto.PlutoDevice;
import org.lsst.ccs.subsystem.utility.constants.SwitchState;

public class MpmPlutoDevice
extends PlutoDevice {
    private static final int NUM_AREAS = 30;
    private static final int SWDI_ON_BIT = 0;
    private static final int SWDI_OFF_BIT = 1;
    private static final int SWDI_READ_AREA = 2;
    private static final int SWDI_READ_BIT = 3;
    private static final int LTDI_RESET_BIT = 0;
    private static final int LTDI_READ_AREA = 1;
    private static final int LTDI_READ_BIT = 2;
    private static final int LTDI_PEND_AREA = 3;
    private static final int LTDI_PEND_BIT = 4;
    private static final int CNDI_READ_AREA = 0;
    private static final int CNDI_READ_BIT = 1;
    private static final int OFFSET_CELSIUS = -273;
    private static final int[] statusMask = new int[3];
    private static final int[] errorArea;
    private static final int[][] switches;
    private static final int[][] latches;
    private static final int[][] conditions;
    private final int[] tempLimits = new int[4];
    private boolean limitsRead = false;
    private final boolean[] swIsAlarm = new boolean[7];

    public MpmPlutoDevice() {
        super(30);
        Arrays.fill(this.tempLimits, Integer.MAX_VALUE);
    }

    public Boolean isPlcActive(int plc) {
        try {
            int status = this.plu.readModuleStatus();
            return (status & statusMask[plc]) != 0;
        }
        catch (DriverException e) {
            return null;
        }
    }

    protected void setSwitchOn(int sw, boolean on) {
        int bitNum = switches[sw][on ? 0 : 1];
        this.toggleBit(bitNum / 16, bitNum & 0xF);
    }

    public void setSwitchOn(int sw, boolean on, boolean alarm) {
        if (alarm) {
            this.swIsAlarm[sw] = on;
            if (!on) {
                return;
            }
        } else if (!on && this.swIsAlarm[sw]) {
            return;
        }
        this.setSwitchOn(sw, on);
    }

    public SwitchState getSwitchState(int sw) {
        Boolean isOn = this.isSwitchOn(sw);
        return isOn != null ? (isOn.booleanValue() ? (this.swIsAlarm[sw] ? SwitchState.ALARM : SwitchState.ON) : SwitchState.OFF) : SwitchState.OFFLINE;
    }

    protected Boolean isSwitchOn(int sw) {
        int[] swData = switches[sw];
        Integer value = this.readAddBit(swData[2], swData[3] + 16);
        return value != null ? Boolean.valueOf(value != 0) : null;
    }

    public Boolean isLatchActive(int cond) {
        int[] condData = latches[cond];
        Integer value = this.readAddBit(condData[1], condData[2] + 16);
        return value != null ? Boolean.valueOf(value == 0) : null;
    }

    public Boolean isLatchLatched(int cond) {
        int[] condData = latches[cond];
        Integer value = this.readAddBit(condData[3], condData[4] + 16);
        return value != null ? Boolean.valueOf(value != 0) : null;
    }

    public void clearLatch(int cond) {
        int bitNum = latches[cond][0];
        this.toggleBit(bitNum / 16, bitNum & 0xF);
    }

    public Boolean isConditionActive(int cond) {
        int[] condData = conditions[cond];
        Integer value = this.readAddBit(condData[0], condData[1] + 16);
        return value != null ? Boolean.valueOf(value != 0) : null;
    }

    public int[] getTempLimits() {
        if (!this.limitsRead && this.isOnline()) {
            this.tempLimits[1] = this.readAddWord(14, 0) + -273;
            this.tempLimits[0] = this.readAddWord(14, 1) + -273;
            this.tempLimits[3] = this.readAddWord(24, 0) + -273;
            this.tempLimits[2] = this.readAddWord(24, 1) + -273;
            this.limitsRead = true;
        }
        return this.tempLimits;
    }

    public int getErrorCode(int plcNum) {
        return this.readAddWord(errorArea[plcNum], 0);
    }

    static {
        MpmPlutoDevice.statusMask[0] = 2;
        MpmPlutoDevice.statusMask[1] = 4;
        MpmPlutoDevice.statusMask[2] = 8;
        errorArea = new int[3];
        MpmPlutoDevice.errorArea[0] = 1;
        MpmPlutoDevice.errorArea[1] = 16;
        MpmPlutoDevice.errorArea[2] = 26;
        switches = new int[7][];
        MpmPlutoDevice.switches[1] = new int[]{3, 4, 3, 6};
        MpmPlutoDevice.switches[0] = new int[]{5, 6, 3, 1};
        MpmPlutoDevice.switches[2] = new int[]{7, 8, 3, 11};
        MpmPlutoDevice.switches[4] = new int[]{18, 19, 16, 6};
        MpmPlutoDevice.switches[3] = new int[]{20, 21, 17, 6};
        MpmPlutoDevice.switches[6] = new int[]{34, 35, 26, 6};
        MpmPlutoDevice.switches[5] = new int[]{36, 37, 27, 6};
        latches = new int[11][];
        MpmPlutoDevice.latches[0] = new int[]{2, 0, 6, 0, 9};
        MpmPlutoDevice.latches[1] = new int[]{1, 1, 8, 1, 14};
        MpmPlutoDevice.latches[2] = new int[]{1, 1, 5, 1, 13};
        MpmPlutoDevice.latches[3] = new int[]{0, 2, 7, 2, 15};
        MpmPlutoDevice.latches[4] = new int[]{0, 2, 4, 2, 14};
        MpmPlutoDevice.latches[5] = new int[]{16, 16, 2, 16, 4};
        MpmPlutoDevice.latches[6] = new int[]{17, 17, 2, 17, 4};
        MpmPlutoDevice.latches[7] = new int[]{32, 26, 2, 26, 4};
        MpmPlutoDevice.latches[8] = new int[]{33, 27, 2, 27, 4};
        MpmPlutoDevice.latches[9] = new int[]{39, 28, 7, 28, 10};
        MpmPlutoDevice.latches[10] = new int[]{38, 28, 0, 28, 3};
        conditions = new int[7][];
        MpmPlutoDevice.conditions[0] = new int[]{3, 0};
        MpmPlutoDevice.conditions[1] = new int[]{3, 5};
        MpmPlutoDevice.conditions[2] = new int[]{3, 10};
        MpmPlutoDevice.conditions[3] = new int[]{17, 9};
        MpmPlutoDevice.conditions[4] = new int[]{16, 9};
        MpmPlutoDevice.conditions[5] = new int[]{27, 9};
        MpmPlutoDevice.conditions[6] = new int[]{26, 9};
    }
}

