/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility;

import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20PWMControl;

public class FanControl
extends Maq20PWMControl {
    private static final Logger LOG = Logger.getLogger(FanControl.class.getName());
    @ConfigurationParameter(category="Device", isFinal=true)
    private Integer minRpm;
    @ConfigurationParameter(category="Device", isFinal=true)
    private Integer maxRpm;
    @ConfigurationParameter(category="Device", isFinal=true)
    private Double minDutyCycle;
    @ConfigurationParameter(category="Device", isFinal=true)
    private Double maxDutyCycle;
    private double dcSlope;

    public void init() {
        super.init();
        if (this.minRpm == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)"minRpm", (String)"is missing");
        }
        if (this.maxRpm == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)"maxRpm", (String)"is missing");
        }
        if (this.minDutyCycle == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)"minDutyCycle", (String)"is missing");
        }
        if (this.maxDutyCycle == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)"maxDutyCycle", (String)"is missing");
        }
        this.dcSlope = (this.maxDutyCycle - this.minDutyCycle) / (double)(this.maxRpm - this.minRpm);
        if (!Double.isFinite(this.dcSlope)) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)"conversion constants", (String)"are invalid");
        }
    }

    public void setRpm(int rpm) throws DriverException {
        this.setDutyCycle1(this.minDutyCycle + this.dcSlope * (double)(Math.max(this.minRpm, Math.min(this.maxRpm, rpm)) - this.minRpm));
    }

    public int getRpm() throws DriverException {
        return Math.max(this.minRpm, Math.min(this.maxRpm, (int)((double)this.minRpm.intValue() + (this.getDutyCycle1() - this.minDutyCycle) / this.dcSlope)));
    }
}

