/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.MonitorTaskControl;
import org.lsst.ccs.subsystem.utility.FanPIControl;
import org.lsst.ccs.subsystem.utility.Maq20DeviceUT;
import org.lsst.ccs.subsystem.utility.MpmPlutoDevice;
import org.lsst.ccs.subsystem.utility.SwitchControl;
import org.lsst.ccs.subsystem.utility.VpcControlUT;
import org.lsst.ccs.subsystem.utility.constants.FanState;
import org.lsst.ccs.subsystem.utility.constants.HeaterState;
import org.lsst.ccs.subsystem.utility.constants.UtilTrunkAlert;
import org.lsst.ccs.subsystem.utility.constants.UtilTrunkFans;
import org.lsst.ccs.subsystem.utility.constants.UtilTrunkHeaters;
import org.lsst.ccs.subsystem.utility.constants.UtilTrunkValves;
import org.lsst.ccs.subsystem.utility.constants.ValveState;
import org.lsst.ccs.subsystem.utility.constants.VpcControlState;
import org.lsst.ccs.subsystem.utility.data.UtilTrunkState;
import org.lsst.ccs.subsystem.utility.data.UtilityException;

public class UtilTrunkMain
extends Subsystem
implements HasLifecycle,
ClearAlertHandler {
    private static final int[] devNums = new int[3];
    private static final int[] swNums;
    private static final Map<Integer, String> typeMap;
    private static final double VALVE_POSN_TOL = 0.01;
    private static final double RPM_ERROR_WARN = 0.05;
    private static final double RPM_ERROR_ALARM = 0.1;
    private static final int VALVE_SETTLE_TIME = 12000;
    private static final int FAN_SETTLE_TIME = 2000;
    private static final int ALERT_NOMINAL = 0;
    private static final int ALERT_WARNING = 1;
    private static final int ALERT_ALARM = 2;
    private static final int NUM_UT_TEMPS = 9;
    @LookupName
    String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService propertiesService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService configService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private final List<SwitchControl> swDeviceList = new ArrayList<SwitchControl>();
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private VpcControlUT vpcControl;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private Maq20DeviceUT utControl;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private MpmPlutoDevice plc;
    @ConfigurationParameter(category="Util")
    private volatile double maxTemperature;
    private FanPIControl utFan;
    private FanPIControl vpcFan;
    private FanPIControl mpcFan;
    private Channel utValvePosn;
    private Channel vpcValvePosn;
    private Channel mpcValvePosn;
    private Channel utFanSpeed;
    private Channel vpcFanSpeed;
    private Channel mpcFanSpeed;
    private Channel[] utTemps;
    private static final Logger LOG;
    private final SwitchControl[] swDevices = new SwitchControl[2];
    private final UtilTrunkState utilTrunkState = new UtilTrunkState();
    private final FanPIControl[] fanControl = new FanPIControl[3];
    private final Channel[] valvePosnChans = new Channel[3];
    private final boolean[] valvePosnBad = new boolean[3];
    private final Channel[] fanSpeedChans = new Channel[3];
    private final int[] fanSpeedAlerts = new int[3];
    private final Map<String, Boolean> activeAlertMap = new HashMap<String, Boolean>();
    private boolean utOverTemp = false;
    private MonitorTaskControl monitorControl;
    private int alarmDelay = 1;

    public UtilTrunkMain() {
        super("utiltrunk", AgentInfo.AgentType.WORKER);
        this.getAgentInfo().getAgentProperties().setProperty("org.lsst.ccs.use.full.paths", "true");
        System.setProperty("org.lsst.ccs.agent.usesTrending", "true");
    }

    public void build() {
        this.monitorControl = MonitorTaskControl.createNode((Subsystem)this, (String)"MonitorControl");
        AgentPeriodicTask pt = new AgentPeriodicTask("UT-state", () -> this.updateState()).withPeriod(Duration.ofMillis(1000L));
        this.periodicTaskService.scheduleAgentPeriodicTask(pt);
        pt = new AgentPeriodicTask("UT-alarms", () -> this.checkForAlarms()).withPeriod(Duration.ofMillis(1000L));
        this.periodicTaskService.scheduleAgentPeriodicTask(pt);
    }

    public void postInit() {
        this.propertiesService.setAgentProperty("utilTrunkType", ((Object)((Object)this)).getClass().getCanonicalName());
        Iterator<SwitchControl> iterator = this.swDeviceList.iterator();
        while (iterator.hasNext()) {
            SwitchControl sd;
            this.swDevices[sd.getSwitchDevice()] = sd = iterator.next();
        }
        for (int j = 0; j < this.swDevices.length; ++j) {
            if (this.swDevices[j] != null) continue;
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)typeMap.get(j), (String)"has not been defined");
        }
        if (this.utFan == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"utFan", (String)"has not been specified");
        }
        this.fanControl[0] = this.utFan;
        if (this.vpcFan == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"vpcFan", (String)"has not been specified");
        }
        this.fanControl[1] = this.vpcFan;
        if (this.mpcFan == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"mpcFan", (String)"has not been specified");
        }
        this.fanControl[2] = this.mpcFan;
        if (this.utFanSpeed == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"utFanSpeed", (String)"has not been specified");
        }
        this.fanSpeedChans[0] = this.utFanSpeed;
        if (this.vpcFanSpeed == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"vpcFanSpeed", (String)"has not been specified");
        }
        this.fanSpeedChans[1] = this.vpcFanSpeed;
        if (this.mpcFanSpeed == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"mpcFanSpeed", (String)"has not been specified");
        }
        this.fanSpeedChans[2] = this.mpcFanSpeed;
        if (this.utValvePosn == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"utValvePosn", (String)"has not been specified");
        }
        this.valvePosnChans[0] = this.utValvePosn;
        if (this.vpcValvePosn == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"vpcValvePosn", (String)"has not been specified");
        }
        this.valvePosnChans[1] = this.vpcValvePosn;
        if (this.mpcValvePosn == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"mpcValvePosn", (String)"has not been specified");
        }
        this.valvePosnChans[2] = this.mpcValvePosn;
        if (this.utTemps == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"utTemps", (String)"has not been specified");
        }
        if (this.utTemps.length != 9) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"utTemps", (String)"must have exactly 9 elements");
        }
        for (Channel tempChan : this.utTemps) {
            Double value = Double.valueOf(this.configService.getConfigurationParameterValue(tempChan.getPath(), "limitHi"));
            if (value == this.maxTemperature) continue;
            LOG.log(Level.WARNING, "Temperature channel {0} high limit ({1}) is not equal to maxTemperature ({2})", new Object[]{tempChan.getPath(), value, this.maxTemperature});
        }
        if (this.vpcControl == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"VpcControlUT component", (String)"has not been defined");
        }
        if (this.utControl == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"Maq20DeviceUT component", (String)"has not been defined");
        }
        if (this.plc == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"MpmPlutoDevice component", (String)"has not been defined");
        }
        this.utilTrunkState.setHeaterValue(0, this.vpcControl.getDeltaTemp(0));
        this.utilTrunkState.setHeaterValue(1, this.vpcControl.getDeltaTemp(1));
        Arrays.fill(this.valvePosnBad, false);
        Arrays.fill(this.fanSpeedAlerts, 0);
    }

    public void postStart() {
        this.publishState();
        LOG.info("Utility trunk subsystem started");
    }

    @Command(type=Command.CommandType.QUERY, description="Get the full state")
    public UtilTrunkState getFullState() {
        this.utilTrunkState.setTickMillis(this.monitorControl.getPublishPeriod());
        return this.utilTrunkState;
    }

    @Command(type=Command.CommandType.QUERY, description="Get list of fan names")
    public List<String> getFanNames() {
        return UtilTrunkFans.getNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Command(type=Command.CommandType.ACTION, description="Set a fan control state")
    public void setFanState(@Argument(description="The fan name") String name, @Argument(description="The control state") FanState state) throws UtilityException {
        int fanId;
        block12: {
            fanId = UtilTrunkFans.getId((String)name);
            if (state == FanState.OFFLINE) throw new UtilityException("Invalid " + name + " state: " + state);
            if (state == FanState.TEMP && !UtilTrunkFans.hasTempState((int)fanId)) {
                throw new UtilityException("Invalid " + name + " state: " + state);
            }
            UtilTrunkState utilTrunkState = this.utilTrunkState;
            // MONITORENTER : utilTrunkState
            if (state != this.utilTrunkState.getFanBaseState(fanId)) break block12;
            // MONITOREXIT : utilTrunkState
            this.publishState();
            return;
        }
        this.utilTrunkState.setFanBaseState(fanId, state);
        if (this.utilTrunkState.getFanState(fanId) == FanState.OFFLINE) {
            // MONITOREXIT : utilTrunkState
            this.publishState();
            return;
        }
        try {
            this.utilTrunkState.setFanState(fanId, state);
            FanPIControl ctrlr = this.fanControl[fanId];
            if (state == FanState.TEMP) {
                ctrlr.setTemperature(this.utilTrunkState.getDeltaTemp(fanId));
                ctrlr.startLoop(this.utilTrunkState.getFanSpeed(fanId));
                return;
            }
            if (UtilTrunkFans.hasTempState((int)fanId)) {
                ctrlr.stopLoop();
            }
            ctrlr.setSpeed(state == FanState.SPEED ? this.utilTrunkState.getFanSpeed(fanId) : 0.0);
            // MONITOREXIT : utilTrunkState
            return;
        }
        finally {
            this.publishState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set a fan speed")
    public void setFanSpeed(@Argument(description="The fan name") String name, @Argument(description="The fan speed") double speed) throws UtilityException {
        try {
            int fanId = UtilTrunkFans.getId((String)name);
            UtilTrunkState utilTrunkState = this.utilTrunkState;
            synchronized (utilTrunkState) {
                this.utilTrunkState.setFanSpeed(fanId, speed);
                if (this.utilTrunkState.getFanState(fanId) == FanState.SPEED) {
                    this.fanControl[fanId].setSpeed(speed);
                }
            }
        }
        finally {
            this.publishState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set the VPC control state")
    public void setVpcState(@Argument(description="The control state") VpcControlState state) throws UtilityException {
        try {
            UtilTrunkState utilTrunkState = this.utilTrunkState;
            synchronized (utilTrunkState) {
                block14: {
                    if (state != this.utilTrunkState.getVpcState()) break block14;
                    return;
                }
                this.utilTrunkState.setVpcState(state);
                HeaterState h1State = this.utilTrunkState.getHeaterState(0);
                HeaterState h2State = this.utilTrunkState.getHeaterState(1);
                if (state == VpcControlState.TEMP) {
                    if (h1State != HeaterState.OFFLINE) {
                        this.utilTrunkState.setHeaterState(0, HeaterState.TEMP);
                    }
                    if (h2State != HeaterState.OFFLINE) {
                        this.utilTrunkState.setHeaterState(1, HeaterState.TEMP);
                    }
                    this.vpcControl.startLoop();
                } else {
                    this.vpcControl.stopLoop();
                    if (h1State != HeaterState.OFFLINE) {
                        this.utilTrunkState.setHeaterState(0, this.utilTrunkState.getHeaterBaseState(0));
                        this.operateHeater(0);
                    }
                    if (h2State != HeaterState.OFFLINE) {
                        this.utilTrunkState.setHeaterState(1, this.utilTrunkState.getHeaterBaseState(1));
                        this.operateHeater(1);
                    }
                }
            }
        }
        finally {
            this.publishState();
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get list of heater names")
    public List<String> getHeaterNames() {
        return UtilTrunkHeaters.getNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Command(type=Command.CommandType.ACTION, description="Set a heater control state")
    public void setHeaterState(@Argument(description="The heater name") String name, @Argument(description="The control state") HeaterState state) throws UtilityException {
        int htrId;
        block10: {
            htrId = UtilTrunkHeaters.getId((String)name);
            if (state == HeaterState.OFFLINE) throw new UtilityException("Invalid " + name + " state: " + state);
            if (state == HeaterState.TEMP) {
                throw new UtilityException("Invalid " + name + " state: " + state);
            }
            UtilTrunkState utilTrunkState = this.utilTrunkState;
            // MONITORENTER : utilTrunkState
            if (state != this.utilTrunkState.getHeaterBaseState(htrId)) break block10;
            // MONITOREXIT : utilTrunkState
            this.publishState();
            return;
        }
        this.utilTrunkState.setHeaterBaseState(htrId, state);
        HeaterState currState = this.utilTrunkState.getHeaterState(htrId);
        if (currState == HeaterState.OFFLINE || currState == HeaterState.TEMP) {
            // MONITOREXIT : utilTrunkState
            this.publishState();
            return;
        }
        try {
            this.utilTrunkState.setHeaterState(htrId, state);
            this.operateHeater(htrId);
            // MONITOREXIT : utilTrunkState
            return;
        }
        finally {
            this.publishState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set a heater power")
    public void setHeaterValue(@Argument(description="The heater name") String name, @Argument(description="The value") double value) throws UtilityException {
        try {
            int htrId = UtilTrunkHeaters.getId((String)name);
            UtilTrunkState utilTrunkState = this.utilTrunkState;
            synchronized (utilTrunkState) {
                this.utilTrunkState.setHeaterValue(htrId, value);
                if (this.utilTrunkState.getHeaterState(htrId) == HeaterState.TEMP) {
                    this.vpcControl.setDeltaTemp(htrId, value);
                }
            }
        }
        finally {
            this.publishState();
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get list of valve names")
    public List<String> getValveNames() {
        return UtilTrunkValves.getNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Command(type=Command.CommandType.ACTION, description="Set a valve control state")
    public void setValveState(@Argument(description="The valve name") String name, @Argument(description="The control state") ValveState state) throws UtilityException {
        int valveId;
        block10: {
            valveId = UtilTrunkValves.getId((String)name);
            if (state == ValveState.OFFLINE) throw new UtilityException("Invalid " + name + " valve state: " + state);
            if (state == ValveState.TEMP) {
                throw new UtilityException("Invalid " + name + " valve state: " + state);
            }
            UtilTrunkState utilTrunkState = this.utilTrunkState;
            // MONITORENTER : utilTrunkState
            if (state != this.utilTrunkState.getValveBaseState(valveId)) break block10;
            // MONITOREXIT : utilTrunkState
            this.publishState();
            return;
        }
        this.utilTrunkState.setValveBaseState(valveId, state);
        if (this.utilTrunkState.getValveState(valveId) == ValveState.OFFLINE) {
            // MONITOREXIT : utilTrunkState
            this.publishState();
            return;
        }
        try {
            this.utilTrunkState.setValveState(valveId, state);
            this.operateValve(valveId);
            // MONITOREXIT : utilTrunkState
            return;
        }
        finally {
            this.publishState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set a valve position")
    public void setValvePosition(@Argument(description="The valve name") String name, @Argument(description="The valve position") double position) throws UtilityException {
        try {
            int valveId = UtilTrunkValves.getId((String)name);
            UtilTrunkState utilTrunkState = this.utilTrunkState;
            synchronized (utilTrunkState) {
                this.utilTrunkState.setValvePosition(valveId, position);
                this.operateValve(valveId);
            }
        }
        finally {
            this.publishState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set a delta temperature")
    public void setFanDeltaTemp(@Argument(description="The fan name") String name, @Argument(description="The delta temperature") double temp) throws UtilityException {
        try {
            int fanId = UtilTrunkFans.getId((String)name);
            UtilTrunkState utilTrunkState = this.utilTrunkState;
            synchronized (utilTrunkState) {
                this.utilTrunkState.setDeltaTemp(fanId, temp);
                if (this.utilTrunkState.getFanState(fanId) == FanState.TEMP && fanId != 1) {
                    this.fanControl[fanId].setTemperature(temp);
                }
            }
        }
        finally {
            this.publishState();
        }
    }

    private void setSwitchOn(int sw, boolean on) throws UtilityException {
        if (sw < 0 || sw >= 3) {
            throw new UtilityException("Invalid switch number: " + sw);
        }
        if (on) {
            this.swDevices[devNums[sw]].switchOn(swNums[sw]);
        } else {
            this.swDevices[devNums[sw]].switchOff(swNums[sw]);
        }
    }

    private void operateHeater(int htrId) throws UtilityException {
        HeaterState state = this.utilTrunkState.getHeaterState(htrId);
        if (state == HeaterState.OFFLINE || state == HeaterState.TEMP) {
            return;
        }
        this.setSwitchOn(UtilTrunkHeaters.getSwitch((int)htrId), state == HeaterState.ON);
    }

    private void operateValve(int valveId) throws UtilityException {
        ValveState state = this.utilTrunkState.getValveState(valveId);
        if (state == ValveState.OFFLINE || state == ValveState.TEMP) {
            return;
        }
        double position = state == ValveState.SHUT ? 0.0 : this.utilTrunkState.getValvePosition(valveId);
        this.utControl.setValvePosition(valveId, position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateState() {
        UtilTrunkState utilTrunkState = this.utilTrunkState;
        synchronized (utilTrunkState) {
            FanState state;
            boolean changed = this.monitorControl.hasPeriodChanged();
            for (int fan = 0; fan < 3; ++fan) {
                FanState oldState;
                state = oldState = this.utilTrunkState.getFanState(fan);
                if (this.utControl.isOnline()) {
                    if (oldState == FanState.OFFLINE) {
                        Double speed = this.fanControl[fan].getSpeed();
                        this.utilTrunkState.setFanSpeed(fan, speed == null ? 0.0 : Math.rint(1000.0 * speed) / 1000.0);
                        state = speed == null ? FanState.OFFLINE : (speed > 0.0 ? FanState.SPEED : FanState.OFF);
                        this.utilTrunkState.setFanBaseState(fan, state);
                    }
                } else {
                    state = FanState.OFFLINE;
                }
                if (state == oldState) continue;
                this.utilTrunkState.setFanState(fan, state);
                changed = true;
            }
            for (int htr = 0; htr < 2; ++htr) {
                HeaterState state2;
                int sw = UtilTrunkHeaters.getSwitch((int)htr);
                Boolean ss = this.swDevices[devNums[sw]].isSwitchOn(swNums[sw]);
                HeaterState oldState = this.utilTrunkState.getHeaterState(htr);
                HeaterState heaterState = ss == null ? HeaterState.OFFLINE : (this.utilTrunkState.getVpcState() == VpcControlState.TEMP ? HeaterState.TEMP : (state2 = ss != false ? HeaterState.ON : HeaterState.OFF));
                if (state2 == oldState) continue;
                if (state2 != HeaterState.TEMP && state2 != HeaterState.OFFLINE) {
                    this.utilTrunkState.setHeaterBaseState(htr, state2);
                }
                this.utilTrunkState.setHeaterState(htr, state2);
            }
            for (int valve = 0; valve < 3; ++valve) {
                ValveState oldState = this.utilTrunkState.getValveState(valve);
                state = oldState;
                if (this.utControl.isOnline()) {
                    if (oldState == ValveState.OFFLINE) {
                        try {
                            double posn = this.utControl.getValvePosition(valve);
                            this.utilTrunkState.setValvePosition(valve, Math.rint(100.0 * posn) / 100.0);
                            if (posn > 0.0) {
                                this.utilTrunkState.setValveBaseState(valve, ValveState.POSN);
                            }
                            state = this.utilTrunkState.getValveBaseState(valve);
                        }
                        catch (UtilityException e) {
                            LOG.log(Level.SEVERE, "Unexpected error", e);
                        }
                    }
                } else {
                    state = ValveState.OFFLINE;
                }
                if (state == oldState) continue;
                this.utilTrunkState.setValveState(valve, (ValveState)state);
                changed = true;
            }
            if (changed) {
                this.publishState();
            }
        }
    }

    private void publishState() {
        this.utilTrunkState.setTickMillis(this.monitorControl.getPublishPeriod());
        this.publishSubsystemDataOnStatusBus(new KeyValueData("UtilTrunkState", (Serializable)this.utilTrunkState));
    }

    private void checkForAlarms() {
        int id;
        if (this.alarmDelay-- > 0) {
            return;
        }
        boolean overTemp = false;
        for (Channel tempChan : this.utTemps) {
            if (!(tempChan.getValue() > this.maxTemperature)) continue;
            overTemp = true;
            break;
        }
        if (overTemp != this.utOverTemp) {
            this.utOverTemp = overTemp;
            Alert alert = UtilTrunkAlert.OVER_TEMPERATURE.newAlert();
            if (overTemp) {
                this.alertService.raiseAlert(alert, AlertState.ALARM, "A UT temperature went above the limit (" + this.maxTemperature + "). Turning off power.");
            } else {
                this.alertService.raiseAlert(alert, AlertState.NOMINAL, "All UT temperatures are now at or below the limit (" + this.maxTemperature + "). Re-enabling power.");
            }
            this.activeAlertMap.put(alert.getAlertId(), overTemp);
            this.plc.setSwitchOn(1, overTemp);
        }
        for (id = 0; id < 3; ++id) {
            int alertType;
            double readRpm;
            double setRpm = this.fanControl[id].getRpm().intValue();
            if (Double.isNaN(setRpm + (readRpm = this.fanSpeedChans[id].getValue()))) continue;
            double error = Math.abs((readRpm - setRpm) / setRpm);
            int n = error > 0.1 ? 2 : (alertType = error > 0.05 ? 1 : 0);
            if (alertType == this.fanSpeedAlerts[id] || System.currentTimeMillis() - this.fanControl[id].getSpeedSetTime() < 2000L) continue;
            this.fanSpeedAlerts[id] = alertType;
            Alert alert = UtilTrunkAlert.FAN_SPEED_INCORRECT.newAlert(UtilTrunkFans.getName((int)id));
            if (alertType == 2) {
                this.alertService.raiseAlert(alert, AlertState.ALARM, String.format("Read fan speed (%.2f) is not within %s%% of set speed (%.2f)", readRpm, 10.0, setRpm));
            } else if (alertType == 1) {
                this.alertService.raiseAlert(alert, AlertState.WARNING, String.format("Read fan speed (%.2f) is not within %s%% of set speed (%.2f)", readRpm, 5.0, setRpm));
            } else {
                this.alertService.raiseAlert(alert, AlertState.NOMINAL, String.format("Read fan speed is within %s%% of set speed", 5.0));
            }
            this.activeAlertMap.put(alert.getAlertId(), alertType != 0);
        }
        for (id = 0; id < 3; ++id) {
            boolean badPosn;
            double setPosn;
            try {
                setPosn = this.utControl.getValvePosition(id);
            }
            catch (UtilityException e) {
                continue;
            }
            double readPosn = this.valvePosnChans[id].getValue() / 100.0;
            if (Double.isNaN(readPosn)) continue;
            boolean bl = badPosn = Math.abs(readPosn - setPosn) > 0.01;
            if (badPosn == this.valvePosnBad[id] || System.currentTimeMillis() - this.utControl.getValveSetTime(id) < 12000L) continue;
            this.valvePosnBad[id] = badPosn;
            Alert alert = UtilTrunkAlert.VALVE_POSN_INCORRECT.newAlert(UtilTrunkValves.getName((int)id));
            if (badPosn) {
                this.alertService.raiseAlert(alert, AlertState.WARNING, String.format("Read valve position (%.2f%%) is not within %.1f%% of set position (%.2f%%)", 100.0 * readPosn, 1.0, 100.0 * setPosn));
            } else {
                this.alertService.raiseAlert(alert, AlertState.NOMINAL, String.format("Read valve position is within %.1f%% of set position", 1.0));
            }
            this.activeAlertMap.put(alert.getAlertId(), badPosn);
        }
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
        Boolean active = this.activeAlertMap.get(alert.getAlertId());
        return active == null ? ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT : (active != false ? ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT : ClearAlertHandler.ClearAlertCode.CLEAR_ALERT);
    }

    static {
        UtilTrunkMain.devNums[0] = 0;
        UtilTrunkMain.devNums[1] = 0;
        UtilTrunkMain.devNums[2] = 1;
        swNums = new int[3];
        UtilTrunkMain.swNums[0] = 0;
        UtilTrunkMain.swNums[1] = 1;
        UtilTrunkMain.swNums[2] = 3;
        typeMap = new HashMap<Integer, String>();
        typeMap.put(0, "BFR");
        typeMap.put(1, "48V PDU");
        LOG = Logger.getLogger(UtilTrunkMain.class.getName());
    }
}

