package org.lsst.ccs.subsystem.utility;

import org.lsst.ccs.drivers.auxelex.Pdu48VGen;
import org.lsst.ccs.subsystem.utility.constants.PurgeTestSwitches;

/**
 *  Interface to a SLAC 48V (dirty) PDU.
 *
 *  @author Owen Saxton
 */
public class Pdu48VDevicePT extends PduHVDevice {

    public static final int
        CHAN_VPC_FAN = 6,
        CHAN_UT_FAN  = 3,
        CHAN_MPC_FAN = 4;

    public Pdu48VDevicePT()
    {
        super(new Pdu48VGen(), "48V", PurgeTestSwitches.DEVC_PDU_48V);
    }

}
