/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.subsystem.utility.Maq20DeviceUT;
import org.lsst.ccs.subsystem.utility.data.UtilityException;

public class SimMaq20DeviceUT
extends Maq20DeviceUT {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, Channel> allChannels = new HashMap<String, Channel>();
    private static final Logger LOG = Logger.getLogger(SimMaq20DeviceUT.class.getName());
    private final Map<String, Integer> channelMap = new LinkedHashMap<String, Integer>();
    private final List<Double> channelValues = new ArrayList<Double>();
    private final List<Double> channelScales = new ArrayList<Double>();
    private final List<Double> channelOffsets = new ArrayList<Double>();

    protected void initialize() {
        LOG.log(Level.INFO, "Connected to {0} (simulated MAQ20)", this.path);
        this.setOnline(true);
    }

    protected void close() {
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        int index = this.channelValues.size();
        this.channelMap.put(name, index);
        this.channelValues.add(Double.valueOf(index));
        Channel channel = this.allChannels.get(name);
        double offset = 0.0;
        double scale = 1.0;
        if (channel != null) {
            offset = channel.convertRawValue(0.0);
            scale = channel.convertRawValue(1.0) - offset;
        }
        this.channelOffsets.add(offset);
        this.channelScales.add(scale);
        return new int[]{index, 0};
    }

    protected void readChannelGroup() {
    }

    @Override
    protected double readChannel(int hwChan, int type) {
        return (this.channelValues.get(type) - this.channelOffsets.get(type)) / this.channelScales.get(type);
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Set a channel value")
    public void setChannelValue(@Argument(description="Channel name") String chan, @Argument(description="Channel value") double value) throws UtilityException {
        Integer index = this.channelMap.get(chan);
        if (index == null) {
            throw new UtilityException("Invalid channel name");
        }
        this.channelValues.set(index, value);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get the list of channel names")
    public String getChannelNames() {
        return this.channelMap.keySet().toString();
    }
}

