/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.utility.BfrDeviceUT;
import org.lsst.ccs.subsystem.utility.data.UtilityException;

public class VpcControlUT
implements HasLifecycle {
    private static final String VPC = "Vpc";
    private static final Map<Integer, Integer> heaterChans = new HashMap<Integer, Integer>();
    @LookupField(strategy=LookupField.Strategy.TOP)
    Subsystem subsys;
    @LookupName
    private String name;
    @LookupPath
    private String path;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskServices;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private BfrDeviceUT bfrDevc;
    @ConfigurationParameter(category="Vpc", maxLength=2, isFinal=true)
    private volatile double[] deltaTemps = new double[0];
    @ConfigurationParameter(category="Vpc", isFinal=true)
    private volatile Integer updateTime = Integer.MAX_VALUE;
    private List<Channel> refTempChans;
    private List<Channel> ctrlTempChans;
    private static final Logger LOG;
    private boolean active = false;
    private boolean loopFailedRef = false;
    private boolean loopFailedCtrl = false;
    private boolean loopFailedHtr = false;
    private long lastLoopTime;

    public void build() {
        AgentPeriodicTask apt = new AgentPeriodicTask("vpc-loop-" + this.name, () -> this.iterateLoop()).withPeriod(Duration.ofMillis(500L));
        this.periodicTaskServices.scheduleAgentPeriodicTask(apt);
    }

    public void init() {
        if (this.bfrDevc == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)"BfrDevice component", (String)"is missing");
        }
        if (this.refTempChans == null || this.refTempChans.isEmpty()) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)"refTempChans", (String)"is missing or empty");
        }
        if (this.ctrlTempChans == null || this.ctrlTempChans.isEmpty()) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)"ctrlTempChans", (String)"is missing or empty");
        }
        if (this.deltaTemps.length != 2) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)"deltaTemps", (String)"must be of length 2");
        }
        if (this.updateTime == Integer.MAX_VALUE) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.path, (String)"updateTime", (String)"is missing");
        }
    }

    public void setDeltaTemp(int heater, double temp) throws UtilityException {
        this.deltaTemps[heater] = temp;
    }

    public double getDeltaTemp(int heater) {
        return this.deltaTemps[heater];
    }

    public void startLoop() throws UtilityException {
        this.active = true;
    }

    public void stopLoop() throws UtilityException {
        this.active = false;
    }

    public boolean isLoopActive() {
        return this.active;
    }

    private void iterateLoop() {
        double value;
        if (!this.active) {
            return;
        }
        long time = System.currentTimeMillis();
        if (time < this.lastLoopTime + (long)this.updateTime.intValue()) {
            return;
        }
        this.lastLoopTime = time;
        double refTemp = 0.0;
        double ctrlTemp = 0.0;
        int count = 0;
        for (Channel tempChan : this.refTempChans) {
            value = tempChan.getValue();
            if (Double.isNaN(value)) continue;
            refTemp += value;
            ++count;
        }
        if (count > 0) {
            refTemp /= (double)count;
        } else {
            if (!this.loopFailedRef) {
                LOG.severe("Control loop iteration failed: no valid reference temperature values available");
                this.loopFailedRef = true;
            }
            return;
        }
        this.loopFailedRef = false;
        count = 0;
        for (Channel tempChan : this.ctrlTempChans) {
            value = tempChan.getValue();
            if (Double.isNaN(value)) continue;
            ctrlTemp += value;
            ++count;
        }
        if (count <= 0) {
            if (!this.loopFailedCtrl) {
                LOG.severe("Control loop iteration failed: no valid control temperature values available");
                this.loopFailedCtrl = true;
            }
            return;
        }
        this.loopFailedCtrl = false;
        if (!this.setHeaters(refTemp - (ctrlTemp /= (double)count))) {
            if (!this.loopFailedHtr) {
                LOG.severe("Control loop iteration failed: heaters are offline");
                this.loopFailedHtr = true;
            }
            return;
        }
        this.loopFailedHtr = false;
    }

    private boolean setHeaters(double deltaTemp) {
        for (int htrId = 0; htrId < 2; ++htrId) {
            int htrChan = heaterChans.get(htrId);
            Boolean htrOn = this.bfrDevc.isSwitchOn(htrChan);
            if (htrOn == null) {
                return false;
            }
            if (deltaTemp > this.deltaTemps[htrId]) {
                if (htrOn.booleanValue()) continue;
                this.bfrDevc.switchOn(htrChan);
                continue;
            }
            if (!(deltaTemp <= 0.0) || !htrOn.booleanValue()) continue;
            this.bfrDevc.switchOff(htrChan);
        }
        return true;
    }

    static {
        heaterChans.put(0, 0);
        heaterChans.put(1, 1);
        LOG = Logger.getLogger(VpcControlUT.class.getName());
    }
}

