/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.utility.FanPIControl;
import org.lsst.ccs.subsystem.utility.Maq20DevicePT;
import org.lsst.ccs.subsystem.utility.SwitchControl;
import org.lsst.ccs.subsystem.utility.constants.FanState;
import org.lsst.ccs.subsystem.utility.constants.SwitchState;
import org.lsst.ccs.subsystem.utility.constants.UTTestFans;
import org.lsst.ccs.subsystem.utility.constants.UTTestSwitches;
import org.lsst.ccs.subsystem.utility.constants.UTTestValves;
import org.lsst.ccs.subsystem.utility.constants.ValveState;
import org.lsst.ccs.subsystem.utility.data.UTTestState;
import org.lsst.ccs.subsystem.utility.data.UtilityException;

public class UTTestMain
extends Subsystem
implements HasLifecycle {
    private static final int[] devNums = new int[6];
    private static final int[] swNums;
    private static final Map<Integer, String> typeMap;
    private static final Logger LOG;
    @LookupName
    String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService propertiesService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private final List<SwitchControl> swDeviceList = new ArrayList<SwitchControl>();
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private final Map<String, FanPIControl> fanDeviceMap = new LinkedHashMap<String, FanPIControl>();
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private Maq20DevicePT utControl;
    private String utFan;
    private final SwitchControl[] swDevices = new SwitchControl[3];
    private final UTTestState utTestState = new UTTestState();
    private final FanPIControl[] fanControl = new FanPIControl[1];

    public UTTestMain() {
        super("uttest", AgentInfo.AgentType.WORKER);
        this.getAgentInfo().getAgentProperties().setProperty("org.lsst.ccs.use.full.paths", "true");
    }

    public void build() {
        AgentPeriodicTask pt = new AgentPeriodicTask("uttest-state", () -> this.updateState()).withPeriod(Duration.ofMillis(1000L));
        this.periodicTaskService.scheduleAgentPeriodicTask(pt);
    }

    public void postInit() {
        this.propertiesService.setAgentProperty("utTestType", ((Object)((Object)this)).getClass().getCanonicalName());
        Iterator<SwitchControl> iterator = this.swDeviceList.iterator();
        while (iterator.hasNext()) {
            SwitchControl sd;
            this.swDevices[sd.getSwitchDevice()] = sd = iterator.next();
        }
        for (int j = 0; j < this.swDevices.length; ++j) {
            if (this.swDevices[j] != null) continue;
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)typeMap.get(j), (String)"has not been defined");
        }
        if (this.utFan != null) {
            this.fanControl[0] = this.fanDeviceMap.get(this.utFan);
        }
        if (this.fanControl[0] == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"utFan", (String)"not specified or not defined");
        }
        if (this.utControl == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"UTMaq20Device", (String)"has not been defined");
        }
    }

    public void postStart() {
        LOG.info("Utility trunk test subsystem started");
    }

    @Command(type=Command.CommandType.QUERY, description="Get the full state")
    public UTTestState getFullState() {
        this.utTestState.setTickMillis(this.getTickPeriod());
        return this.utTestState;
    }

    @Command(type=Command.CommandType.QUERY, description="Get list of switch names")
    public List<String> getSwitchNames() {
        return new ArrayList<String>(UTTestSwitches.switchNameToId.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Command(type=Command.CommandType.ACTION, description="Turn on/off a named switch")
    public void setSwitchOn(@Argument(description="The switch name") String name, @Argument(description="Whether to turn on") boolean on) throws UtilityException {
        SwitchState state;
        Integer sw;
        block10: {
            sw = (Integer)UTTestSwitches.switchNameToId.get(name);
            if (sw == null) {
                throw new UtilityException("Invalid switch name: " + name);
            }
            UTTestState uTTestState = this.utTestState;
            // MONITORENTER : uTTestState
            SwitchState switchState = state = on ? SwitchState.ON : SwitchState.OFF;
            if (state != this.utTestState.getSwitchBaseState(sw.intValue())) break block10;
            // MONITOREXIT : uTTestState
            this.publishState();
            return;
        }
        this.utTestState.setSwitchBaseState(sw.intValue(), state);
        if (this.utTestState.getSwitchState(sw.intValue()) == SwitchState.OFFLINE) {
            // MONITOREXIT : uTTestState
            this.publishState();
            return;
        }
        try {
            this.utTestState.setSwitchState(sw.intValue(), state);
            this.setSwitchOn(sw, on);
            // MONITOREXIT : uTTestState
            return;
        }
        finally {
            this.publishState();
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get list of fan names")
    public List<String> getFanNames() {
        return new ArrayList<String>(UTTestFans.fanNameToId.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Command(type=Command.CommandType.ACTION, description="Set a fan control state")
    public void setFanState(@Argument(description="The fan name") String name, @Argument(description="The control state") FanState state) throws UtilityException {
        int fanId;
        block14: {
            fanId = this.getFanId(name);
            if (state == FanState.OFFLINE) throw new UtilityException("Invalid " + name + " state: " + state);
            if (state == FanState.TEMP && !UTTestFans.hasTempState[fanId]) {
                throw new UtilityException("Invalid " + name + " state: " + state);
            }
            UTTestState uTTestState = this.utTestState;
            // MONITORENTER : uTTestState
            if (state != this.utTestState.getFanBaseState(fanId)) break block14;
            // MONITOREXIT : uTTestState
            this.publishState();
            return;
        }
        this.utTestState.setFanBaseState(fanId, state);
        if (this.utTestState.getFanState(fanId) == FanState.OFFLINE) {
            // MONITOREXIT : uTTestState
            this.publishState();
            return;
        }
        try {
            this.utTestState.setFanState(fanId, state);
            FanPIControl ctrlr = this.fanControl[fanId];
            if (state == FanState.TEMP) {
                ctrlr.setTemperature(this.utTestState.getDeltaTemp(fanId));
                ctrlr.startLoop(this.utTestState.getFanSpeed(fanId));
            } else {
                if (UTTestFans.hasTempState[fanId]) {
                    ctrlr.stopLoop();
                }
                if (state == FanState.SPEED) {
                    ctrlr.setSpeed(this.utTestState.getFanSpeed(fanId));
                }
            }
            this.setSwitchOn((Integer)UTTestFans.fanSwitchMap.get(fanId), state != FanState.OFF);
            // MONITOREXIT : uTTestState
            return;
        }
        finally {
            this.publishState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set a fan speed")
    public void setFanSpeed(@Argument(description="The fan name") String name, @Argument(description="The fan speed") double speed) throws UtilityException {
        try {
            int fanId = this.getFanId(name);
            UTTestState uTTestState = this.utTestState;
            synchronized (uTTestState) {
                this.utTestState.setFanSpeed(fanId, speed);
                if (this.utTestState.getFanState(fanId) == FanState.SPEED) {
                    this.fanControl[fanId].setSpeed(speed);
                }
            }
        }
        finally {
            this.publishState();
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get list of valve names")
    public List<String> getValveNames() {
        return new ArrayList<String>(UTTestValves.valveNameToId.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Command(type=Command.CommandType.ACTION, description="Set a valve control state")
    public void setValveState(@Argument(description="The valve name") String name, @Argument(description="The control state") ValveState state) throws UtilityException {
        int valveId;
        block10: {
            valveId = this.getValveId(name);
            if (state == ValveState.OFFLINE) throw new UtilityException("Invalid " + name + " state: " + state);
            if (state == ValveState.TEMP) {
                throw new UtilityException("Invalid " + name + " state: " + state);
            }
            UTTestState uTTestState = this.utTestState;
            // MONITORENTER : uTTestState
            if (state != this.utTestState.getValveBaseState(valveId)) break block10;
            // MONITOREXIT : uTTestState
            this.publishState();
            return;
        }
        this.utTestState.setValveBaseState(valveId, state);
        ValveState currState = this.utTestState.getValveState(valveId);
        if (currState == ValveState.OFFLINE || currState == ValveState.TEMP) {
            // MONITOREXIT : uTTestState
            this.publishState();
            return;
        }
        try {
            this.utTestState.setValveState(valveId, state);
            this.operateValve(valveId);
            // MONITOREXIT : uTTestState
            return;
        }
        finally {
            this.publishState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set a valve position")
    public void setValvePosition(@Argument(description="The valve name") String name, @Argument(description="The valve position") double position) throws UtilityException {
        try {
            int valveId = this.getValveId(name);
            UTTestState uTTestState = this.utTestState;
            synchronized (uTTestState) {
                this.utTestState.setValvePosition(valveId, position);
                if (this.utTestState.getValveState(valveId) == ValveState.POSN) {
                    this.operateValve(valveId);
                }
            }
        }
        finally {
            this.publishState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set a delta temperature")
    public void setFanDeltaTemp(@Argument(description="The fan name") String name, @Argument(description="The delta temperature") double temp) throws UtilityException {
        try {
            int fanId = this.getFanId(name);
            UTTestState uTTestState = this.utTestState;
            synchronized (uTTestState) {
                this.utTestState.setDeltaTemp(fanId, temp);
                if (this.utTestState.getFanState(fanId) == FanState.TEMP) {
                    this.fanControl[fanId].setTemperature(temp);
                }
            }
        }
        finally {
            this.publishState();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set the update period")
    public void setUpdatePeriod(@Argument(name="period", description="The tick period (msecs)") int period) {
        this.setTickPeriod(period);
        this.publishState();
    }

    private void setSwitchOn(int sw, boolean on) throws UtilityException {
        if (sw < 0 || sw >= 6) {
            throw new UtilityException("Invalid switch number: " + sw);
        }
        if (on) {
            this.swDevices[devNums[sw]].switchOn(swNums[sw]);
        } else {
            this.swDevices[devNums[sw]].switchOff(swNums[sw]);
        }
    }

    private void operateValve(int valveId) throws UtilityException {
        ValveState state = this.utTestState.getValveState(valveId);
        if (state == ValveState.OFFLINE || state == ValveState.TEMP) {
            return;
        }
        double position = state == ValveState.SHUT ? 0.0 : this.utTestState.getValvePosition(valveId);
        this.utControl.setValve(valveId, position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateState() {
        UTTestState uTTestState = this.utTestState;
        synchronized (uTTestState) {
            boolean changed = false;
            for (int sw = 0; sw < 5; ++sw) {
                SwitchState ss;
                Boolean st = this.swDevices[devNums[sw]].isSwitchOn(swNums[sw]);
                SwitchState switchState = st == null ? SwitchState.OFFLINE : (ss = st != false ? SwitchState.ON : SwitchState.OFF);
                if (ss == this.utTestState.getSwitchState(sw)) continue;
                if (ss != SwitchState.OFFLINE) {
                    this.utTestState.setSwitchBaseState(sw, ss);
                }
                this.utTestState.setSwitchState(sw, ss);
                changed = true;
            }
            for (int fan = 0; fan < 1; ++fan) {
                FanState fs;
                int sw = (Integer)UTTestFans.fanSwitchMap.get(fan);
                Boolean st = this.swDevices[devNums[sw]].isSwitchOn(swNums[sw]);
                FanState fanState = st == null ? FanState.OFFLINE : (fs = st == false ? FanState.OFF : this.utTestState.getFanBaseState(fan));
                if (fs == this.utTestState.getFanState(fan)) continue;
                if (fs != FanState.OFFLINE) {
                    this.utTestState.setFanBaseState(fan, fs);
                }
                this.utTestState.setFanState(fan, fs);
                FanPIControl ctrlr = this.fanControl[fan];
                if (ctrlr != null && fs == FanState.SPEED) {
                    ctrlr.setSpeed(this.utTestState.getFanSpeed(fan));
                }
                changed = true;
            }
            for (int valve = 0; valve < 1; ++valve) {
                ValveState vs;
                ValveState valveState = vs = !this.utControl.isOnline() ? ValveState.OFFLINE : this.utTestState.getValveBaseState(valve);
                if (vs == this.utTestState.getValveState(valve)) continue;
                this.utTestState.setValveState(valve, vs);
                try {
                    this.operateValve(valve);
                }
                catch (UtilityException e) {
                    LOG.log(Level.SEVERE, "Error operating valve {0}: {1}", new Object[]{valve, e});
                }
                changed = true;
            }
            if (changed) {
                this.publishState();
            }
        }
    }

    private void setTickPeriod(long period) {
        this.periodicTaskService.setPeriodicTaskPeriod("monitor-publish", Duration.ofMillis(period));
    }

    private int getTickPeriod() {
        return (int)this.periodicTaskService.getPeriodicTaskPeriod("monitor-publish").toMillis();
    }

    private void publishState() {
        this.utTestState.setTickMillis(this.getTickPeriod());
        this.publishSubsystemDataOnStatusBus(new KeyValueData("UTTestState", (Serializable)this.utTestState));
    }

    private int getFanId(String name) throws UtilityException {
        Integer id = (Integer)UTTestFans.fanNameToId.get(name);
        if (id == null) {
            throw new UtilityException("Invalid fan name: " + name);
        }
        return id;
    }

    private int getValveId(String name) throws UtilityException {
        Integer id = (Integer)UTTestValves.valveNameToId.get(name);
        if (id == null) {
            throw new UtilityException("Invalid valve name: " + name);
        }
        return id;
    }

    static {
        UTTestMain.devNums[1] = 0;
        UTTestMain.devNums[0] = 0;
        UTTestMain.devNums[3] = 1;
        UTTestMain.devNums[4] = 1;
        UTTestMain.devNums[2] = 2;
        UTTestMain.devNums[5] = 2;
        swNums = new int[6];
        UTTestMain.swNums[1] = 3;
        UTTestMain.swNums[0] = 2;
        UTTestMain.swNums[3] = -1;
        UTTestMain.swNums[4] = 1;
        UTTestMain.swNums[2] = -1;
        UTTestMain.swNums[5] = 3;
        typeMap = new HashMap<Integer, String>();
        typeMap.put(0, "BFR");
        typeMap.put(1, "24V PDU");
        typeMap.put(2, "48V PDU");
        LOG = Logger.getLogger(UTTestMain.class.getName());
    }
}

