/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rest.file.server.client.implementation;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.SyncInvoker;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.lsst.ccs.rest.file.server.client.VersionOpenOption;
import org.lsst.ccs.rest.file.server.client.VersionedFileAttributeView;
import org.lsst.ccs.rest.file.server.client.VersionedFileAttributes;
import org.lsst.ccs.rest.file.server.client.VersionedOpenOption;
import org.lsst.ccs.rest.file.server.client.implementation.RestFileAttributes;
import org.lsst.ccs.rest.file.server.client.implementation.RestPath;
import org.lsst.ccs.rest.file.server.client.implementation.RestVersionedFileAttributes;
import org.lsst.ccs.web.rest.file.server.data.IOExceptionResponse;
import org.lsst.ccs.web.rest.file.server.data.RestFileInfo;
import org.lsst.ccs.web.rest.file.server.data.VersionInfo;

class RestClient
implements Closeable {
    private final Client client;
    private final URI restURI;

    RestClient(Client client, URI restURI) {
        this.client = client;
        this.restURI = restURI;
    }

    private URI getRestURI(String restPath, RestPath path) throws IOException {
        return this.restURI.resolve(restPath).resolve(path.getRestPath());
    }

    private WebTarget getRestTarget(String restPath, RestPath path) throws IOException {
        return this.client.target(this.getRestURI(restPath, path));
    }

    InputStream newInputStream(RestPath path, OpenOption[] options) throws IOException {
        URI uri;
        if (path.isVersionedFile()) {
            if (this.hasOption(options, VersionedOpenOption.DIFF)) {
                UriBuilder builder = UriBuilder.fromUri(this.getRestURI("rest/version/diff/", path));
                List<VersionOpenOption> vos = this.getOptions(options, VersionOpenOption.class);
                if (vos.size() > 0) {
                    builder.queryParam("v1", vos.get(0).value());
                    if (vos.size() > 1) {
                        builder.queryParam("v2", vos.get(1).value());
                    }
                }
                uri = builder.build(new Object[0]);
            } else {
                VersionOpenOption vo = this.getOption(options, VersionOpenOption.class);
                if (vo == null) {
                    vo = VersionOpenOption.DEFAULT;
                }
                uri = UriBuilder.fromUri(this.getRestURI("rest/version/download/", path)).queryParam("version", vo.value()).build(new Object[0]);
            }
        } else {
            uri = this.getRestURI("rest/download/", path);
        }
        WebTarget target = this.client.target(uri);
        Response response = target.request("application/octet-stream").get();
        if (response.getStatus() == 404) {
            throw new FileNotFoundException(path.toString());
        }
        this.checkResponse(response);
        return response.readEntity(InputStream.class);
    }

    OutputStream newOutputStream(RestPath path, OpenOption[] options) throws IOException {
        boolean isVersionedFile;
        VersionOpenOption voo = this.getOption(options, VersionOpenOption.class);
        try {
            isVersionedFile = voo != null || path.isVersionedFile();
        }
        catch (IOException x) {
            isVersionedFile = false;
        }
        String restPath = isVersionedFile ? "rest/version/upload/" : "rest/upload/";
        WebTarget target = this.getRestTarget(restPath, path);
        final ArrayBlockingQueue<Future<Response>> queue = new ArrayBlockingQueue<Future<Response>>(1);
        PipedOutputStream out = new PipedOutputStream(){

            @Override
            public void close() throws IOException {
                super.close();
                try {
                    Response response = (Response)((Future)queue.take()).get();
                    RestClient.this.checkResponse(response);
                }
                catch (InterruptedException x) {
                    throw new InterruptedIOException("Interrupt during file close");
                }
                catch (ExecutionException x) {
                    Throwable cause = x.getCause();
                    if (cause instanceof ProcessingException) {
                        throw RestClient.convertProcessingException((ProcessingException)cause);
                    }
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    throw new IOException("Error during file close", cause);
                }
            }
        };
        PipedInputStream in = new PipedInputStream(out);
        Future<Response> futureResponse = target.request("application/json").async().post(Entity.entity(in, "application/octet-stream"));
        queue.add(futureResponse);
        return out;
    }

    DirectoryStream<Path> newDirectoryStream(RestPath path, DirectoryStream.Filter<? super Path> filter) throws IOException {
        Response response = this.getAndCheckResponse(this.getRestTarget("rest/list/", path).request("application/json"));
        RestFileInfo dirList = response.readEntity(RestFileInfo.class);
        List children = dirList.getChildren();
        if (children == null) {
            throw new NotDirectoryException(this.toString());
        }
        final List paths = children.stream().map(fileInfo -> path.resolve(fileInfo.getName())).collect(Collectors.toList());
        return new DirectoryStream<Path>(){

            @Override
            public Iterator<Path> iterator() {
                return paths.iterator();
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    void createDirectory(RestPath path, FileAttribute<?>[] attrs) throws IOException {
        Response response = this.postAndCheckResponse(this.getRestTarget("rest/createDirectory/", path).request("application/json"), null);
    }

    void delete(RestPath path) throws IOException {
        String restPath = path.isVersionedFile() ? "rest/version/deleteFile/" : "rest/deleteFile/";
        Response response = this.deleteAndCheckResponse(this.getRestTarget(restPath, path).request("application/json"));
    }

    void move(RestPath source, RestPath target, CopyOption[] options) throws IOException {
        URI uri = UriBuilder.fromUri(this.getRestURI("rest/move/", source)).queryParam("target", target.getRestPath()).build(new Object[0]);
        Response response = this.postAndCheckResponse(this.client.target(uri).request("application/json"), null);
    }

    void checkAccess(RestPath path, AccessMode ... modes) throws IOException {
        Response response = this.getAndCheckResponse(this.getRestTarget("rest/list/", path).request("application/json"));
        response.readEntity(RestFileInfo.class);
    }

    BasicFileAttributes getAttributes(RestPath path, LinkOption[] options) throws IOException {
        RestFileInfo info = this.getRestFileInfo(path);
        if (info.isVersionedFile()) {
            VersionInfo vinfo = this.getVersionedRestFileInfo(path);
            RestFileInfo latest = (RestFileInfo)vinfo.getVersions().get(vinfo.getDefault() - 1);
            latest.setVersionedFile(true);
            return new RestFileAttributes(latest);
        }
        return new RestFileAttributes(info);
    }

    VersionedFileAttributes getVersionedAttributes(RestPath path, LinkOption[] options) throws IOException {
        if (!path.isVersionedFile()) {
            throw new IOException("Cannot read versioned attributes for non-versioned file");
        }
        Response response = this.getAndCheckResponse(this.getRestTarget("rest/version/info/", path).request("application/json"));
        VersionInfo info = response.readEntity(VersionInfo.class);
        return new RestVersionedFileAttributes(info);
    }

    BasicFileAttributeView getFileAttributeView(final RestPath path, final LinkOption[] options) {
        return new BasicFileAttributeView(){

            @Override
            public String name() {
                return "basic";
            }

            @Override
            public BasicFileAttributes readAttributes() throws IOException {
                return RestClient.this.getAttributes(path, options);
            }

            @Override
            public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }

    VersionedFileAttributeView getVersionedAttributeView(final RestPath path, final LinkOption[] options) {
        return new VersionedFileAttributeView(){

            @Override
            public void setDefaultVersion(int version) throws IOException {
                Response response = RestClient.this.putAndCheckResponse(RestClient.this.getRestTarget("rest/version/set/", path).request("application/json"), Entity.entity(Integer.valueOf(version), "application/json"));
            }

            @Override
            public String name() {
                return "versioned";
            }

            @Override
            public VersionedFileAttributes readAttributes() throws IOException {
                return RestClient.this.getVersionedAttributes(path, options);
            }
        };
    }

    Map<String, Object> readAttributes(RestPath path, String attributes, LinkOption[] options) throws IOException {
        RestFileInfo restFileInfo = this.getRestFileInfo(path);
        Map result = restFileInfo.toMap();
        if (restFileInfo.isVersionedFile()) {
            result.putAll(this.getVersionedRestFileInfo(path).toMap());
        }
        return result;
    }

    private VersionInfo getVersionedRestFileInfo(RestPath path) throws IOException {
        Response response = this.getAndCheckResponse(this.getRestTarget("rest/version/info/", path).request("application/json"));
        VersionInfo info = response.readEntity(VersionInfo.class);
        return info;
    }

    RestFileInfo getRestFileInfo(RestPath path) throws IOException {
        Response response = this.getAndCheckResponse(this.getRestTarget("rest/info/", path).request("application/json"));
        RestFileInfo info = response.readEntity(RestFileInfo.class);
        return info;
    }

    private Response getAndCheckResponse(SyncInvoker invoker) throws IOException {
        try {
            Response response = invoker.get();
            this.checkResponse(response);
            return response;
        }
        catch (ProcessingException x) {
            throw RestClient.convertProcessingException(x);
        }
    }

    private Response putAndCheckResponse(Invocation.Builder request, Entity<?> entity) throws IOException {
        try {
            Response response = request.put(entity);
            this.checkResponse(response);
            return response;
        }
        catch (ProcessingException x) {
            throw RestClient.convertProcessingException(x);
        }
    }

    private Response postAndCheckResponse(Invocation.Builder request, Entity<?> entity) throws IOException {
        try {
            Response response = request.post(entity);
            this.checkResponse(response);
            return response;
        }
        catch (ProcessingException x) {
            throw RestClient.convertProcessingException(x);
        }
    }

    private Response deleteAndCheckResponse(Invocation.Builder request) throws IOException {
        try {
            Response response = request.delete();
            this.checkResponse(response);
            return response;
        }
        catch (ProcessingException x) {
            throw RestClient.convertProcessingException(x);
        }
    }

    static IOException convertProcessingException(ProcessingException x) {
        if (x.getCause() instanceof IOException) {
            return (IOException)x.getCause();
        }
        return new IOException("Error talking to rest server", x);
    }

    private void checkResponse(Response response) throws IOException {
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            if (response.getStatus() == 406) {
                IOExceptionResponse ioError = response.readEntity(IOExceptionResponse.class);
                try {
                    Class<IOException> exceptionClass = Class.forName(ioError.getExceptionClass()).asSubclass(IOException.class);
                    Constructor<IOException> constructor = exceptionClass.getConstructor(String.class);
                    IOException io = constructor.newInstance(ioError.getMessage());
                    throw io;
                }
                catch (ReflectiveOperationException ex) {
                    throw new IOException("Remote Exception " + ioError.getExceptionClass() + " " + ioError.getMessage());
                }
            }
            throw new IOException("Response code " + response.getStatus() + " " + response.getStatusInfo());
        }
    }

    private <T extends OpenOption> T getOption(OpenOption[] options, Class<T> optionClass) {
        for (OpenOption option : options) {
            if (!optionClass.isInstance(option)) continue;
            return (T)((OpenOption)optionClass.cast(option));
        }
        return null;
    }

    private <T extends OpenOption> List<T> getOptions(OpenOption[] options, Class<T> optionClass) {
        ArrayList<T> result = new ArrayList<T>();
        for (OpenOption option : options) {
            if (!optionClass.isInstance(option)) continue;
            result.add(optionClass.cast(option));
        }
        return result;
    }

    private boolean hasOption(OpenOption[] options, Enum<?> search) {
        for (OpenOption option : options) {
            if (!search.equals(option)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }
}

